package framework.config;

import framework.runtime.SystemContext;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@ConfigurationProperties(prefix = "server")
public class ServerConfig {

    /**
     * 应用路径
     */
    private Integer port;


    private static ServerConfig _instance = null;

    private static ServerConfig instance() {
        if (_instance == null) {
            _instance = SystemContext.getBean(ServerConfig.class);
        }
        return _instance;
    }
}
