package framework.config;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Slf4j
@Configuration
@ConfigurationProperties(prefix = "sys.s3")
public class S3Config {

    private String name;
    private String accessKey;
    private String secretKey;
    private String region;
    private String bucket;
    private String endPoint;
    private Boolean pathStyle;
    private Boolean chunkedEncoding = true;
    //内存交换最大值（值必需大于等于 partSize)
    private Integer saveMemoryMax = 20 * 1024 * 1024;
    //分片大小 (值必需大于5M)
    // S3 默认允许 10,000 个分块，每块最大值5GB 即最大50TB单文件，S3实际限制最大5TB单文件
    // 系统默认 10MB × 10,000 = 100,000MB = 100,000 ÷ 1024 ≈ 97.66GB 最大允许97.66GB
    // 20MB × 10,000 = 200,000MB = 200,000 ÷ 1024 ≈ 195.31GB 最大允许195.31GB
    // 50MB × 10,000 = 500,000MB = 500,000 ÷ 1024 ≈ 488.28GB 最大允许488.28GB
    // 依据系统内存和用户使用量级，单配置 100MB ≈ 1TB(内存可能溢出)
    // 依据系统内存和用户使用量级，单配置 500MB ≈ 5TB(内存可能溢出)
    private Integer partSize = 10 * 1024 * 1024;
    /**
     * 启用压缩的路径前缀
     */
    private String[] compressPathStarts;
    /**
     * 管理路径名, 路径中的第1个片段
     */
    private String[] managers;

}
