package framework.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 一般性加密配置
 */
@Data
@Configuration
@ConfigurationProperties("sys.crypto.general")
public class GeneralCryptoConfig {

    /**
     * 算法
     */
    private String cipher = "RSA/ECB/PKCS1Padding";
    /**
     * 算法提供者
     */
    private String provider = null;
    /**
     * 私钥路径
     */
    private String privateKeyPath = null;

}
