package framework.config;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Slf4j
@Configuration
@ConfigurationProperties(prefix = "file.manager")
public class FileManagerConfig {

    /**
     * 启禁用
     */
    private Boolean enable = false;

    /**
     * 默认实例名
     */
    private String defaultName;

    /**
     * 启用压缩的路径前缀
     */
    private String[] compressPathStarts;

    /**
     * 本地文件组配置
     */
    private FileConfig[] files;

    /**
     * s3文件组配置
     */
    private S3Config[] s3s;

    /**
     * https文件组配置
     */
    private FileStorageHttpConfig[] https;

}
