package framework.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@ConfigurationProperties(prefix = "sys.file")
public class FileConfig {

    /**
     * 名称
     */
    private String name;

    /**
     * 临时存储目标
     */
    private String tmpPath;

    /**
     * 应用存储根目录
     */
    private String storagePath;

    /**
     * 存储类型
     */
    private String storageType;

    /**
     * 启用压缩的路径前缀
     */
    private String[] compressPathStarts;

    /**
     * 管理路径名, 路径中的第1个片段
     */
    private String[] managers;

}
