package framework.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 一般性加密配置
 */
@Data
@Configuration
@ConfigurationProperties("sys.crypto.aes")
public class AESCryptoConfig {

    /**
     * 加密算法
     */
    private String algorithm = "AES";

    /**
     * 加密解密算法/加密模式/填充方式
     */
//    private String cipherAlgorithm = "AES/CBC/PKCS5Padding";
    private String cipherAlgorithm = "AES/GCM/NoPadding";

    /**
     * 密钥
     */
    private String secretKey;

    /**
     * 加密密钥索引项，当配置该值时AESCrypto将以AESCryptoPlus实现，允许配置多个密钥
     */
    private Integer secretIndex;

    public AESCryptoConfig() {

    }

    public AESCryptoConfig(String secretKey) {
        this.secretKey = secretKey;
    }

}
