package framework.client;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

public class WebUserAgent {
    @Getter
    private String os = "unknown";
    @Getter
    private String browser = "unknown";
    @Getter
    private String userAgent = "";

    public WebUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.parse(userAgent);
    }

    public WebUserAgent(HttpServletRequest request) {
        String ua = request.getHeader("user-agent");
        if (StringUtils.isBlank(ua)) {
            ua = "unknown";
        }
        this.userAgent = ua;
        this.parse(ua);
    }

    private void parse(String userAgent) {
        if (StringUtils.isBlank(userAgent)) return;

        //
        String ua = userAgent.toLowerCase();
        String os = "unknown";
        String browser = "unknown";

        // =================OS=======================
        if (ua.contains("windows")) {
            os = "Windows";
        } else if (ua.contains("mac")) {
            os = "Mac";
        } else if (ua.contains("android")) {
            os = userAgent.substring(ua.indexOf("android")).split(";")[0];
        } else if (ua.indexOf("iphone") >= 0) {
            os = "IPhone";
        } else if (ua.contains("linux")) {
            os = "Linux";
        } else if (ua.contains("x11")) {
            os = "Unix";
        } else {
            os = "unknown";
        }

        // ===============Browser===========================
        if (ua.contains("edge")) {
            browser = (userAgent.substring(ua.indexOf("edge")).split(" ")[0]).replace("/", "-");
        } else if (ua.contains("ucbrowser")) {
            browser = (ua.substring(ua.indexOf("ucbrowser")).split(" ")[0]).replace("/", "-").replace("ucbrowser", "UC浏览器");
        } else if (ua.contains("ubrowser")) {
            browser = (ua.substring(ua.indexOf("ubrowser")).split(" ")[0]).replace("/", "-").replace("ubrowser", "UC浏览器");
        } else if (ua.contains("msie")) {
            String substring = userAgent.substring(ua.indexOf("msie")).split(";")[0];
            browser = substring.replace("MSIE", "IE").replace(" ", "-");
        } else if (ua.contains("safari") && ua.contains("version")) {
            browser = (userAgent.substring(userAgent.indexOf("Safari")).split(" ")[0]).split("/")[0] + "-" + (userAgent.substring(userAgent.indexOf("Version")).split(" ")[0]).split("/")[1];
        } else if (ua.contains("opr")) {
            browser = ((userAgent.substring(ua.indexOf("opr")).split(" ")[0]).replace("/", "-")).replace("OPR", "Opera");
        } else if (ua.contains("opera")) {
            browser = (userAgent.substring(ua.indexOf("opera")).split(" ")[0]).split("/")[0] + "-" + (userAgent.substring(ua.indexOf("version")).split(" ")[0]).split("/")[1];
        } else if (ua.contains("chrome")) {
            browser = (userAgent.substring(userAgent.indexOf("Chrome")).split(" ")[0]).replace("/", "-");
        } else if (ua.contains("firefox")) {
            browser = (userAgent.substring(userAgent.indexOf("Firefox")).split(" ")[0]).replace("/", "-");
        } else if (ua.contains("rv")) {
            String IEVersion = (userAgent.substring(userAgent.indexOf("rv")).split(" ")[0]).replace("rv:", "-");
            browser = "IE" + IEVersion.substring(0, IEVersion.length() - 1);
        } else {
            browser = "unknown";
        }

        this.os = os;
        this.browser = browser;
    }
}

