package framework.captcha;

import framework.utils.JsonUtil;
import framework.vo.ResultInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cache.Cache;
import org.springframework.util.StringUtils;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * 以Base64输出的验证码处理器
 */
@Slf4j
public class CaptchaBase64 extends CaptchaBase implements CaptchaServlet {

    public CaptchaBase64(Cache cache) {
        super(cache);
    }

    public CaptchaBase64(Cache cache, CaptchaGenerator generator) {
        super(cache, generator);
    }

    @Override
    public void output(HttpServletRequest req, HttpServletResponse resp, String id) throws IOException {
        if (!StringUtils.hasLength(id)) {
            resp.setStatus(400);
            resp.getWriter().write("not set param id");
            return;
        }

        //
        if (this.getCache() == null) {
            resp.setStatus(500);
            resp.getWriter().write("not set cache");
            log.warn("Verification: not set cache");
            return;
        }

        //
        CaptchaInfo captchaInfo = this.newCaptcha(id);

        //
        String base64;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream()) {
            ImageIO.write(captchaInfo.getImage(), "jpeg", outputStream);
            base64 = Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        //
        Map<String, String> map = new HashMap<>();
        map.put("image_base", "data:image/png;base64," + base64);
        map.put("id", id);

        //
        ResultInfo<Object> resultInfo = new ResultInfo<>(map);

        //
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setDateHeader("Expires", 0);
        //
        resp.setContentType("application/json");
        String s = JsonUtil.toJsonString(resultInfo);
        //
        resp.getWriter().write(s);
    }

}
