package framework.base;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 服务基础类型
 *
 * @param <R>
 * @param <Q>
 */
public interface ListQueryService<R, Q> {

    /**
     * 返回数据操作对象
     *
     * @return
     */
    Mapper getMapper();

    /**
     * 查询列表
     *
     * @param query
     * @return
     */
    @SuppressWarnings("unchecked")
    default List<R> listQuery(Q query) {
        ListQueryMapper<R, Q> mapper = (ListQueryMapper<R, Q>) this.getMapper();
        return mapper.listQuery(query);
    }

    /**
     * 查询列表
     *
     * @param query
     * @param size
     * @return
     */
    default PageInfo<R> listQuery(Q query, int size) {
        PageHelper.startPage(1, size, false);
        return PageInfo.of(listQuery(query));
    }

    /**
     * 查询列表
     *
     * @param query
     * @param pageIndex
     * @param pageSize
     * @return
     */
    default PageInfo<R> listQuery(Q query, int pageIndex, int pageSize) {
        PageHelper.startPage(pageIndex, pageSize, true);
        return PageInfo.of(listQuery(query));
    }

    /**
     * 查询列表中的第一项
     *
     * @param query
     * @return
     */
    default R listQueryOne(Q query) {
        PageHelper.startPage(1, 1, false);
        List<R> list = listQuery(query);
        return list.size() == 0 ? null : list.get(0);
    }

    /**
     * 使用查询对象统计数量, 对于大量数据性能可能表现不好，建议另建专用方法
     *
     * @param query
     * @return
     */
    default long listQueryCount(Q query) {
        PageHelper.startPage(1, 0, true);
        return PageInfo.of(listQuery(query)).getTotal();
    }
}