package framework.base;

import tk.mybatis.mapper.common.Mapper;

import java.util.List;
import java.util.function.BiConsumer;

/**
 * 服务基础类型
 */
public interface BatchService<T, M extends Mapper<T>> {

    default int getBatchSize() {
        return SqlExecutor.BATCH_DEFAULT_SIZE;
    }

    /**
     * 返回数据操作对象
     *
     * @return
     */
    Class<M> getMapperClass();

    /**
     * 添加新数据
     *
     * @param dataList
     * @return
     */
    default int batchAdd(List<T> dataList) {
        return SqlExecutor.batchAdd(getBatchSize(), dataList, getMapperClass());
    }

    /**
     * 添加新数据
     *
     * @param dataList
     * @return
     */
    default int batchUpdate(List<T> dataList) {
        return SqlExecutor.batchUpdate(getBatchSize(), dataList, getMapperClass());
    }

    /**
     * 添加新数据
     *
     * @param dataList
     * @return
     */
    default int batchDelete(List<T> dataList) {
        return SqlExecutor.batchDelete(getBatchSize(), dataList, getMapperClass());
    }

    /**
     * 添加新数据
     *
     * @param dataList
     * @return
     */
    default int batchDeletePK(List<T> dataList) {
        return SqlExecutor.batchDeletePK(getBatchSize(), dataList, getMapperClass());
    }

    /**
     * 添加新数据
     *
     * @param dataList
     * @param sqlId
     * @return
     */
    default int batchAdd(List<T> dataList, String sqlId) {
        return SqlExecutor.batchAdd(getBatchSize(), dataList, sqlId);
    }

    /**
     * 添加新数据
     *
     * @param dataList
     * @param sqlId
     * @return
     */
    default int batchUpdate(List<T> dataList, String sqlId) {
        return SqlExecutor.batchUpdate(getBatchSize(), dataList, sqlId);
    }

    /**
     * 添加新数据
     *
     * @param dataList
     * @param sqlId
     * @return
     */
    default int batchDelete(List<T> dataList, String sqlId) {
        return SqlExecutor.batchDelete(getBatchSize(), dataList, sqlId);
    }

    /**
     * 添加新数据
     *
     * @param dataList
     * @param function
     * @return
     */
    default int batchExecute(List<T> dataList, BiConsumer<M, T> function) {
        return SqlExecutor.batchExecute(getBatchSize(), dataList, getMapperClass(), function);
    }
}