package framework.base;

import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 数据对象基础类型
 *
 * @param <T>
 * @param <K>
 */
public interface BaseMapper<T, K> extends tk.mybatis.mapper.common.Mapper<T>, DynamicUpdateMapper<T>, LoadPrimaryKeyMapper<T> {

    /**
     * 添加新数据
     *
     * @param param
     * @return
     */
    default Integer add(T param) {
        Integer result = this.insertSelective(param);
        return result;
    }

    /**
     * 依据对象参数更新数据
     *
     * @param param
     * @return
     */
    default Integer update(T param) {
        Integer result = this.updateByPrimaryKeySelective(param);
        return result;
    }

    /**
     * 依据主键删除数据
     *
     * @param id
     * @return
     */
    default Integer deleteById(K id) {
        Integer result = this.deleteByPrimaryKey(id);
        return result;
    }

    /**
     * 依据查询参数返回数据
     *
     * @param param
     * @return
     */
    List<T> list(T param);

    /**
     * 依据对象参数返回结果只有唯一一条的对象数据
     *
     * @param param
     * @return
     */
    default T one(T param) {
        T result = this.selectOne(param);
        return result;
    }

    /**
     * 依据对象参数统计数据量
     *
     * @param param
     * @return
     */
    default Integer count(T param) {
        Integer result = this.selectCount(param);
        return result;
    }

    /**
     * 依据查询参数返回数据列表
     *
     * @param param
     * @return
     */
    default List<T> load(T param) {
        List<T> list = this.select(param);
        return list;
    }

    /**
     * 依据主键ID获取对象
     *
     * @param id
     * @return
     */
    default T loadById(K id) {
        T result = this.selectByPrimaryKey(id);
        return result;
    }

    /**
     * 依据ID列表返回数据
     *
     * @param ids
     * @return
     */
    List<T> loadByIds(@Param("ids") List<K> ids);

    /**
     * 依据ID列表返回不包含的数据
     *
     * @param ids
     * @return
     */
    List<T> loadByNotIds(@Param("ids") List<K> ids);

    /**
     * 依据ID列表删除数据
     *
     * @param ids
     * @return
     */
    Integer deleteByIds(@Param("ids") List<K> ids);

    /**
     * 依据ID列表删除不包含的数据
     *
     * @param ids
     * @return
     */
    Integer deleteByNotIds(@Param("ids") List<K> ids);

}
