package framework.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 操作日志
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface OperateLog {
    /**
     * 描述
     *
     * @return
     */
    String value() default "";

    /**
     * 保存请求
     *
     * @return
     */
    boolean isSaveRequest() default true;

    /**
     * 保存响应
     *
     * @return
     */
    boolean isSaveResponse() default true;
}
