/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.CucumberExecutionContext;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.junit.Assertions;
import io.cucumber.junit.FeatureRunnerPartitioned;
import io.cucumber.junit.JUnitCucumberOptionsProvider;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.JUnitOptionsParser;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestSourceRead;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

public class CucumberPartitioned
extends ParentRunner<FeatureRunnerPartitioned> {
    private final List<FeatureRunnerPartitioned> children = new ArrayList<FeatureRunnerPartitioned>();
    private final EventBus bus;
    private final List<Feature> features;
    private final Plugins plugins;
    private boolean multiThreadingAssumed = false;

    public CucumberPartitioned(Class clazz) throws InitializationError, IOException {
        super(clazz);
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptions runtimeOptions = this.getRuntimeOptions(clazz);
        JUnitOptions junitOptions = this.getJUnitOptions(clazz);
        this.bus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        FeatureParser parser = new FeatureParser(() -> ((EventBus)this.bus).generateId());
        Supplier<ClassLoader> classLoader = ClassLoaders::getDefaultClassLoader;
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(classLoader, (io.cucumber.core.feature.Options)runtimeOptions, parser);
        this.features = featureSupplier.get();
        this.plugins = new Plugins(new PluginFactory(), (Options)runtimeOptions);
        ThreadLocalRunnerSupplier runnerSupplier = this.CreateRunnerSupplier(classLoader, runtimeOptions, clazz);
        Filters filters = new Filters((io.cucumber.core.filter.Options)runtimeOptions);
        Iterator<Feature> iterator = this.features.iterator();
        while (iterator.hasNext()) {
            CucumberExecutionContext context = new CucumberExecutionContext(this.bus, new ExitStatus((Options)runtimeOptions), (RunnerSupplier)runnerSupplier);
            Feature feature = iterator.next();
            FeatureRunnerPartitioned featureRunner = new FeatureRunnerPartitioned(clazz, context, feature, filters, junitOptions);
            if (featureRunner.isEmpty()) continue;
            this.children.add(featureRunner);
        }
    }

    private ThreadLocalRunnerSupplier CreateRunnerSupplier(Supplier<ClassLoader> classLoader, RuntimeOptions runtimeOptions, Class<?> clazz) {
        ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader(classLoader, (io.cucumber.core.backend.Options)runtimeOptions);
        ThreadLocalObjectFactorySupplier objectFactorySupplier = new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader);
        BackendServiceLoader backendSupplier = new BackendServiceLoader(clazz::getClassLoader, (ObjectFactorySupplier)objectFactorySupplier);
        return new ThreadLocalRunnerSupplier((io.cucumber.core.runner.Options)runtimeOptions, this.bus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier);
    }

    private JUnitOptions getJUnitOptions(Class<?> clazz) {
        JUnitOptions junitPropertiesFileOptions = new JUnitOptionsParser().parse(CucumberProperties.fromPropertiesFile()).build();
        JUnitOptions junitAnnotationOptions = new JUnitOptionsParser().parse(clazz).build(junitPropertiesFileOptions);
        JUnitOptions junitEnvironmentOptions = new JUnitOptionsParser().parse(CucumberProperties.fromEnvironment()).build(junitAnnotationOptions);
        return new JUnitOptionsParser().parse(CucumberProperties.fromSystemProperties()).build(junitEnvironmentOptions);
    }

    private RuntimeOptions getRuntimeOptions(Class<?> clazz) {
        RuntimeOptions annotationOptions = new CucumberOptionsAnnotationParser().withOptionsProvider((CucumberOptionsAnnotationParser.OptionsProvider)new JUnitCucumberOptionsProvider()).parse(clazz).build();
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).addDefaultSummaryPrinterIfNotDisabled().build(annotationOptions);
        return new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).addDefaultSummaryPrinterIfNotDisabled().build(environmentOptions);
    }

    public List<FeatureRunnerPartitioned> getChildren() {
        return this.children;
    }

    protected Description describeChild(FeatureRunnerPartitioned child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunnerPartitioned child, RunNotifier notifier) {
        child.run(notifier);
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        Statement runFeatures = super.childrenInvoker(notifier);
        return new RunCucumber(runFeatures);
    }

    public void setScheduler(RunnerScheduler scheduler) {
        super.setScheduler(scheduler);
        this.multiThreadingAssumed = true;
    }

    class RunCucumber
    extends Statement {
        private final Statement runFeatures;

        RunCucumber(Statement runFeatures) {
            this.runFeatures = runFeatures;
        }

        public void evaluate() throws Throwable {
            if (CucumberPartitioned.this.multiThreadingAssumed) {
                CucumberPartitioned.this.plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)CucumberPartitioned.this.bus);
            } else {
                CucumberPartitioned.this.plugins.setEventBusOnEventListenerPlugins((EventPublisher)CucumberPartitioned.this.bus);
            }
            CucumberPartitioned.this.bus.send((Object)new TestRunStarted(this.getTimestamp()));
            for (Feature feature : CucumberPartitioned.this.features) {
                CucumberPartitioned.this.bus.send((Object)new TestSourceRead(CucumberPartitioned.this.bus.getInstant(), feature.getUri(), feature.getSource()));
            }
            this.runFeatures.evaluate();
            CucumberPartitioned.this.bus.send((Object)new TestRunFinished(null, Boolean.valueOf(true), this.getTimestamp()));
        }

        private Timestamp getTimestamp() {
            return new Timestamp(Long.valueOf(CucumberPartitioned.this.bus.getInstant().toEpochMilli()), Long.valueOf(CucumberPartitioned.this.bus.getInstant().getEpochSecond()));
        }
    }
}

