/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import cucumber.runner.RunnerSupplier;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runtime.CucumberException;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.model.CucumberFeature;
import gherkin.ast.Feature;
import gherkin.events.PickleEvent;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.PickleRunners;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

final class FeatureRunnerPartitioned
extends ParentRunner<PickleRunners.PickleRunner> {
    private final List<PickleRunners.PickleRunner> children = new ArrayList<PickleRunners.PickleRunner>();
    private final CucumberFeature cucumberFeature;
    private Description description;
    private int cucumberPartitionQty;
    private int cucumberPartitionId;
    private boolean debug;

    FeatureRunnerPartitioned(CucumberFeature cucumberFeature, Filters filters, ThreadLocalRunnerSupplier runnerSupplier, JUnitOptions jUnitOptions) throws InitializationError {
        super(null);
        this.setPartitionInfo();
        this.cucumberFeature = cucumberFeature;
        this.buildFeatureElementRunners(filters, runnerSupplier, jUnitOptions);
    }

    private void setPartitionInfo() {
        try {
            this.cucumberPartitionQty = Integer.valueOf(System.getProperty("cucumber.partition.qty"));
            this.cucumberPartitionId = Integer.valueOf(System.getProperty("cucumber.partition.id"));
            this.debug = Boolean.valueOf(System.getProperty("cucumber.partition.debug", "false"));
        }
        catch (RuntimeException e) {
            this.printPartitionInstructions();
            e.printStackTrace();
            throw new RuntimeException("CucumberPartition Not Properly Configured");
        }
        if (this.cucumberPartitionId < 1 || this.cucumberPartitionQty < 1 || this.cucumberPartitionId > this.cucumberPartitionQty) {
            this.printPartitionInstructions();
            throw new RuntimeException("CucumberPartition Not Properly Configured");
        }
    }

    private void printPartitionInstructions() {
        System.out.println("To use CucumberPartitioned, you must pass two system variables. For example:");
        System.out.println("-Dcucumber.partition.id=2 -Dcucumber.partition.qty=5");
        System.out.println("cucumber.partition.qty is the total number of partitions");
        System.out.println("cucumber.partition.id is the id of the particular partition");
        System.out.println("There should be an environment with in id from 1 through the qty of partitions.");
        System.out.println("cucumber.partition.id and cucumber.partition.qty must be present and greater than 0");
        System.out.println("cucumber.partition.id cannot be more than cucumber.partition.qty");
    }

    protected String getName() {
        Feature feature = this.cucumberFeature.getGherkinFeature().getFeature();
        return feature.getKeyword() + ": " + feature.getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)new FeatureId(this.cucumberFeature), (Annotation[])new Annotation[0]);
            for (PickleRunners.PickleRunner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    protected List<PickleRunners.PickleRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(PickleRunners.PickleRunner child) {
        return child.getDescription();
    }

    protected void runChild(PickleRunners.PickleRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    private void buildFeatureElementRunners(Filters filters, ThreadLocalRunnerSupplier runnerSupplier, JUnitOptions jUnitOptions) {
        for (PickleEvent pickleEvent : this.cucumberFeature.getPickles()) {
            if (!filters.matchesFilters(pickleEvent)) continue;
            try {
                PickleRunners.PickleRunner picklePickleRunner;
                int assignToPartition = Math.abs(pickleEvent.pickle.getName().hashCode()) % this.cucumberPartitionQty + 1;
                if (this.debug) {
                    System.out.print(this.cucumberPartitionId == assignToPartition ? "*" : " ");
                    System.out.print("Partition " + assignToPartition);
                    System.out.println(" assigned to " + pickleEvent.pickle.getName());
                }
                if (this.cucumberPartitionId != assignToPartition) continue;
                if (jUnitOptions.stepNotifications()) {
                    picklePickleRunner = PickleRunners.withStepDescriptions((RunnerSupplier)runnerSupplier, (PickleEvent)pickleEvent, (JUnitOptions)jUnitOptions);
                    this.children.add(picklePickleRunner);
                    continue;
                }
                picklePickleRunner = PickleRunners.withNoStepDescriptions((String)this.cucumberFeature.getName(), (RunnerSupplier)runnerSupplier, (PickleEvent)pickleEvent, (JUnitOptions)jUnitOptions);
                this.children.add(picklePickleRunner);
            }
            catch (InitializationError e) {
                throw new CucumberException("Failed to create scenario runner", (Throwable)e);
            }
        }
    }

    private static final class FeatureId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URI uri;

        FeatureId(CucumberFeature feature) {
            this.uri = feature.getUri();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureId featureId = (FeatureId)o;
            return this.uri.equals(featureId.uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public String toString() {
            return this.uri.toString();
        }
    }
}

