/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import cucumber.api.StepDefinitionReporter;
import cucumber.api.event.Event;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.runner.EventBus;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.BackendModuleBackendSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.Env;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.Plugins;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.EnvironmentOptionsParser;
import io.cucumber.core.options.FeatureOptions;
import io.cucumber.core.options.FilterOptions;
import io.cucumber.core.options.PluginOptions;
import io.cucumber.core.options.RunnerOptions;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.junit.Assertions;
import io.cucumber.junit.FeatureRunnerPartitioned;
import io.cucumber.junit.JUnitCucumberOptionsProvider;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.JUnitOptionsParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

public class CucumberPartitioned
extends ParentRunner<FeatureRunnerPartitioned> {
    private final List<FeatureRunnerPartitioned> children = new ArrayList<FeatureRunnerPartitioned>();
    private final EventBus bus;
    private final ThreadLocalRunnerSupplier runnerSupplier;
    private final List<CucumberFeature> features;
    private final Plugins plugins;
    private boolean multiThreadingAssumed = false;

    public CucumberPartitioned(Class clazz) throws InitializationError, IOException {
        super(clazz);
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        RuntimeOptions annotationOptions = new CucumberOptionsAnnotationParser((ResourceLoader)resourceLoader).withOptionsProvider((CucumberOptionsAnnotationParser.OptionsProvider)new JUnitCucumberOptionsProvider()).parse(clazz).build();
        RuntimeOptions runtimeOptions = new EnvironmentOptionsParser((ResourceLoader)resourceLoader).parse(Env.INSTANCE).build(annotationOptions);
        runtimeOptions.addUndefinedStepsPrinterIfSummaryNotDefined();
        JUnitOptions junitAnnotationOptions = new JUnitOptionsParser().parse(clazz).build();
        JUnitOptions junitOptions = new JUnitOptionsParser().parse(runtimeOptions.getJunitOptions()).setStrict(runtimeOptions.isStrict()).build(junitAnnotationOptions);
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
        FeatureLoader featureLoader = new FeatureLoader((ResourceLoader)resourceLoader);
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(featureLoader, (FeatureOptions)runtimeOptions);
        this.features = featureSupplier.get();
        this.plugins = new Plugins(classLoader, new PluginFactory(), (PluginOptions)runtimeOptions);
        this.bus = new TimeServiceEventBus(TimeService.SYSTEM);
        BackendModuleBackendSupplier backendSupplier = new BackendModuleBackendSupplier((ResourceLoader)resourceLoader, (ClassFinder)classFinder, (RunnerOptions)runtimeOptions);
        this.runnerSupplier = new ThreadLocalRunnerSupplier((RunnerOptions)runtimeOptions, this.bus, (BackendSupplier)backendSupplier);
        Filters filters = new Filters((FilterOptions)runtimeOptions);
        for (CucumberFeature cucumberFeature : this.features) {
            FeatureRunnerPartitioned featureRunner = new FeatureRunnerPartitioned(cucumberFeature, filters, this.runnerSupplier, junitOptions);
            if (featureRunner.isEmpty()) continue;
            this.children.add(featureRunner);
        }
    }

    public List<FeatureRunnerPartitioned> getChildren() {
        return this.children;
    }

    protected Description describeChild(FeatureRunnerPartitioned child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunnerPartitioned child, RunNotifier notifier) {
        child.run(notifier);
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        Statement runFeatures = super.childrenInvoker(notifier);
        return new RunCucumber(runFeatures);
    }

    public void setScheduler(RunnerScheduler scheduler) {
        super.setScheduler(scheduler);
        this.multiThreadingAssumed = true;
    }

    class RunCucumber
    extends Statement {
        private final Statement runFeatures;

        RunCucumber(Statement runFeatures) {
            this.runFeatures = runFeatures;
        }

        public void evaluate() throws Throwable {
            if (CucumberPartitioned.this.multiThreadingAssumed) {
                CucumberPartitioned.this.plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)CucumberPartitioned.this.bus);
            } else {
                CucumberPartitioned.this.plugins.setEventBusOnEventListenerPlugins((EventPublisher)CucumberPartitioned.this.bus);
            }
            CucumberPartitioned.this.bus.send((Event)new TestRunStarted(CucumberPartitioned.this.bus.getTime(), CucumberPartitioned.this.bus.getTimeMillis().longValue()));
            for (CucumberFeature feature : CucumberPartitioned.this.features) {
                feature.sendTestSourceRead(CucumberPartitioned.this.bus);
            }
            StepDefinitionReporter stepDefinitionReporter = CucumberPartitioned.this.plugins.stepDefinitionReporter();
            CucumberPartitioned.this.runnerSupplier.get().reportStepDefinitions(stepDefinitionReporter);
            this.runFeatures.evaluate();
            CucumberPartitioned.this.bus.send((Event)new TestRunFinished(CucumberPartitioned.this.bus.getTime(), CucumberPartitioned.this.bus.getTimeMillis().longValue()));
        }
    }
}

