/*
 * Decompiled with CFR 0.152.
 */
package net.xeric.utils.test.cucumber;

import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.junit.ExecutionUnitRunner;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.junit.ScenarioOutlineRunner;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberScenarioOutline;
import cucumber.runtime.model.CucumberTagStatement;
import gherkin.formatter.model.Feature;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureRunnerPartitioned
extends ParentRunner<ParentRunner> {
    private final List<ParentRunner> children = new ArrayList<ParentRunner>();
    private final CucumberFeature cucumberFeature;
    private final Runtime runtime;
    private final JUnitReporter jUnitReporter;
    private Description description;
    private int cucumberPartitionQty = 0;
    private int cucumberPartitionId = 0;
    private boolean debug = false;

    public FeatureRunnerPartitioned(CucumberFeature cucumberFeature, Runtime runtime, JUnitReporter jUnitReporter) throws InitializationError {
        super(null);
        this.setPartitionInfo();
        this.cucumberFeature = cucumberFeature;
        this.runtime = runtime;
        this.jUnitReporter = jUnitReporter;
        this.buildFeatureElementRunners();
    }

    private void setPartitionInfo() {
        try {
            this.cucumberPartitionQty = Integer.valueOf(System.getProperty("cucumber.partition.qty"));
            this.cucumberPartitionId = Integer.valueOf(System.getProperty("cucumber.partition.id"));
            this.debug = Boolean.valueOf(System.getProperty("cucumber.partition.debug", "false"));
        }
        catch (RuntimeException e) {
            this.printPartitionInstructions();
            throw new RuntimeException("CucumberPartition Not Properly Configured");
        }
        if (this.cucumberPartitionId < 1 || this.cucumberPartitionQty < 1 || this.cucumberPartitionId > this.cucumberPartitionQty) {
            this.printPartitionInstructions();
            throw new RuntimeException("CucumberPartition Not Propertly Configured");
        }
    }

    private void printPartitionInstructions() {
        System.out.println("To use CucumberPartitioned, you must pass two system variables. For example:");
        System.out.println("-Dcucumber.partition.id=2 -Dcucumber.partition.qty=5");
        System.out.println("cucumber.partition.qty is the total number of partitions");
        System.out.println("cucumber.partition.id is the id of the particular partition");
        System.out.println("There should be an environment with in id from 1 through the qty of partitions.");
        System.out.println("cucumber.partition.id and cucumber.partition.qty must be present and greater than 0");
        System.out.println("cucumber.partition.id cannot be more than cucumber.partition.qty");
    }

    public String getName() {
        Feature feature = this.cucumberFeature.getGherkinFeature();
        return feature.getKeyword() + ": " + feature.getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)this.cucumberFeature.getGherkinFeature(), (Annotation[])new Annotation[0]);
            for (ParentRunner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    protected List<ParentRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(ParentRunner child) {
        return child.getDescription();
    }

    protected void runChild(ParentRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    public void run(RunNotifier notifier) {
        this.jUnitReporter.uri(this.cucumberFeature.getPath());
        this.jUnitReporter.feature(this.cucumberFeature.getGherkinFeature());
        super.run(notifier);
        this.jUnitReporter.eof();
    }

    private void buildFeatureElementRunners() {
        for (CucumberTagStatement cucumberTagStatement : this.cucumberFeature.getFeatureElements()) {
            try {
                Object featureElementRunner = cucumberTagStatement instanceof CucumberScenario ? new ExecutionUnitRunner(this.runtime, (CucumberScenario)cucumberTagStatement, this.jUnitReporter) : new ScenarioOutlineRunner(this.runtime, (CucumberScenarioOutline)cucumberTagStatement, this.jUnitReporter);
                int assignToPartition = Math.abs(featureElementRunner.getDescription().getDisplayName().hashCode()) % this.cucumberPartitionQty + 1;
                if (this.debug) {
                    System.out.print(this.cucumberPartitionId == assignToPartition ? "*" : " ");
                    System.out.print("Partition " + assignToPartition);
                    System.out.println(" assigned to " + featureElementRunner.getDescription().getDisplayName());
                }
                if (this.cucumberPartitionId != assignToPartition) continue;
                this.children.add((ParentRunner)featureElementRunner);
            }
            catch (InitializationError e) {
                throw new CucumberException("Failed to create scenario runner", (Throwable)e);
            }
        }
    }
}

