/*
 * Decompiled with CFR 0.152.
 */
package net.xeric.utils.test.cucumber;

import cucumber.runtime.ClassFinder;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.junit.Assertions;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.xeric.utils.test.cucumber.FeatureRunnerPartitioned;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CucumberPartitioned
extends ParentRunner<FeatureRunnerPartitioned> {
    private final JUnitReporter jUnitReporter;
    private final List<FeatureRunnerPartitioned> children = new ArrayList<FeatureRunnerPartitioned>();
    private final Runtime runtime;

    public CucumberPartitioned(Class clazz) throws InitializationError, IOException {
        super(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        RuntimeOptions runtimeOptions = runtimeOptionsFactory.create();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        this.runtime = this.createRuntime((ResourceLoader)resourceLoader, classLoader, runtimeOptions);
        List cucumberFeatures = runtimeOptions.cucumberFeatures((ResourceLoader)resourceLoader);
        this.jUnitReporter = new JUnitReporter(runtimeOptions.reporter(classLoader), runtimeOptions.formatter(classLoader), runtimeOptions.isStrict());
        this.addChildren(cucumberFeatures);
    }

    protected Runtime createRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions) throws InitializationError, IOException {
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        return new Runtime(resourceLoader, (ClassFinder)classFinder, classLoader, runtimeOptions);
    }

    public List<FeatureRunnerPartitioned> getChildren() {
        return this.children;
    }

    protected Description describeChild(FeatureRunnerPartitioned child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunnerPartitioned child, RunNotifier notifier) {
        child.run(notifier);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        this.jUnitReporter.done();
        this.jUnitReporter.close();
        this.runtime.printSummary();
    }

    private void addChildren(List<CucumberFeature> cucumberFeatures) throws InitializationError {
        for (CucumberFeature cucumberFeature : cucumberFeatures) {
            this.children.add(new FeatureRunnerPartitioned(cucumberFeature, this.runtime, this.jUnitReporter));
        }
    }
}

