/*
 * Decompiled with CFR 0.152.
 */
package net.xdow.aliyundrive.net.interceptor;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public class XHttpLoggingInterceptor
implements Interceptor {
    public static final String SKIP_HEADER_NAME = "x-skip-http-log";
    public static final String SKIP_HEADER_VALUE = "1";
    final HttpLoggingInterceptor mLoggingInterceptor = new HttpLoggingInterceptor();

    public XHttpLoggingInterceptor() {
        this.mLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        try {
            Request request = chain.request();
            if (SKIP_HEADER_VALUE.equals(request.header(SKIP_HEADER_NAME))) {
                return chain.proceed(chain.request().newBuilder().removeHeader(SKIP_HEADER_NAME).build());
            }
            return this.mLoggingInterceptor.intercept(chain);
        }
        catch (Exception e) {
            System.out.println(e);
            return chain.proceed(chain.request());
        }
    }
}

