/*
 * Decompiled with CFR 0.152.
 */
package net.xdow.aliyundrive.net.interceptor;

import java.io.IOException;
import net.xdow.aliyundrive.bean.AliyunDriveResponse;
import net.xdow.aliyundrive.util.StringUtils;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class AliyunDriveAuthenticateInterceptor
implements Interceptor {
    public static final String HEADER_AUTHENTICATE_NAME = "x-authenticate!!";
    public static final String HEADER_AUTHENTICATE_VALUE = "1";
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final IAccessTokenInfoGetter mIAccessTokenInfoGetter;

    public AliyunDriveAuthenticateInterceptor(IAccessTokenInfoGetter mIAccessTokenInfoGetter) {
        this.mIAccessTokenInfoGetter = mIAccessTokenInfoGetter;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (!HEADER_AUTHENTICATE_VALUE.equals(request.header(HEADER_AUTHENTICATE_NAME))) {
            return chain.proceed(request);
        }
        if (!this.checkAuthenticated()) {
            ResponseBody body = ResponseBody.create((MediaType)JSON, (String)"{\"code\":\"AccessTokenInvalid\",\"message\":\"access token is blank\",\"data\":null,\"headers\":null,\"pdsRequestId\":null,\"resultCode\":\"AccessTokenInvalid\",\"display_message\":null}");
            return new Response.Builder().addHeader("content-type", "application/json; charset=utf-8").body(body).code(401).message("access token is blank").protocol(Protocol.HTTP_1_0).request(chain.request()).build();
        }
        return chain.proceed(request.newBuilder().removeHeader(HEADER_AUTHENTICATE_NAME).build());
    }

    private boolean checkAuthenticated() {
        AliyunDriveResponse.AccessTokenInfo info = this.mIAccessTokenInfoGetter.getAccessTokenInfo();
        if (info == null) {
            return false;
        }
        if (StringUtils.isEmpty(info.getAccessToken())) {
            return false;
        }
        return !StringUtils.isEmpty(info.getRefreshToken());
    }

    public static interface IAccessTokenInfoGetter {
        public AliyunDriveResponse.AccessTokenInfo getAccessTokenInfo();
    }
}

