/*
 * Decompiled with CFR 0.152.
 */
package net.xdow.aliyundrive.net;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import net.xdow.aliyundrive.bean.AliyunDriveResponse;
import net.xdow.aliyundrive.exception.NotAuthenticatedException;
import net.xdow.aliyundrive.util.JsonUtils;
import net.xdow.aliyundrive.util.TypeReference;
import okhttp3.Call;
import okhttp3.Response;

public class AliyunDriveCall<T extends AliyunDriveResponse.GenericMessageInfo>
extends TypeReference<T> {
    private final Call mCall;
    private final Class<? extends AliyunDriveResponse.GenericMessageInfo> mEntityBeanType;
    private T mMockResult;
    private MockResultCallback<T> mMockResultOnSuccessCallback;
    protected boolean mDisableAuthorizeCheck = false;

    public AliyunDriveCall(T mockResult) {
        this.mCall = null;
        this.mEntityBeanType = null;
        this.mMockResult = mockResult;
    }

    public AliyunDriveCall(Call call) {
        this.mCall = call;
        this.mEntityBeanType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public AliyunDriveCall(Call call, Class<? extends AliyunDriveResponse.GenericMessageInfo> classOfT) {
        this.mCall = call;
        this.mEntityBeanType = classOfT;
    }

    public T execute() {
        T mockResult = this.mMockResult;
        if (mockResult != null) {
            return mockResult;
        }
        try {
            Response response = this.mCall.execute();
            String content = response.body().string();
            if (response.code() == 204) {
                content = "{}";
            }
            AliyunDriveResponse.GenericMessageInfo t = JsonUtils.fromJson(content, this.mEntityBeanType);
            this.checkAuthorize(t);
            MockResultCallback<AliyunDriveResponse.GenericMessageInfo> mockResultOnSuccessCallback = this.mMockResultOnSuccessCallback;
            if (mockResultOnSuccessCallback != null) {
                t = mockResultOnSuccessCallback.onSuccess(t);
            }
            return (T)t;
        }
        catch (NotAuthenticatedException e) {
            throw e;
        }
        catch (Throwable t) {
            return this.handleResponseError(t);
        }
    }

    public void checkAuthorize(T t) {
        if (!((AliyunDriveResponse.GenericMessageInfo)t).isError()) {
            return;
        }
        if (this.mDisableAuthorizeCheck) {
            return;
        }
        if ("AccessTokenInvalid".equals(((AliyunDriveResponse.GenericMessageInfo)t).getCode())) {
            throw new NotAuthenticatedException(((AliyunDriveResponse.GenericMessageInfo)t).getMessage() + "(" + ((AliyunDriveResponse.GenericMessageInfo)t).getCode() + ")");
        }
        if ("TokenExpired".equals(((AliyunDriveResponse.GenericMessageInfo)t).getCode())) {
            throw new NotAuthenticatedException(((AliyunDriveResponse.GenericMessageInfo)t).getMessage() + "(" + ((AliyunDriveResponse.GenericMessageInfo)t).getCode() + ")");
        }
    }

    public AliyunDriveCall<T> disableAuthorizeCheck() {
        this.mDisableAuthorizeCheck = true;
        return this;
    }

    public AliyunDriveCall<T> enableAuthorizeCheck() {
        this.mDisableAuthorizeCheck = false;
        return this;
    }

    public void enqueue(final Callback<T> callback) {
        T mockResult = this.mMockResult;
        if (mockResult != null) {
            callback.onResponse(null, null, mockResult);
            return;
        }
        this.mCall.enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(call, e, AliyunDriveCall.this.handleResponseError(e));
            }

            public void onResponse(Call call, Response response) throws IOException {
                try {
                    String content = response.body().string();
                    if (response.code() == 204) {
                        content = "{}";
                    }
                    AliyunDriveResponse.GenericMessageInfo t = (AliyunDriveResponse.GenericMessageInfo)JsonUtils.fromJson(content, AliyunDriveCall.this.mEntityBeanType);
                    AliyunDriveCall.this.checkAuthorize(t);
                    MockResultCallback mockResultOnSuccessCallback = AliyunDriveCall.this.mMockResultOnSuccessCallback;
                    if (mockResultOnSuccessCallback != null) {
                        t = mockResultOnSuccessCallback.onSuccess(t);
                    }
                    callback.onResponse(call, response, t);
                    return;
                }
                catch (Throwable t) {
                    callback.onFailure(call, t, AliyunDriveCall.this.handleResponseError(t));
                    return;
                }
            }
        });
    }

    public AliyunDriveCall<T> mockResultOnSuccess(MockResultCallback<T> callback) {
        this.mMockResultOnSuccessCallback = callback;
        return this;
    }

    private T handleResponseError(Throwable t) {
        try {
            AliyunDriveResponse.GenericMessageInfo genericMessageInfo = this.mEntityBeanType.newInstance();
            genericMessageInfo.setCode("NetworkError");
            genericMessageInfo.setCode(t.toString());
            return (T)genericMessageInfo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface MockResultCallback<T> {
        public T onSuccess(T var1);
    }

    public static interface Callback<T> {
        public void onResponse(Call var1, Response var2, T var3);

        public void onFailure(Call var1, Throwable var2, T var3);
    }
}

