/*
 * Decompiled with CFR 0.152.
 */
package net.xdow.aliyundrive.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.xdow.aliyundrive.IAliyunDrive;
import net.xdow.aliyundrive.IAliyunDriveAuthorizer;
import net.xdow.aliyundrive.bean.AliyunDriveEnum;
import net.xdow.aliyundrive.bean.AliyunDriveFilePartInfo;
import net.xdow.aliyundrive.bean.AliyunDriveRequest;
import net.xdow.aliyundrive.bean.AliyunDriveResponse;
import net.xdow.aliyundrive.net.AliyunDriveCall;
import net.xdow.aliyundrive.net.interceptor.AccessTokenInvalidInterceptor;
import net.xdow.aliyundrive.net.interceptor.AliyunDriveAuthenticateInterceptor;
import net.xdow.aliyundrive.net.interceptor.XHttpLoggingInterceptor;
import net.xdow.aliyundrive.util.JsonUtils;
import net.xdow.aliyundrive.util.StringUtils;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.xbill.DNS.Address;

public class AliyunDriveOpenApiImplV1
implements IAliyunDrive,
AliyunDriveAuthenticateInterceptor.IAccessTokenInfoGetter {
    private OkHttpClient mOkHttpClient;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private AliyunDriveResponse.AccessTokenInfo mAccessTokenInfo;
    private IAliyunDriveAuthorizer mAliyunDriveAuthorizer;
    private AccessTokenInvalidInterceptor mAccessTokenInvalidInterceptor = new AccessTokenInvalidInterceptor();

    public AliyunDriveOpenApiImplV1() {
        this.initOkHttp();
    }

    private void initOkHttp() {
        XHttpLoggingInterceptor loggingInterceptor = new XHttpLoggingInterceptor();
        AliyunDriveAuthenticateInterceptor authenticateInterceptor = new AliyunDriveAuthenticateInterceptor(this);
        this.mOkHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).addInterceptor((Interceptor)authenticateInterceptor).addInterceptor((Interceptor)this.mAccessTokenInvalidInterceptor).addInterceptor(new Interceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = chain.proceed(AliyunDriveOpenApiImplV1.this.buildCommonRequestHeader(request));
                try {
                    int code = response.code();
                    if (code != 401) {
                        if (code != 400) return response;
                    }
                    ResponseBody body = response.peekBody(40960L);
                    try {
                        String res = body.string();
                        if (!res.contains("AccessTokenInvalid")) {
                            if (!res.contains("TokenExpired")) return response;
                        }
                        AliyunDriveOpenApiImplV1.this.requestNewAccessToken();
                        Response response2 = chain.proceed(AliyunDriveOpenApiImplV1.this.buildCommonRequestHeader(request));
                        return response2;
                    }
                    finally {
                        Util.closeQuietly((Closeable)body);
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                return response;
            }
        }).readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).connectTimeout(1L, TimeUnit.MINUTES).dns(new Dns(){

            public List<InetAddress> lookup(String hostname) throws UnknownHostException {
                UnknownHostException unknownHostException;
                ArrayList<InetAddress> list;
                block5: {
                    list = new ArrayList<InetAddress>();
                    unknownHostException = null;
                    try {
                        list.addAll(Dns.SYSTEM.lookup(hostname));
                    }
                    catch (UnknownHostException e) {
                        unknownHostException = e;
                    }
                    try {
                        list.addAll(Arrays.asList(Address.getAllByName((String)hostname)));
                    }
                    catch (UnknownHostException e) {
                        if (unknownHostException != null) break block5;
                        unknownHostException = e;
                    }
                }
                if (list.size() <= 0 && unknownHostException != null) {
                    throw unknownHostException;
                }
                return list;
            }
        }).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(true).build();
    }

    @Override
    public void setAccessTokenInfo(AliyunDriveResponse.AccessTokenInfo info) {
        this.mAccessTokenInfo = info;
    }

    @Override
    public void setAuthorizer(IAliyunDriveAuthorizer authorizer) {
        this.mAliyunDriveAuthorizer = authorizer;
    }

    @Override
    public void setAccessTokenInvalidListener(Runnable listener) {
        this.mAccessTokenInvalidInterceptor.setAccessTokenInvalidListener(listener);
    }

    private void requestNewAccessToken() {
        IAliyunDriveAuthorizer authorizer = this.mAliyunDriveAuthorizer;
        if (authorizer == null) {
            return;
        }
        try {
            AliyunDriveResponse.AccessTokenInfo newAccessTokenInfo = authorizer.acquireNewAccessToken(this.mAccessTokenInfo);
            if (newAccessTokenInfo != null) {
                this.mAccessTokenInfo = newAccessTokenInfo;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    private Request buildCommonRequestHeader(Request request) {
        Request.Builder builder = request.newBuilder();
        Map<String, String> map = this.getCommonHeaders();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            builder.removeHeader(key);
            builder.addHeader(key, value);
        }
        request = builder.build();
        return request;
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.AccessTokenInfo> getAccessToken(String url) {
        return this.postApiRequest(url, AliyunDriveResponse.AccessTokenInfo.class, 1);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.QrCodeGenerateInfo> qrCodeGenerate(String url) {
        return this.postApiRequest(url, AliyunDriveResponse.QrCodeGenerateInfo.class, 1);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.QrCodeQueryStatusInfo> qrCodeQueryStatus(String sid) {
        String url = String.format(Locale.getDefault(), "https://openapi.aliyundrive.com/oauth/qrcode/%s/status", sid);
        return this.getApiRequest(url, AliyunDriveResponse.QrCodeQueryStatusInfo.class, 1);
    }

    @Override
    public String qrCodeImageUrl(String sid) {
        return String.format(Locale.getDefault(), "https://openapi.aliyundrive.com/oauth/qrcode/%s", sid);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.AccessTokenInfo> getAccessToken(AliyunDriveRequest.AccessTokenInfo query) {
        String[] refreshTokenParts;
        if (query.getGrantType() == AliyunDriveEnum.GrantType.RefreshToken && (refreshTokenParts = query.getRefreshToken().split("\\.")).length < 3) {
            AliyunDriveResponse.AccessTokenInfo res = new AliyunDriveResponse.AccessTokenInfo();
            res.setCode("JWTDecodeException");
            res.setMessage("The token was expected to have 3 parts, but got " + refreshTokenParts.length + ".");
            return new AliyunDriveCall<AliyunDriveResponse.AccessTokenInfo>(res);
        }
        return this.postApiRequest("https://openapi.aliyundrive.com/oauth/access_token", query, AliyunDriveResponse.AccessTokenInfo.class, 1);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.QrCodeGenerateInfo> qrCodeGenerate(AliyunDriveRequest.QrCodeGenerateInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/oauth/authorize/qrcode", query, AliyunDriveResponse.QrCodeGenerateInfo.class, 1);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileListInfo> fileList(AliyunDriveRequest.FileListInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/list", query, AliyunDriveResponse.FileListInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.UserSpaceInfo> getUserSpaceInfo() {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/user/getSpaceInfo", AliyunDriveResponse.UserSpaceInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.UserDriveInfo> getUserDriveInfo() {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/user/getDriveInfo", AliyunDriveResponse.UserDriveInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileGetInfo> fileGet(AliyunDriveRequest.FileGetInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/get", query, AliyunDriveResponse.FileGetInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileGetInfo> fileGetByPath(AliyunDriveRequest.FileGetByPathInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/get_by_path", query, AliyunDriveResponse.FileGetInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileBatchGetInfo> fileBatchGet(AliyunDriveRequest.FileBatchGetInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/batch/get", query, AliyunDriveResponse.FileBatchGetInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileGetDownloadUrlInfo> fileGetDownloadUrl(AliyunDriveRequest.FileGetDownloadUrlInfo query) {
        int expireSec = query.getExpireSec();
        if (expireSec > 115200) {
            throw new IllegalArgumentException("Error: expire_sec argument must less then 115200s, got: " + expireSec);
        }
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/getDownloadUrl", query, AliyunDriveResponse.FileGetDownloadUrlInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileCreateInfo> fileCreate(AliyunDriveRequest.FileCreateInfo query) {
        int partInfoListSize;
        List<AliyunDriveFilePartInfo> partInfoList = query.getPartInfoList();
        if (partInfoList != null && (partInfoListSize = partInfoList.size()) > 10000) {
            throw new IllegalArgumentException("Error: max part_info_list size must < 10000, got: " + partInfoListSize);
        }
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/create", query, AliyunDriveResponse.FileCreateInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileGetUploadUrlInfo> fileGetUploadUrl(AliyunDriveRequest.FileGetUploadUrlInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/getUploadUrl", query, AliyunDriveResponse.FileGetUploadUrlInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileListUploadPartsInfo> fileListUploadedParts(AliyunDriveRequest.FileListUploadPartsInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/listUploadedParts", query, AliyunDriveResponse.FileListUploadPartsInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileUploadCompleteInfo> fileUploadComplete(AliyunDriveRequest.FileUploadCompleteInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/complete", query, AliyunDriveResponse.FileUploadCompleteInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileRenameInfo> fileRename(AliyunDriveRequest.FileRenameInfo query) {
        AliyunDriveRequest.FileCreateInfo createQuery = new AliyunDriveRequest.FileCreateInfo(query.getDriveId(), query.getParentFileId(), query.getName(), AliyunDriveEnum.Type.File, AliyunDriveEnum.CheckNameMode.Refuse);
        AliyunDriveResponse.FileCreateInfo createRes = this.fileCreate(createQuery).execute();
        String createdFileId = createRes.getFileId();
        if (!StringUtils.isEmpty(createdFileId)) {
            AliyunDriveRequest.FileDeleteInfo deleteQuery = new AliyunDriveRequest.FileDeleteInfo(query.getDriveId(), createdFileId);
            this.fileDelete(deleteQuery).execute();
        }
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/update", query, AliyunDriveResponse.FileRenameInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileMoveInfo> fileMove(AliyunDriveRequest.FileMoveInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/move", query, AliyunDriveResponse.FileMoveInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileCopyInfo> fileCopy(AliyunDriveRequest.FileCopyInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/copy", query, AliyunDriveResponse.FileCopyInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileMoveToTrashInfo> fileMoveToTrash(AliyunDriveRequest.FileMoveToTrashInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/recyclebin/trash", query, AliyunDriveResponse.FileMoveToTrashInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.FileDeleteInfo> fileDelete(AliyunDriveRequest.FileDeleteInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/delete", query, AliyunDriveResponse.FileDeleteInfo.class, 2);
    }

    @Override
    public AliyunDriveCall<AliyunDriveResponse.VideoPreviewPlayInfo> videoPreviewPlayInfo(AliyunDriveRequest.VideoPreviewPlayInfo query) {
        return this.postApiRequest("https://openapi.aliyundrive.com/adrive/v1.0/openFile/getVideoPreviewPlayInfo", query, AliyunDriveResponse.VideoPreviewPlayInfo.class, 2);
    }

    @Override
    public Call upload(String url, byte[] bytes, int offset, int byteCount) {
        Request request = new Request.Builder().addHeader("x-authenticate!!", "1").addHeader("x-skip-http-log", "1").put(RequestBody.create((MediaType)MediaType.parse((String)""), (byte[])bytes, (int)offset, (int)byteCount)).url(url).build();
        return this.mOkHttpClient.newCall(request);
    }

    @Override
    public Call download(String url, String range, String ifRange) {
        Request.Builder builder = new Request.Builder();
        builder.addHeader("x-skip-http-log", "1");
        builder.addHeader("x-authenticate!!", "1");
        if (range != null) {
            builder.header("range", range);
        }
        if (ifRange != null) {
            builder.header("if-range", ifRange);
        }
        Request request = builder.url(url).build();
        return this.mOkHttpClient.newCall(request);
    }

    @Override
    public Map<String, String> getCommonHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        AliyunDriveResponse.AccessTokenInfo info = this.mAccessTokenInfo;
        if (info != null) {
            map.put("authorization", info.getTokenType() + " " + info.getAccessToken());
        }
        map.put("referer", "https://www.aliyundrive.com/");
        return map;
    }

    public <T extends AliyunDriveResponse.GenericMessageInfo> AliyunDriveCall<T> getApiRequest(String url, Class<T> classOfT, int flags) {
        Request request = new Request.Builder().url(url).get().build();
        return new AliyunDriveCall(this.mOkHttpClient.newCall(request), classOfT);
    }

    public <T extends AliyunDriveResponse.GenericMessageInfo> AliyunDriveCall<T> postApiRequest(String url, Class<T> classOfT, int flags) {
        return this.postApiRequest(url, null, classOfT, flags);
    }

    public <T extends AliyunDriveResponse.GenericMessageInfo> AliyunDriveCall<T> postApiRequest(String url, Object object, Class<T> classOfT, int flags) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (object == null) {
            builder.post(RequestBody.create((MediaType)JSON, (String)"{}"));
        } else {
            builder.post(RequestBody.create((MediaType)JSON, (String)JsonUtils.toJson(object)));
        }
        if ((2 & flags) != 0) {
            builder.addHeader("x-authenticate!!", "1");
        }
        return new AliyunDriveCall(this.mOkHttpClient.newCall(builder.build()), classOfT);
    }

    @Override
    public AliyunDriveResponse.AccessTokenInfo getAccessTokenInfo() {
        return this.mAccessTokenInfo;
    }
}

