/*
 * Decompiled with CFR 0.152.
 */
package net.xdow.aliyundrive.bean;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import lombok.NonNull;
import net.xdow.aliyundrive.bean.AliyunDriveEnum;
import net.xdow.aliyundrive.bean.AliyunDriveFilePartInfo;

public class AliyunDriveRequest {

    public static class QrCodeGenerateInfo {
        @NonNull
        private String clientId;
        @NonNull
        private String clientSecret;
        @NonNull
        private String[] scopes;
        private int width = 430;
        private int height = 430;

        public QrCodeGenerateInfo(@NonNull String clientId, @NonNull String clientSecret, @NonNull String[] scopes) {
            if (clientId == null) {
                throw new NullPointerException("clientId is marked non-null but is null");
            }
            if (clientSecret == null) {
                throw new NullPointerException("clientSecret is marked non-null but is null");
            }
            if (scopes == null) {
                throw new NullPointerException("scopes is marked non-null but is null");
            }
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.scopes = scopes;
        }

        @NonNull
        public String getClientId() {
            return this.clientId;
        }

        @NonNull
        public String getClientSecret() {
            return this.clientSecret;
        }

        @NonNull
        public String[] getScopes() {
            return this.scopes;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setClientId(@NonNull String clientId) {
            if (clientId == null) {
                throw new NullPointerException("clientId is marked non-null but is null");
            }
            this.clientId = clientId;
        }

        public void setClientSecret(@NonNull String clientSecret) {
            if (clientSecret == null) {
                throw new NullPointerException("clientSecret is marked non-null but is null");
            }
            this.clientSecret = clientSecret;
        }

        public void setScopes(@NonNull String[] scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QrCodeGenerateInfo)) {
                return false;
            }
            QrCodeGenerateInfo other = (QrCodeGenerateInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$clientSecret = this.getClientSecret();
            String other$clientSecret = other.getClientSecret();
            if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
                return false;
            }
            return Arrays.deepEquals(this.getScopes(), other.getScopes());
        }

        protected boolean canEqual(Object other) {
            return other instanceof QrCodeGenerateInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $clientSecret = this.getClientSecret();
            result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getScopes());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.QrCodeGenerateInfo(clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", scopes=" + Arrays.deepToString(this.getScopes()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
        }
    }

    public static class VideoPreviewPlayInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;
        @NonNull
        private String category = "live_transcoding";
        private boolean getSubtitleInfo = true;
        private String templateId;
        private long urlExpireSec = 14400L;
        private boolean onlyVip;
        private boolean withPlayCursor;

        public VideoPreviewPlayInfo(@NonNull String driveId, @NonNull String fileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        @NonNull
        public String getCategory() {
            return this.category;
        }

        public boolean isGetSubtitleInfo() {
            return this.getSubtitleInfo;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public long getUrlExpireSec() {
            return this.urlExpireSec;
        }

        public boolean isOnlyVip() {
            return this.onlyVip;
        }

        public boolean isWithPlayCursor() {
            return this.withPlayCursor;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setCategory(@NonNull String category) {
            if (category == null) {
                throw new NullPointerException("category is marked non-null but is null");
            }
            this.category = category;
        }

        public void setGetSubtitleInfo(boolean getSubtitleInfo) {
            this.getSubtitleInfo = getSubtitleInfo;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public void setUrlExpireSec(long urlExpireSec) {
            this.urlExpireSec = urlExpireSec;
        }

        public void setOnlyVip(boolean onlyVip) {
            this.onlyVip = onlyVip;
        }

        public void setWithPlayCursor(boolean withPlayCursor) {
            this.withPlayCursor = withPlayCursor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VideoPreviewPlayInfo)) {
                return false;
            }
            VideoPreviewPlayInfo other = (VideoPreviewPlayInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isGetSubtitleInfo() != other.isGetSubtitleInfo()) {
                return false;
            }
            if (this.getUrlExpireSec() != other.getUrlExpireSec()) {
                return false;
            }
            if (this.isOnlyVip() != other.isOnlyVip()) {
                return false;
            }
            if (this.isWithPlayCursor() != other.isWithPlayCursor()) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$templateId = this.getTemplateId();
            String other$templateId = other.getTemplateId();
            return !(this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VideoPreviewPlayInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isGetSubtitleInfo() ? 79 : 97);
            long $urlExpireSec = this.getUrlExpireSec();
            result = result * 59 + (int)($urlExpireSec >>> 32 ^ $urlExpireSec);
            result = result * 59 + (this.isOnlyVip() ? 79 : 97);
            result = result * 59 + (this.isWithPlayCursor() ? 79 : 97);
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $templateId = this.getTemplateId();
            result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.VideoPreviewPlayInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ", category=" + this.getCategory() + ", getSubtitleInfo=" + this.isGetSubtitleInfo() + ", templateId=" + this.getTemplateId() + ", urlExpireSec=" + this.getUrlExpireSec() + ", onlyVip=" + this.isOnlyVip() + ", withPlayCursor=" + this.isWithPlayCursor() + ")";
        }
    }

    public static class FileDeleteInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;

        public FileDeleteInfo(@NonNull String driveId, @NonNull String fileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileDeleteInfo)) {
                return false;
            }
            FileDeleteInfo other = (FileDeleteInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            return !(this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileDeleteInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileDeleteInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ")";
        }
    }

    public static class FileRestoreFromTrashInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;

        public FileRestoreFromTrashInfo(@NonNull String driveId, @NonNull String fileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileRestoreFromTrashInfo)) {
                return false;
            }
            FileRestoreFromTrashInfo other = (FileRestoreFromTrashInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            return !(this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileRestoreFromTrashInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileRestoreFromTrashInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ")";
        }
    }

    public static class FileMoveToTrashInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;

        public FileMoveToTrashInfo(@NonNull String driveId, @NonNull String fileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileMoveToTrashInfo)) {
                return false;
            }
            FileMoveToTrashInfo other = (FileMoveToTrashInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            return !(this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileMoveToTrashInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileMoveToTrashInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ")";
        }
    }

    public static class FileCopyInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;
        @NonNull
        private String toDriveId;
        @NonNull
        private String toParentFileId;
        private boolean autoRename;

        public FileCopyInfo(@NonNull String driveId, @NonNull String fileId, @NonNull String toDriveId, @NonNull String toParentFileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            if (toDriveId == null) {
                throw new NullPointerException("toDriveId is marked non-null but is null");
            }
            if (toParentFileId == null) {
                throw new NullPointerException("toParentFileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
            this.toDriveId = toDriveId;
            this.toParentFileId = toParentFileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        @NonNull
        public String getToDriveId() {
            return this.toDriveId;
        }

        @NonNull
        public String getToParentFileId() {
            return this.toParentFileId;
        }

        public boolean isAutoRename() {
            return this.autoRename;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setToDriveId(@NonNull String toDriveId) {
            if (toDriveId == null) {
                throw new NullPointerException("toDriveId is marked non-null but is null");
            }
            this.toDriveId = toDriveId;
        }

        public void setToParentFileId(@NonNull String toParentFileId) {
            if (toParentFileId == null) {
                throw new NullPointerException("toParentFileId is marked non-null but is null");
            }
            this.toParentFileId = toParentFileId;
        }

        public void setAutoRename(boolean autoRename) {
            this.autoRename = autoRename;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileCopyInfo)) {
                return false;
            }
            FileCopyInfo other = (FileCopyInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAutoRename() != other.isAutoRename()) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$toDriveId = this.getToDriveId();
            String other$toDriveId = other.getToDriveId();
            if (this$toDriveId == null ? other$toDriveId != null : !this$toDriveId.equals(other$toDriveId)) {
                return false;
            }
            String this$toParentFileId = this.getToParentFileId();
            String other$toParentFileId = other.getToParentFileId();
            return !(this$toParentFileId == null ? other$toParentFileId != null : !this$toParentFileId.equals(other$toParentFileId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileCopyInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAutoRename() ? 79 : 97);
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $toDriveId = this.getToDriveId();
            result = result * 59 + ($toDriveId == null ? 43 : $toDriveId.hashCode());
            String $toParentFileId = this.getToParentFileId();
            result = result * 59 + ($toParentFileId == null ? 43 : $toParentFileId.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileCopyInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ", toDriveId=" + this.getToDriveId() + ", toParentFileId=" + this.getToParentFileId() + ", autoRename=" + this.isAutoRename() + ")";
        }
    }

    public static class FileMoveInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String toDriveId;
        @NonNull
        private String fileId;
        @NonNull
        private String toParentFileId;
        private AliyunDriveEnum.CheckNameMode checkNameMode;
        private String newName;

        public FileMoveInfo(@NonNull String driveId, @NonNull String toDriveId, @NonNull String fileId, @NonNull String toParentFileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (toDriveId == null) {
                throw new NullPointerException("toDriveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            if (toParentFileId == null) {
                throw new NullPointerException("toParentFileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.toDriveId = toDriveId;
            this.fileId = fileId;
            this.toParentFileId = toParentFileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getToDriveId() {
            return this.toDriveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        @NonNull
        public String getToParentFileId() {
            return this.toParentFileId;
        }

        public AliyunDriveEnum.CheckNameMode getCheckNameMode() {
            return this.checkNameMode;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setToDriveId(@NonNull String toDriveId) {
            if (toDriveId == null) {
                throw new NullPointerException("toDriveId is marked non-null but is null");
            }
            this.toDriveId = toDriveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setToParentFileId(@NonNull String toParentFileId) {
            if (toParentFileId == null) {
                throw new NullPointerException("toParentFileId is marked non-null but is null");
            }
            this.toParentFileId = toParentFileId;
        }

        public void setCheckNameMode(AliyunDriveEnum.CheckNameMode checkNameMode) {
            this.checkNameMode = checkNameMode;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileMoveInfo)) {
                return false;
            }
            FileMoveInfo other = (FileMoveInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$toDriveId = this.getToDriveId();
            String other$toDriveId = other.getToDriveId();
            if (this$toDriveId == null ? other$toDriveId != null : !this$toDriveId.equals(other$toDriveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$toParentFileId = this.getToParentFileId();
            String other$toParentFileId = other.getToParentFileId();
            if (this$toParentFileId == null ? other$toParentFileId != null : !this$toParentFileId.equals(other$toParentFileId)) {
                return false;
            }
            AliyunDriveEnum.CheckNameMode this$checkNameMode = this.getCheckNameMode();
            AliyunDriveEnum.CheckNameMode other$checkNameMode = other.getCheckNameMode();
            if (this$checkNameMode == null ? other$checkNameMode != null : !((Object)((Object)this$checkNameMode)).equals((Object)other$checkNameMode)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileMoveInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $toDriveId = this.getToDriveId();
            result = result * 59 + ($toDriveId == null ? 43 : $toDriveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $toParentFileId = this.getToParentFileId();
            result = result * 59 + ($toParentFileId == null ? 43 : $toParentFileId.hashCode());
            AliyunDriveEnum.CheckNameMode $checkNameMode = this.getCheckNameMode();
            result = result * 59 + ($checkNameMode == null ? 43 : ((Object)((Object)$checkNameMode)).hashCode());
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileMoveInfo(driveId=" + this.getDriveId() + ", toDriveId=" + this.getToDriveId() + ", fileId=" + this.getFileId() + ", toParentFileId=" + this.getToParentFileId() + ", checkNameMode=" + (Object)((Object)this.getCheckNameMode()) + ", newName=" + this.getNewName() + ")";
        }
    }

    public static class FileRenameInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;
        @NonNull
        private String name;
        @NonNull
        private transient String parentFileId;

        public FileRenameInfo(@NonNull String driveId, @NonNull String fileId, @NonNull String name, @NonNull String parentFileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (parentFileId == null) {
                throw new NullPointerException("parentFileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
            this.name = name;
            this.parentFileId = parentFileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public String getParentFileId() {
            return this.parentFileId;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        public void setParentFileId(@NonNull String parentFileId) {
            if (parentFileId == null) {
                throw new NullPointerException("parentFileId is marked non-null but is null");
            }
            this.parentFileId = parentFileId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileRenameInfo)) {
                return false;
            }
            FileRenameInfo other = (FileRenameInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileRenameInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileRenameInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ", name=" + this.getName() + ", parentFileId=" + this.getParentFileId() + ")";
        }
    }

    public static class FileUploadCompleteInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;
        @NonNull
        private String uploadId;

        public FileUploadCompleteInfo(@NonNull String driveId, @NonNull String fileId, @NonNull String uploadId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            if (uploadId == null) {
                throw new NullPointerException("uploadId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
            this.uploadId = uploadId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        @NonNull
        public String getUploadId() {
            return this.uploadId;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setUploadId(@NonNull String uploadId) {
            if (uploadId == null) {
                throw new NullPointerException("uploadId is marked non-null but is null");
            }
            this.uploadId = uploadId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileUploadCompleteInfo)) {
                return false;
            }
            FileUploadCompleteInfo other = (FileUploadCompleteInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$uploadId = this.getUploadId();
            String other$uploadId = other.getUploadId();
            return !(this$uploadId == null ? other$uploadId != null : !this$uploadId.equals(other$uploadId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileUploadCompleteInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $uploadId = this.getUploadId();
            result = result * 59 + ($uploadId == null ? 43 : $uploadId.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileUploadCompleteInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ", uploadId=" + this.getUploadId() + ")";
        }
    }

    public static class FileListUploadPartsInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;
        @NonNull
        private String uploadId;
        private List<AliyunDriveFilePartInfo> partInfoList;

        public FileListUploadPartsInfo(@NonNull String driveId, @NonNull String fileId, @NonNull String uploadId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            if (uploadId == null) {
                throw new NullPointerException("uploadId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
            this.uploadId = uploadId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        @NonNull
        public String getUploadId() {
            return this.uploadId;
        }

        public List<AliyunDriveFilePartInfo> getPartInfoList() {
            return this.partInfoList;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setUploadId(@NonNull String uploadId) {
            if (uploadId == null) {
                throw new NullPointerException("uploadId is marked non-null but is null");
            }
            this.uploadId = uploadId;
        }

        public void setPartInfoList(List<AliyunDriveFilePartInfo> partInfoList) {
            this.partInfoList = partInfoList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileListUploadPartsInfo)) {
                return false;
            }
            FileListUploadPartsInfo other = (FileListUploadPartsInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$uploadId = this.getUploadId();
            String other$uploadId = other.getUploadId();
            if (this$uploadId == null ? other$uploadId != null : !this$uploadId.equals(other$uploadId)) {
                return false;
            }
            List<AliyunDriveFilePartInfo> this$partInfoList = this.getPartInfoList();
            List<AliyunDriveFilePartInfo> other$partInfoList = other.getPartInfoList();
            return !(this$partInfoList == null ? other$partInfoList != null : !((Object)this$partInfoList).equals(other$partInfoList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileListUploadPartsInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $uploadId = this.getUploadId();
            result = result * 59 + ($uploadId == null ? 43 : $uploadId.hashCode());
            List<AliyunDriveFilePartInfo> $partInfoList = this.getPartInfoList();
            result = result * 59 + ($partInfoList == null ? 43 : ((Object)$partInfoList).hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileListUploadPartsInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ", uploadId=" + this.getUploadId() + ", partInfoList=" + this.getPartInfoList() + ")";
        }
    }

    public static class FileGetUploadUrlInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;
        @NonNull
        private String uploadId;
        @NonNull
        private List<AliyunDriveFilePartInfo> partInfoList;

        public FileGetUploadUrlInfo(@NonNull String driveId, @NonNull String fileId, @NonNull String uploadId, @NonNull List<AliyunDriveFilePartInfo> partInfoList) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            if (uploadId == null) {
                throw new NullPointerException("uploadId is marked non-null but is null");
            }
            if (partInfoList == null) {
                throw new NullPointerException("partInfoList is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
            this.uploadId = uploadId;
            this.partInfoList = partInfoList;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        @NonNull
        public String getUploadId() {
            return this.uploadId;
        }

        @NonNull
        public List<AliyunDriveFilePartInfo> getPartInfoList() {
            return this.partInfoList;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setUploadId(@NonNull String uploadId) {
            if (uploadId == null) {
                throw new NullPointerException("uploadId is marked non-null but is null");
            }
            this.uploadId = uploadId;
        }

        public void setPartInfoList(@NonNull List<AliyunDriveFilePartInfo> partInfoList) {
            if (partInfoList == null) {
                throw new NullPointerException("partInfoList is marked non-null but is null");
            }
            this.partInfoList = partInfoList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileGetUploadUrlInfo)) {
                return false;
            }
            FileGetUploadUrlInfo other = (FileGetUploadUrlInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$uploadId = this.getUploadId();
            String other$uploadId = other.getUploadId();
            if (this$uploadId == null ? other$uploadId != null : !this$uploadId.equals(other$uploadId)) {
                return false;
            }
            List<AliyunDriveFilePartInfo> this$partInfoList = this.getPartInfoList();
            List<AliyunDriveFilePartInfo> other$partInfoList = other.getPartInfoList();
            return !(this$partInfoList == null ? other$partInfoList != null : !((Object)this$partInfoList).equals(other$partInfoList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileGetUploadUrlInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $uploadId = this.getUploadId();
            result = result * 59 + ($uploadId == null ? 43 : $uploadId.hashCode());
            List<AliyunDriveFilePartInfo> $partInfoList = this.getPartInfoList();
            result = result * 59 + ($partInfoList == null ? 43 : ((Object)$partInfoList).hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileGetUploadUrlInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ", uploadId=" + this.getUploadId() + ", partInfoList=" + this.getPartInfoList() + ")";
        }
    }

    public static class FileCreateInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String parentFileId;
        @NonNull
        private String name;
        @NonNull
        private AliyunDriveEnum.Type type;
        @NonNull
        private AliyunDriveEnum.CheckNameMode checkNameMode;
        private List<AliyunDriveFilePartInfo> partInfoList;
        private Boolean parallelUpload;
        private String preHash;
        private long size;
        private String contentHash;
        private String contentHashName;
        private String proofCode;
        private Date localCreatedAt;
        private Date localModifiedAt;

        public FileCreateInfo(@NonNull String driveId, @NonNull String parentFileId, @NonNull String name, @NonNull AliyunDriveEnum.Type type, @NonNull AliyunDriveEnum.CheckNameMode checkNameMode) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (parentFileId == null) {
                throw new NullPointerException("parentFileId is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (checkNameMode == null) {
                throw new NullPointerException("checkNameMode is marked non-null but is null");
            }
            this.driveId = driveId;
            this.parentFileId = parentFileId;
            this.name = name;
            this.type = type;
            this.checkNameMode = checkNameMode;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getParentFileId() {
            return this.parentFileId;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public AliyunDriveEnum.Type getType() {
            return this.type;
        }

        @NonNull
        public AliyunDriveEnum.CheckNameMode getCheckNameMode() {
            return this.checkNameMode;
        }

        public List<AliyunDriveFilePartInfo> getPartInfoList() {
            return this.partInfoList;
        }

        public Boolean getParallelUpload() {
            return this.parallelUpload;
        }

        public String getPreHash() {
            return this.preHash;
        }

        public long getSize() {
            return this.size;
        }

        public String getContentHash() {
            return this.contentHash;
        }

        public String getContentHashName() {
            return this.contentHashName;
        }

        public String getProofCode() {
            return this.proofCode;
        }

        public Date getLocalCreatedAt() {
            return this.localCreatedAt;
        }

        public Date getLocalModifiedAt() {
            return this.localModifiedAt;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setParentFileId(@NonNull String parentFileId) {
            if (parentFileId == null) {
                throw new NullPointerException("parentFileId is marked non-null but is null");
            }
            this.parentFileId = parentFileId;
        }

        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        public void setType(@NonNull AliyunDriveEnum.Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        public void setCheckNameMode(@NonNull AliyunDriveEnum.CheckNameMode checkNameMode) {
            if (checkNameMode == null) {
                throw new NullPointerException("checkNameMode is marked non-null but is null");
            }
            this.checkNameMode = checkNameMode;
        }

        public void setPartInfoList(List<AliyunDriveFilePartInfo> partInfoList) {
            this.partInfoList = partInfoList;
        }

        public void setParallelUpload(Boolean parallelUpload) {
            this.parallelUpload = parallelUpload;
        }

        public void setPreHash(String preHash) {
            this.preHash = preHash;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setContentHash(String contentHash) {
            this.contentHash = contentHash;
        }

        public void setContentHashName(String contentHashName) {
            this.contentHashName = contentHashName;
        }

        public void setProofCode(String proofCode) {
            this.proofCode = proofCode;
        }

        public void setLocalCreatedAt(Date localCreatedAt) {
            this.localCreatedAt = localCreatedAt;
        }

        public void setLocalModifiedAt(Date localModifiedAt) {
            this.localModifiedAt = localModifiedAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileCreateInfo)) {
                return false;
            }
            FileCreateInfo other = (FileCreateInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            Boolean this$parallelUpload = this.getParallelUpload();
            Boolean other$parallelUpload = other.getParallelUpload();
            if (this$parallelUpload == null ? other$parallelUpload != null : !((Object)this$parallelUpload).equals(other$parallelUpload)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$parentFileId = this.getParentFileId();
            String other$parentFileId = other.getParentFileId();
            if (this$parentFileId == null ? other$parentFileId != null : !this$parentFileId.equals(other$parentFileId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            AliyunDriveEnum.Type this$type = this.getType();
            AliyunDriveEnum.Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            AliyunDriveEnum.CheckNameMode this$checkNameMode = this.getCheckNameMode();
            AliyunDriveEnum.CheckNameMode other$checkNameMode = other.getCheckNameMode();
            if (this$checkNameMode == null ? other$checkNameMode != null : !((Object)((Object)this$checkNameMode)).equals((Object)other$checkNameMode)) {
                return false;
            }
            List<AliyunDriveFilePartInfo> this$partInfoList = this.getPartInfoList();
            List<AliyunDriveFilePartInfo> other$partInfoList = other.getPartInfoList();
            if (this$partInfoList == null ? other$partInfoList != null : !((Object)this$partInfoList).equals(other$partInfoList)) {
                return false;
            }
            String this$preHash = this.getPreHash();
            String other$preHash = other.getPreHash();
            if (this$preHash == null ? other$preHash != null : !this$preHash.equals(other$preHash)) {
                return false;
            }
            String this$contentHash = this.getContentHash();
            String other$contentHash = other.getContentHash();
            if (this$contentHash == null ? other$contentHash != null : !this$contentHash.equals(other$contentHash)) {
                return false;
            }
            String this$contentHashName = this.getContentHashName();
            String other$contentHashName = other.getContentHashName();
            if (this$contentHashName == null ? other$contentHashName != null : !this$contentHashName.equals(other$contentHashName)) {
                return false;
            }
            String this$proofCode = this.getProofCode();
            String other$proofCode = other.getProofCode();
            if (this$proofCode == null ? other$proofCode != null : !this$proofCode.equals(other$proofCode)) {
                return false;
            }
            Date this$localCreatedAt = this.getLocalCreatedAt();
            Date other$localCreatedAt = other.getLocalCreatedAt();
            if (this$localCreatedAt == null ? other$localCreatedAt != null : !((Object)this$localCreatedAt).equals(other$localCreatedAt)) {
                return false;
            }
            Date this$localModifiedAt = this.getLocalModifiedAt();
            Date other$localModifiedAt = other.getLocalModifiedAt();
            return !(this$localModifiedAt == null ? other$localModifiedAt != null : !((Object)this$localModifiedAt).equals(other$localModifiedAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileCreateInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            Boolean $parallelUpload = this.getParallelUpload();
            result = result * 59 + ($parallelUpload == null ? 43 : ((Object)$parallelUpload).hashCode());
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $parentFileId = this.getParentFileId();
            result = result * 59 + ($parentFileId == null ? 43 : $parentFileId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            AliyunDriveEnum.Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            AliyunDriveEnum.CheckNameMode $checkNameMode = this.getCheckNameMode();
            result = result * 59 + ($checkNameMode == null ? 43 : ((Object)((Object)$checkNameMode)).hashCode());
            List<AliyunDriveFilePartInfo> $partInfoList = this.getPartInfoList();
            result = result * 59 + ($partInfoList == null ? 43 : ((Object)$partInfoList).hashCode());
            String $preHash = this.getPreHash();
            result = result * 59 + ($preHash == null ? 43 : $preHash.hashCode());
            String $contentHash = this.getContentHash();
            result = result * 59 + ($contentHash == null ? 43 : $contentHash.hashCode());
            String $contentHashName = this.getContentHashName();
            result = result * 59 + ($contentHashName == null ? 43 : $contentHashName.hashCode());
            String $proofCode = this.getProofCode();
            result = result * 59 + ($proofCode == null ? 43 : $proofCode.hashCode());
            Date $localCreatedAt = this.getLocalCreatedAt();
            result = result * 59 + ($localCreatedAt == null ? 43 : ((Object)$localCreatedAt).hashCode());
            Date $localModifiedAt = this.getLocalModifiedAt();
            result = result * 59 + ($localModifiedAt == null ? 43 : ((Object)$localModifiedAt).hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileCreateInfo(driveId=" + this.getDriveId() + ", parentFileId=" + this.getParentFileId() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", checkNameMode=" + (Object)((Object)this.getCheckNameMode()) + ", partInfoList=" + this.getPartInfoList() + ", parallelUpload=" + this.getParallelUpload() + ", preHash=" + this.getPreHash() + ", size=" + this.getSize() + ", contentHash=" + this.getContentHash() + ", contentHashName=" + this.getContentHashName() + ", proofCode=" + this.getProofCode() + ", localCreatedAt=" + this.getLocalCreatedAt() + ", localModifiedAt=" + this.getLocalModifiedAt() + ")";
        }

        public static class StreamInfo {
            private String content_hash;
            private String content_hash_name;
            private String proof_version;
            private String proof_code;
            private String content_md5;
            private String pre_hash;
            private String size;
            private List<AliyunDriveFilePartInfo> partInfoList;

            public String getContent_hash() {
                return this.content_hash;
            }

            public String getContent_hash_name() {
                return this.content_hash_name;
            }

            public String getProof_version() {
                return this.proof_version;
            }

            public String getProof_code() {
                return this.proof_code;
            }

            public String getContent_md5() {
                return this.content_md5;
            }

            public String getPre_hash() {
                return this.pre_hash;
            }

            public String getSize() {
                return this.size;
            }

            public List<AliyunDriveFilePartInfo> getPartInfoList() {
                return this.partInfoList;
            }

            public void setContent_hash(String content_hash) {
                this.content_hash = content_hash;
            }

            public void setContent_hash_name(String content_hash_name) {
                this.content_hash_name = content_hash_name;
            }

            public void setProof_version(String proof_version) {
                this.proof_version = proof_version;
            }

            public void setProof_code(String proof_code) {
                this.proof_code = proof_code;
            }

            public void setContent_md5(String content_md5) {
                this.content_md5 = content_md5;
            }

            public void setPre_hash(String pre_hash) {
                this.pre_hash = pre_hash;
            }

            public void setSize(String size) {
                this.size = size;
            }

            public void setPartInfoList(List<AliyunDriveFilePartInfo> partInfoList) {
                this.partInfoList = partInfoList;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StreamInfo)) {
                    return false;
                }
                StreamInfo other = (StreamInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$content_hash = this.getContent_hash();
                String other$content_hash = other.getContent_hash();
                if (this$content_hash == null ? other$content_hash != null : !this$content_hash.equals(other$content_hash)) {
                    return false;
                }
                String this$content_hash_name = this.getContent_hash_name();
                String other$content_hash_name = other.getContent_hash_name();
                if (this$content_hash_name == null ? other$content_hash_name != null : !this$content_hash_name.equals(other$content_hash_name)) {
                    return false;
                }
                String this$proof_version = this.getProof_version();
                String other$proof_version = other.getProof_version();
                if (this$proof_version == null ? other$proof_version != null : !this$proof_version.equals(other$proof_version)) {
                    return false;
                }
                String this$proof_code = this.getProof_code();
                String other$proof_code = other.getProof_code();
                if (this$proof_code == null ? other$proof_code != null : !this$proof_code.equals(other$proof_code)) {
                    return false;
                }
                String this$content_md5 = this.getContent_md5();
                String other$content_md5 = other.getContent_md5();
                if (this$content_md5 == null ? other$content_md5 != null : !this$content_md5.equals(other$content_md5)) {
                    return false;
                }
                String this$pre_hash = this.getPre_hash();
                String other$pre_hash = other.getPre_hash();
                if (this$pre_hash == null ? other$pre_hash != null : !this$pre_hash.equals(other$pre_hash)) {
                    return false;
                }
                String this$size = this.getSize();
                String other$size = other.getSize();
                if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
                    return false;
                }
                List<AliyunDriveFilePartInfo> this$partInfoList = this.getPartInfoList();
                List<AliyunDriveFilePartInfo> other$partInfoList = other.getPartInfoList();
                return !(this$partInfoList == null ? other$partInfoList != null : !((Object)this$partInfoList).equals(other$partInfoList));
            }

            protected boolean canEqual(Object other) {
                return other instanceof StreamInfo;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $content_hash = this.getContent_hash();
                result = result * 59 + ($content_hash == null ? 43 : $content_hash.hashCode());
                String $content_hash_name = this.getContent_hash_name();
                result = result * 59 + ($content_hash_name == null ? 43 : $content_hash_name.hashCode());
                String $proof_version = this.getProof_version();
                result = result * 59 + ($proof_version == null ? 43 : $proof_version.hashCode());
                String $proof_code = this.getProof_code();
                result = result * 59 + ($proof_code == null ? 43 : $proof_code.hashCode());
                String $content_md5 = this.getContent_md5();
                result = result * 59 + ($content_md5 == null ? 43 : $content_md5.hashCode());
                String $pre_hash = this.getPre_hash();
                result = result * 59 + ($pre_hash == null ? 43 : $pre_hash.hashCode());
                String $size = this.getSize();
                result = result * 59 + ($size == null ? 43 : $size.hashCode());
                List<AliyunDriveFilePartInfo> $partInfoList = this.getPartInfoList();
                result = result * 59 + ($partInfoList == null ? 43 : ((Object)$partInfoList).hashCode());
                return result;
            }

            public String toString() {
                return "AliyunDriveRequest.FileCreateInfo.StreamInfo(content_hash=" + this.getContent_hash() + ", content_hash_name=" + this.getContent_hash_name() + ", proof_version=" + this.getProof_version() + ", proof_code=" + this.getProof_code() + ", content_md5=" + this.getContent_md5() + ", pre_hash=" + this.getPre_hash() + ", size=" + this.getSize() + ", partInfoList=" + this.getPartInfoList() + ")";
            }
        }
    }

    public static class FileGetDownloadUrlInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;
        private int expireSec = 900;

        public FileGetDownloadUrlInfo(@NonNull String driveId, @NonNull String fileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        public int getExpireSec() {
            return this.expireSec;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setExpireSec(int expireSec) {
            this.expireSec = expireSec;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileGetDownloadUrlInfo)) {
                return false;
            }
            FileGetDownloadUrlInfo other = (FileGetDownloadUrlInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireSec() != other.getExpireSec()) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            return !(this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileGetDownloadUrlInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExpireSec();
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileGetDownloadUrlInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ", expireSec=" + this.getExpireSec() + ")";
        }
    }

    public static class FileBatchGetInfo {
        @NonNull
        private List<FileInfo> fileList;

        public FileBatchGetInfo(@NonNull List<FileInfo> fileList) {
            if (fileList == null) {
                throw new NullPointerException("fileList is marked non-null but is null");
            }
            this.fileList = fileList;
        }

        @NonNull
        public List<FileInfo> getFileList() {
            return this.fileList;
        }

        public void setFileList(@NonNull List<FileInfo> fileList) {
            if (fileList == null) {
                throw new NullPointerException("fileList is marked non-null but is null");
            }
            this.fileList = fileList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileBatchGetInfo)) {
                return false;
            }
            FileBatchGetInfo other = (FileBatchGetInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<FileInfo> this$fileList = this.getFileList();
            List<FileInfo> other$fileList = other.getFileList();
            return !(this$fileList == null ? other$fileList != null : !((Object)this$fileList).equals(other$fileList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileBatchGetInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<FileInfo> $fileList = this.getFileList();
            result = result * 59 + ($fileList == null ? 43 : ((Object)$fileList).hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileBatchGetInfo(fileList=" + this.getFileList() + ")";
        }

        public static class FileInfo {
            @NonNull
            private String driveId;
            @NonNull
            private String fileId;

            public FileInfo(@NonNull String driveId, @NonNull String fileId) {
                if (driveId == null) {
                    throw new NullPointerException("driveId is marked non-null but is null");
                }
                if (fileId == null) {
                    throw new NullPointerException("fileId is marked non-null but is null");
                }
                this.driveId = driveId;
                this.fileId = fileId;
            }

            @NonNull
            public String getDriveId() {
                return this.driveId;
            }

            @NonNull
            public String getFileId() {
                return this.fileId;
            }

            public void setDriveId(@NonNull String driveId) {
                if (driveId == null) {
                    throw new NullPointerException("driveId is marked non-null but is null");
                }
                this.driveId = driveId;
            }

            public void setFileId(@NonNull String fileId) {
                if (fileId == null) {
                    throw new NullPointerException("fileId is marked non-null but is null");
                }
                this.fileId = fileId;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FileInfo)) {
                    return false;
                }
                FileInfo other = (FileInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$driveId = this.getDriveId();
                String other$driveId = other.getDriveId();
                if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                    return false;
                }
                String this$fileId = this.getFileId();
                String other$fileId = other.getFileId();
                return !(this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof FileInfo;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $driveId = this.getDriveId();
                result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
                String $fileId = this.getFileId();
                result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
                return result;
            }

            public String toString() {
                return "AliyunDriveRequest.FileBatchGetInfo.FileInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ")";
            }
        }
    }

    public static class FileGetByPathInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String filePath;

        public FileGetByPathInfo(@NonNull String driveId, @NonNull String filePath) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (filePath == null) {
                throw new NullPointerException("filePath is marked non-null but is null");
            }
            this.driveId = driveId;
            this.filePath = filePath;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFilePath() {
            return this.filePath;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFilePath(@NonNull String filePath) {
            if (filePath == null) {
                throw new NullPointerException("filePath is marked non-null but is null");
            }
            this.filePath = filePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileGetByPathInfo)) {
                return false;
            }
            FileGetByPathInfo other = (FileGetByPathInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            return !(this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileGetByPathInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileGetByPathInfo(driveId=" + this.getDriveId() + ", filePath=" + this.getFilePath() + ")";
        }
    }

    public static class FileGetInfo {
        @NonNull
        private String driveId;
        @NonNull
        private String fileId;
        private String category;
        @SerializedName(value="video_thumbnail_time")
        private Integer videoThumbnailTimeMS;
        private Integer videoThumbnailWidth;
        private Integer imageThumbnailWidth;
        private String videoThumbnailProcess;

        public FileGetInfo(@NonNull String driveId, @NonNull String fileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.fileId = fileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        public String getCategory() {
            return this.category;
        }

        public Integer getVideoThumbnailTimeMS() {
            return this.videoThumbnailTimeMS;
        }

        public Integer getVideoThumbnailWidth() {
            return this.videoThumbnailWidth;
        }

        public Integer getImageThumbnailWidth() {
            return this.imageThumbnailWidth;
        }

        public String getVideoThumbnailProcess() {
            return this.videoThumbnailProcess;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public void setVideoThumbnailTimeMS(Integer videoThumbnailTimeMS) {
            this.videoThumbnailTimeMS = videoThumbnailTimeMS;
        }

        public void setVideoThumbnailWidth(Integer videoThumbnailWidth) {
            this.videoThumbnailWidth = videoThumbnailWidth;
        }

        public void setImageThumbnailWidth(Integer imageThumbnailWidth) {
            this.imageThumbnailWidth = imageThumbnailWidth;
        }

        public void setVideoThumbnailProcess(String videoThumbnailProcess) {
            this.videoThumbnailProcess = videoThumbnailProcess;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileGetInfo)) {
                return false;
            }
            FileGetInfo other = (FileGetInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            Integer other$videoThumbnailTimeMS = other.getVideoThumbnailTimeMS();
            if (this$videoThumbnailTimeMS == null ? other$videoThumbnailTimeMS != null : !((Object)this$videoThumbnailTimeMS).equals(other$videoThumbnailTimeMS)) {
                return false;
            }
            Integer this$videoThumbnailWidth = this.getVideoThumbnailWidth();
            Integer other$videoThumbnailWidth = other.getVideoThumbnailWidth();
            if (this$videoThumbnailWidth == null ? other$videoThumbnailWidth != null : !((Object)this$videoThumbnailWidth).equals(other$videoThumbnailWidth)) {
                return false;
            }
            Integer this$imageThumbnailWidth = this.getImageThumbnailWidth();
            Integer other$imageThumbnailWidth = other.getImageThumbnailWidth();
            if (this$imageThumbnailWidth == null ? other$imageThumbnailWidth != null : !((Object)this$imageThumbnailWidth).equals(other$imageThumbnailWidth)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$videoThumbnailProcess = this.getVideoThumbnailProcess();
            String other$videoThumbnailProcess = other.getVideoThumbnailProcess();
            return !(this$videoThumbnailProcess == null ? other$videoThumbnailProcess != null : !this$videoThumbnailProcess.equals(other$videoThumbnailProcess));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileGetInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            result = result * 59 + ($videoThumbnailTimeMS == null ? 43 : ((Object)$videoThumbnailTimeMS).hashCode());
            Integer $videoThumbnailWidth = this.getVideoThumbnailWidth();
            result = result * 59 + ($videoThumbnailWidth == null ? 43 : ((Object)$videoThumbnailWidth).hashCode());
            Integer $imageThumbnailWidth = this.getImageThumbnailWidth();
            result = result * 59 + ($imageThumbnailWidth == null ? 43 : ((Object)$imageThumbnailWidth).hashCode());
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $videoThumbnailProcess = this.getVideoThumbnailProcess();
            result = result * 59 + ($videoThumbnailProcess == null ? 43 : $videoThumbnailProcess.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileGetInfo(driveId=" + this.getDriveId() + ", fileId=" + this.getFileId() + ", category=" + this.getCategory() + ", videoThumbnailTimeMS=" + this.getVideoThumbnailTimeMS() + ", videoThumbnailWidth=" + this.getVideoThumbnailWidth() + ", imageThumbnailWidth=" + this.getImageThumbnailWidth() + ", videoThumbnailProcess=" + this.getVideoThumbnailProcess() + ")";
        }
    }

    public static class FileListInfo {
        @NonNull
        private String driveId;
        private int limit = 100;
        private String marker;
        private AliyunDriveEnum.OrderBy orderBy;
        private AliyunDriveEnum.OrderDirection orderDirection;
        @NonNull
        private String parentFileId;
        @SerializedName(value="category")
        private String categories;
        @SerializedName(value="video_thumbnail_time")
        private Integer videoThumbnailTimeMS;
        private Integer videoThumbnailWidth;
        private Integer imageThumbnailWidth;
        private String fields = "*";

        public FileListInfo(@NonNull String driveId, @NonNull String parentFileId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            if (parentFileId == null) {
                throw new NullPointerException("parentFileId is marked non-null but is null");
            }
            this.driveId = driveId;
            this.parentFileId = parentFileId;
        }

        @NonNull
        public String getDriveId() {
            return this.driveId;
        }

        public int getLimit() {
            return this.limit;
        }

        public String getMarker() {
            return this.marker;
        }

        public AliyunDriveEnum.OrderBy getOrderBy() {
            return this.orderBy;
        }

        public AliyunDriveEnum.OrderDirection getOrderDirection() {
            return this.orderDirection;
        }

        @NonNull
        public String getParentFileId() {
            return this.parentFileId;
        }

        public String getCategories() {
            return this.categories;
        }

        public Integer getVideoThumbnailTimeMS() {
            return this.videoThumbnailTimeMS;
        }

        public Integer getVideoThumbnailWidth() {
            return this.videoThumbnailWidth;
        }

        public Integer getImageThumbnailWidth() {
            return this.imageThumbnailWidth;
        }

        public String getFields() {
            return this.fields;
        }

        public void setDriveId(@NonNull String driveId) {
            if (driveId == null) {
                throw new NullPointerException("driveId is marked non-null but is null");
            }
            this.driveId = driveId;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public void setMarker(String marker) {
            this.marker = marker;
        }

        public void setOrderBy(AliyunDriveEnum.OrderBy orderBy) {
            this.orderBy = orderBy;
        }

        public void setOrderDirection(AliyunDriveEnum.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
        }

        public void setParentFileId(@NonNull String parentFileId) {
            if (parentFileId == null) {
                throw new NullPointerException("parentFileId is marked non-null but is null");
            }
            this.parentFileId = parentFileId;
        }

        public void setCategories(String categories) {
            this.categories = categories;
        }

        public void setVideoThumbnailTimeMS(Integer videoThumbnailTimeMS) {
            this.videoThumbnailTimeMS = videoThumbnailTimeMS;
        }

        public void setVideoThumbnailWidth(Integer videoThumbnailWidth) {
            this.videoThumbnailWidth = videoThumbnailWidth;
        }

        public void setImageThumbnailWidth(Integer imageThumbnailWidth) {
            this.imageThumbnailWidth = imageThumbnailWidth;
        }

        public void setFields(String fields) {
            this.fields = fields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileListInfo)) {
                return false;
            }
            FileListInfo other = (FileListInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            Integer this$videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            Integer other$videoThumbnailTimeMS = other.getVideoThumbnailTimeMS();
            if (this$videoThumbnailTimeMS == null ? other$videoThumbnailTimeMS != null : !((Object)this$videoThumbnailTimeMS).equals(other$videoThumbnailTimeMS)) {
                return false;
            }
            Integer this$videoThumbnailWidth = this.getVideoThumbnailWidth();
            Integer other$videoThumbnailWidth = other.getVideoThumbnailWidth();
            if (this$videoThumbnailWidth == null ? other$videoThumbnailWidth != null : !((Object)this$videoThumbnailWidth).equals(other$videoThumbnailWidth)) {
                return false;
            }
            Integer this$imageThumbnailWidth = this.getImageThumbnailWidth();
            Integer other$imageThumbnailWidth = other.getImageThumbnailWidth();
            if (this$imageThumbnailWidth == null ? other$imageThumbnailWidth != null : !((Object)this$imageThumbnailWidth).equals(other$imageThumbnailWidth)) {
                return false;
            }
            String this$driveId = this.getDriveId();
            String other$driveId = other.getDriveId();
            if (this$driveId == null ? other$driveId != null : !this$driveId.equals(other$driveId)) {
                return false;
            }
            String this$marker = this.getMarker();
            String other$marker = other.getMarker();
            if (this$marker == null ? other$marker != null : !this$marker.equals(other$marker)) {
                return false;
            }
            AliyunDriveEnum.OrderBy this$orderBy = this.getOrderBy();
            AliyunDriveEnum.OrderBy other$orderBy = other.getOrderBy();
            if (this$orderBy == null ? other$orderBy != null : !((Object)((Object)this$orderBy)).equals((Object)other$orderBy)) {
                return false;
            }
            AliyunDriveEnum.OrderDirection this$orderDirection = this.getOrderDirection();
            AliyunDriveEnum.OrderDirection other$orderDirection = other.getOrderDirection();
            if (this$orderDirection == null ? other$orderDirection != null : !((Object)((Object)this$orderDirection)).equals((Object)other$orderDirection)) {
                return false;
            }
            String this$parentFileId = this.getParentFileId();
            String other$parentFileId = other.getParentFileId();
            if (this$parentFileId == null ? other$parentFileId != null : !this$parentFileId.equals(other$parentFileId)) {
                return false;
            }
            String this$categories = this.getCategories();
            String other$categories = other.getCategories();
            if (this$categories == null ? other$categories != null : !this$categories.equals(other$categories)) {
                return false;
            }
            String this$fields = this.getFields();
            String other$fields = other.getFields();
            return !(this$fields == null ? other$fields != null : !this$fields.equals(other$fields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileListInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLimit();
            Integer $videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            result = result * 59 + ($videoThumbnailTimeMS == null ? 43 : ((Object)$videoThumbnailTimeMS).hashCode());
            Integer $videoThumbnailWidth = this.getVideoThumbnailWidth();
            result = result * 59 + ($videoThumbnailWidth == null ? 43 : ((Object)$videoThumbnailWidth).hashCode());
            Integer $imageThumbnailWidth = this.getImageThumbnailWidth();
            result = result * 59 + ($imageThumbnailWidth == null ? 43 : ((Object)$imageThumbnailWidth).hashCode());
            String $driveId = this.getDriveId();
            result = result * 59 + ($driveId == null ? 43 : $driveId.hashCode());
            String $marker = this.getMarker();
            result = result * 59 + ($marker == null ? 43 : $marker.hashCode());
            AliyunDriveEnum.OrderBy $orderBy = this.getOrderBy();
            result = result * 59 + ($orderBy == null ? 43 : ((Object)((Object)$orderBy)).hashCode());
            AliyunDriveEnum.OrderDirection $orderDirection = this.getOrderDirection();
            result = result * 59 + ($orderDirection == null ? 43 : ((Object)((Object)$orderDirection)).hashCode());
            String $parentFileId = this.getParentFileId();
            result = result * 59 + ($parentFileId == null ? 43 : $parentFileId.hashCode());
            String $categories = this.getCategories();
            result = result * 59 + ($categories == null ? 43 : $categories.hashCode());
            String $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.FileListInfo(driveId=" + this.getDriveId() + ", limit=" + this.getLimit() + ", marker=" + this.getMarker() + ", orderBy=" + (Object)((Object)this.getOrderBy()) + ", orderDirection=" + (Object)((Object)this.getOrderDirection()) + ", parentFileId=" + this.getParentFileId() + ", categories=" + this.getCategories() + ", videoThumbnailTimeMS=" + this.getVideoThumbnailTimeMS() + ", videoThumbnailWidth=" + this.getVideoThumbnailWidth() + ", imageThumbnailWidth=" + this.getImageThumbnailWidth() + ", fields=" + this.getFields() + ")";
        }
    }

    public static class AccessTokenInfo {
        private String clientId;
        private String clientSecret;
        private AliyunDriveEnum.GrantType grantType;
        private String code;
        private String refreshToken;

        public String getClientId() {
            return this.clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public AliyunDriveEnum.GrantType getGrantType() {
            return this.grantType;
        }

        public String getCode() {
            return this.code;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public void setGrantType(AliyunDriveEnum.GrantType grantType) {
            this.grantType = grantType;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccessTokenInfo)) {
                return false;
            }
            AccessTokenInfo other = (AccessTokenInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$clientSecret = this.getClientSecret();
            String other$clientSecret = other.getClientSecret();
            if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
                return false;
            }
            AliyunDriveEnum.GrantType this$grantType = this.getGrantType();
            AliyunDriveEnum.GrantType other$grantType = other.getGrantType();
            if (this$grantType == null ? other$grantType != null : !((Object)((Object)this$grantType)).equals((Object)other$grantType)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$refreshToken = this.getRefreshToken();
            String other$refreshToken = other.getRefreshToken();
            return !(this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AccessTokenInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $clientSecret = this.getClientSecret();
            result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
            AliyunDriveEnum.GrantType $grantType = this.getGrantType();
            result = result * 59 + ($grantType == null ? 43 : ((Object)((Object)$grantType)).hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveRequest.AccessTokenInfo(clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", grantType=" + (Object)((Object)this.getGrantType()) + ", code=" + this.getCode() + ", refreshToken=" + this.getRefreshToken() + ")";
        }
    }
}

