/*
 * Decompiled with CFR 0.152.
 */
package net.xdob.ratly.so;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.xdob.onlooker.DefaultOnlookerClient;
import net.xdob.onlooker.MessageToken;
import net.xdob.onlooker.OnlookerClient;
import net.xdob.ratly.security.SignHelper;
import net.xdob.ratly.server.StateObserver;
import net.xdob.ratly.server.TermLeader;

public class StateObserver4Onlooker
implements StateObserver {
    private final SignHelper signHelper = new SignHelper();
    private final OnlookerClient onlookerClient = new DefaultOnlookerClient();
    private final AtomicBoolean started = new AtomicBoolean(false);

    public String getName() {
        return "so4onlooker";
    }

    public void start(ScheduledExecutorService scheduled) {
        if (this.started.compareAndSet(false, true)) {
            this.onlookerClient.start();
        }
    }

    public void notifyTeamIndex(String groupId, TermLeader termLeader) {
        MessageToken token = new MessageToken();
        token.setSigner(this.signHelper.getSigner());
        token.setMessage(termLeader.toString());
        token.setSign(this.signHelper.sign(token.getMessage()));
        token.setTeam(termLeader.getTerm());
        token.setIndex(termLeader.getIndex());
        this.onlookerClient.setMessage(groupId, token);
    }

    public CompletableFuture<TermLeader> getLastLeaderTerm(String groupId, int waitMS) {
        CompletableFuture<TermLeader> future = new CompletableFuture<TermLeader>();
        this.onlookerClient.getMessageToken(groupId.toString(), waitMS).whenComplete((r, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                List termLeaders = r.stream().filter(e -> this.signHelper.verifySign(e.getMessage(), e.getSign())).map(m -> {
                    TermLeader leader = TermLeader.parse((String)m.getMessage());
                    leader.setIndex(m.getIndex());
                    return leader;
                }).collect(Collectors.toList());
                long term = termLeaders.stream().mapToLong(TermLeader::getTerm).max().orElse(-1L);
                TermLeader termLeader = termLeaders.stream().filter(e -> e.getTerm() == term).max(Comparator.comparingLong(TermLeader::getIndex)).orElse(null);
                future.complete(termLeader);
            }
        });
        return future;
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.onlookerClient.stop();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }
}

