/*
 * Decompiled with CFR 0.152.
 */
package net.xdob.pf4boot.loader;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import net.xdob.pf4boot.internal.Pf4bootPluginClassLoader;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.util.FileUtils;
import org.pf4j.util.JarFileFilter;
import org.pf4j.util.Unzip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipPf4bootPluginLoader
implements PluginLoader {
    static final Logger log = LoggerFactory.getLogger(ZipPf4bootPluginLoader.class);
    protected PluginManager pluginManager;

    public ZipPf4bootPluginLoader(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public boolean isApplicable(Path pluginPath) {
        return Files.exists(pluginPath, new LinkOption[0]) && FileUtils.isZipFile((Path)pluginPath);
    }

    public ClassLoader loadPlugin(Path pluginPath, PluginDescriptor pluginDescriptor) {
        Pf4bootPluginClassLoader pluginClassLoader = new Pf4bootPluginClassLoader(this.pluginManager, pluginDescriptor);
        File cache = this.pluginManager.getPluginsRoot().resolveSibling("plugin-cache").toFile();
        if (!cache.exists()) {
            cache.mkdirs();
        }
        if (FileUtils.isZipFile((Path)pluginPath)) {
            try {
                File[] libs;
                String fileName = pluginPath.getFileName().toString();
                String directoryName = fileName.substring(0, fileName.lastIndexOf("."));
                Path pluginDirectory = cache.toPath().resolve(directoryName);
                ZipPf4bootPluginLoader.expandIfZip(pluginPath, pluginDirectory);
                for (File lib : libs = pluginDirectory.resolve("lib").toFile().listFiles((FileFilter)new JarFileFilter())) {
                    pluginClassLoader.addFile(lib);
                }
            }
            catch (IOException e) {
                log.error("Cannot expand plugin zip '{}'", (Object)pluginPath);
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return pluginClassLoader;
    }

    public static Path expandIfZip(Path filePath, Path pluginDirectory) throws IOException {
        if (!FileUtils.isZipFile((Path)filePath)) {
            return filePath;
        }
        FileTime pluginZipDate = Files.getLastModifiedTime(filePath, new LinkOption[0]);
        if (!Files.exists(pluginDirectory, new LinkOption[0]) || pluginZipDate.compareTo(Files.getLastModifiedTime(pluginDirectory, new LinkOption[0])) > 0) {
            Unzip unzip = new Unzip();
            unzip.setSource(filePath.toFile());
            unzip.setDestination(pluginDirectory.toFile());
            unzip.extract();
            log.info("Expanded plugin zip '{}' in '{}'", (Object)filePath.getFileName(), (Object)pluginDirectory.getFileName());
        }
        return pluginDirectory;
    }
}

