/*
 * Decompiled with CFR 0.152.
 */
package net.xdob.pf4boot.loader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import net.xdob.pf4boot.internal.Pf4bootPluginClassLoader;
import net.xdob.pf4boot.loader.archive.Archive;
import net.xdob.pf4boot.loader.archive.JarFileArchive;
import net.xdob.pf4boot.loader.jar.JarFile;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.PluginRuntimeException;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarPf4bootPluginLoader
implements PluginLoader {
    static final Logger log = LoggerFactory.getLogger(JarPf4bootPluginLoader.class);
    protected PluginManager pluginManager;

    public JarPf4bootPluginLoader(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public boolean isApplicable(Path pluginPath) {
        return Files.exists(pluginPath, new LinkOption[0]) && FileUtils.isJarFile((Path)pluginPath);
    }

    public ClassLoader loadPlugin(Path pluginPath, PluginDescriptor pluginDescriptor) {
        Pf4bootPluginClassLoader pluginClassLoader = new Pf4bootPluginClassLoader(this.pluginManager, pluginDescriptor);
        pluginClassLoader.addFile(pluginPath.toFile());
        JarFile.registerUrlProtocolHandler();
        try {
            JarFileArchive archive = new JarFileArchive(pluginPath.toFile());
            Iterator<Archive> archives = archive.getNestedArchives(s -> s.getName().startsWith("lib/"), n -> n.getName().endsWith(".jar"));
            while (archives.hasNext()) {
                pluginClassLoader.addURL(archives.next().getUrl());
            }
        }
        catch (IOException e) {
            throw new PluginRuntimeException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new PluginRuntimeException((Throwable)e);
        }
        return pluginClassLoader;
    }
}

