/*
 * Decompiled with CFR 0.152.
 */
package net.xdob.pf4boot.internal;

import java.util.Map;
import net.xdob.pf4boot.Pf4bootPlugin;
import net.xdob.pf4boot.Pf4bootPluginManager;
import net.xdob.pf4boot.PluginApplication;
import net.xdob.pf4boot.TypeWrapper;
import net.xdob.pf4boot.annotation.EventListener;
import net.xdob.pf4boot.spring.boot.Pf4bootMainAppStartedEvent;
import org.pf4j.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class MainAppStartedListener
implements ApplicationListener<ApplicationStartedEvent> {
    static final Logger log = LoggerFactory.getLogger(MainAppStartedListener.class);
    @Autowired
    private Pf4bootPluginManager pluginManager;
    @Autowired
    private ApplicationContext applicationContext;

    public void onApplicationEvent(ApplicationStartedEvent event) {
        Pf4bootPlugin plugin = this.getPlugin(event.getSource());
        if (plugin == null) {
            Map beans = event.getApplicationContext().getBeansWithAnnotation(EventListener.class);
            for (Object listener : beans.values()) {
                this.pluginManager.getPf4bootEventBus().register(listener);
            }
            if (!this.pluginManager.isMainApplicationStarted()) {
                if (this.pluginManager.isAutoStartPlugin()) {
                    this.pluginManager.startPlugins();
                }
                this.pluginManager.getPlugins(PluginState.STARTED).forEach(pluginWrapper -> TypeWrapper.wrapper((Object)pluginWrapper.getPlugin(), Pf4bootPlugin.class).ifPresent(pf4bootPlugin -> {
                    ConfigurableApplicationContext pluginAppCtx = pf4bootPlugin.getApplicationContext();
                    pluginAppCtx.publishEvent((ApplicationEvent)new Pf4bootMainAppStartedEvent(this.applicationContext));
                }));
                this.pluginManager.setMainApplicationStarted(true);
            }
        }
    }

    private Pf4bootPlugin getPlugin(Object source) {
        if (source instanceof PluginApplication) {
            return ((PluginApplication)source).getPlugin();
        }
        return null;
    }
}

