/*
 * Decompiled with CFR 0.152.
 */
package net.xdob.pf4boot;

import java.io.FileFilter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.pf4j.BasePluginRepository;
import org.pf4j.DefaultPluginRepository;
import org.pf4j.util.AndFileFilter;
import org.pf4j.util.DirectoryFileFilter;
import org.pf4j.util.FileUtils;
import org.pf4j.util.HiddenFilter;
import org.pf4j.util.NameFileFilter;
import org.pf4j.util.NotFileFilter;
import org.pf4j.util.OrFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pf4bootPluginRepository
extends BasePluginRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginRepository.class);

    public Pf4bootPluginRepository(Path ... pluginsRoots) {
        this(Arrays.asList(pluginsRoots));
    }

    public Pf4bootPluginRepository(List<Path> pluginsRoots) {
        super(pluginsRoots);
        AndFileFilter pluginsFilter = new AndFileFilter(new FileFilter[]{new DirectoryFileFilter()});
        pluginsFilter.addFileFilter((FileFilter)new NotFileFilter(this.createHiddenPluginFilter()));
        this.setFilter((FileFilter)pluginsFilter);
    }

    public List<Path> getPluginPaths() {
        return super.getPluginPaths();
    }

    public boolean deletePluginPath(Path pluginPath) {
        FileUtils.optimisticDelete((Path)FileUtils.findWithEnding((Path)pluginPath, (String[])new String[]{".zip", ".ZIP", ".Zip"}));
        return super.deletePluginPath(pluginPath);
    }

    protected FileFilter createHiddenPluginFilter() {
        return new OrFileFilter(new FileFilter[]{new HiddenFilter(), new NameFileFilter("cache")});
    }
}

