/*
 * Decompiled with CFR 0.152.
 */
package net.xdob.pf4boot;

import com.google.common.base.Strings;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.xdob.pf4boot.ApplicationContextProvider;
import net.xdob.pf4boot.LinkPluginRepository;
import net.xdob.pf4boot.ManifestPluginDescriptorFinder2;
import net.xdob.pf4boot.Pf4bootEventBus;
import net.xdob.pf4boot.Pf4bootPlugin;
import net.xdob.pf4boot.Pf4bootPluginManager;
import net.xdob.pf4boot.Pf4bootPluginRepository;
import net.xdob.pf4boot.Pf4bootPluginSupport;
import net.xdob.pf4boot.ZipPluginRepository;
import net.xdob.pf4boot.internal.Pf4bootPluginFactory;
import net.xdob.pf4boot.internal.Pf4bootPluginStateListener;
import net.xdob.pf4boot.internal.SpringExtensionFactory;
import net.xdob.pf4boot.loader.JarPf4bootPluginLoader;
import net.xdob.pf4boot.loader.Pf4bootPluginLoader;
import net.xdob.pf4boot.loader.ZipPf4bootPluginLoader;
import net.xdob.pf4boot.modal.PluginStartingError;
import net.xdob.pf4boot.spring.boot.Pf4bootApplication;
import net.xdob.pf4boot.spring.boot.Pf4bootPluginRestartedEvent;
import net.xdob.pf4boot.spring.boot.Pf4bootPluginStartedEvent;
import net.xdob.pf4boot.spring.boot.Pf4bootPluginStateChangedEvent;
import net.xdob.pf4boot.spring.boot.Pf4bootPluginStoppedEvent;
import net.xdob.pf4boot.spring.boot.Pf4bootProperties;
import net.xdob.pf4boot.spring.boot.PreStartPluginEvent;
import net.xdob.pf4boot.spring.boot.PreStopPluginEvent;
import net.xdob.pf4boot.spring.boot.StartedPluginEvent;
import net.xdob.pf4boot.spring.boot.StartingPluginEvent;
import net.xdob.pf4boot.spring.boot.StoppedPluginEvent;
import net.xdob.pf4boot.spring.boot.StoppingPluginEvent;
import org.pf4j.AbstractPluginManager;
import org.pf4j.CompoundPluginDescriptorFinder;
import org.pf4j.CompoundPluginLoader;
import org.pf4j.CompoundPluginRepository;
import org.pf4j.DefaultExtensionFinder;
import org.pf4j.DefaultPluginStatusProvider;
import org.pf4j.DefaultVersionManager;
import org.pf4j.DevelopmentPluginRepository;
import org.pf4j.ExtensionFactory;
import org.pf4j.ExtensionFinder;
import org.pf4j.JarPluginRepository;
import org.pf4j.Plugin;
import org.pf4j.PluginAlreadyLoadedException;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginFactory;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.PluginRepository;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PluginState;
import org.pf4j.PluginStateEvent;
import org.pf4j.PluginStateListener;
import org.pf4j.PluginStatusProvider;
import org.pf4j.PluginWrapper;
import org.pf4j.PropertiesPluginDescriptorFinder;
import org.pf4j.VersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.boot.Banner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;

public class Pf4bootPluginManagerImpl
extends AbstractPluginManager
implements Pf4bootPluginManager,
ApplicationContextAware {
    static final Logger log = LoggerFactory.getLogger(Pf4bootPluginManagerImpl.class);
    private volatile boolean mainApplicationStarted;
    private ConfigurableApplicationContext mainApplicationContext;
    public Map<String, Object> presetProperties = new HashMap<String, Object>();
    private boolean autoStartPlugin = true;
    private String[] profiles;
    private PluginRepository pluginRepository;
    private final Map<String, PluginStartingError> startingErrors = new HashMap<String, PluginStartingError>();
    private Pf4bootProperties properties;
    private final Pf4bootEventBus eventBus;
    public static final String PLUGINS_DIR_CONFIG_PROPERTY_NAME = "pf4j.pluginsConfigDir";
    private final List<Pf4bootPluginSupport> pluginSupports = new ArrayList<Pf4bootPluginSupport>();

    public Pf4bootPluginManagerImpl(Pf4bootProperties properties, Pf4bootEventBus eventBus, List<Pf4bootPluginSupport> pluginSupports, Path ... pluginsRoots) {
        super(pluginsRoots);
        this.properties = properties;
        this.eventBus = eventBus;
        this.doInitialize();
        this.pluginSupports.addAll(pluginSupports);
    }

    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        return new CompoundPluginDescriptorFinder().add((PluginDescriptorFinder)new PropertiesPluginDescriptorFinder()).add((PluginDescriptorFinder)new ManifestPluginDescriptorFinder2());
    }

    protected ExtensionFinder createExtensionFinder() {
        DefaultExtensionFinder extensionFinder = new DefaultExtensionFinder((PluginManager)this);
        this.addPluginStateListener((PluginStateListener)extensionFinder);
        return extensionFinder;
    }

    protected PluginFactory createPluginFactory() {
        return new Pf4bootPluginFactory();
    }

    protected ExtensionFactory createExtensionFactory() {
        return new SpringExtensionFactory(this);
    }

    protected PluginStatusProvider createPluginStatusProvider() {
        String configDir = System.getProperty(PLUGINS_DIR_CONFIG_PROPERTY_NAME);
        Path configPath = configDir != null ? Paths.get(configDir, new String[0]) : this.getPluginsRoot();
        return new DefaultPluginStatusProvider(configPath);
    }

    protected PluginRepository createPluginRepository() {
        this.pluginRepository = new CompoundPluginRepository().add((PluginRepository)new LinkPluginRepository(this.getPluginsRoots())).add((PluginRepository)new Pf4bootPluginRepository(this.getPluginsRoots())).add((PluginRepository)new ZipPluginRepository(this.getPluginsRoots())).add((PluginRepository)new DevelopmentPluginRepository(this.getPluginsRoots()), () -> ((Pf4bootPluginManagerImpl)this).isDevelopment()).add((PluginRepository)new JarPluginRepository(this.getPluginsRoots()), () -> ((Pf4bootPluginManagerImpl)this).isNotDevelopment());
        return this.pluginRepository;
    }

    protected PluginLoader createPluginLoader() {
        if (this.properties.getCustomPluginLoader() != null) {
            Class clazz = this.properties.getCustomPluginLoader();
            try {
                Constructor constructor = clazz.getConstructor(PluginManager.class);
                return (PluginLoader)constructor.newInstance(new Object[]{this});
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(String.format("Create custom PluginLoader %s failed. Make surethere is a constructor with one argument that accepts PluginLoader", clazz.getName()));
            }
        }
        return new CompoundPluginLoader().add((PluginLoader)new JarPf4bootPluginLoader((PluginManager)this), () -> ((Pf4bootPluginManagerImpl)this).isNotDevelopment()).add((PluginLoader)new ZipPf4bootPluginLoader((PluginManager)this)).add((PluginLoader)new Pf4bootPluginLoader(this, this.properties), () -> ((Pf4bootPluginManagerImpl)this).isDevelopment());
    }

    protected VersionManager createVersionManager() {
        return new DefaultVersionManager();
    }

    protected void initialize() {
    }

    protected void doInitialize() {
        super.initialize();
        this.addPluginStateListener(new Pf4bootPluginStateListener(this.eventBus));
        log.info("PF4J version {} in '{}' mode", (Object)this.getVersion(), (Object)this.getRuntimeMode());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mainApplicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public PluginDescriptorFinder getPluginDescriptorFinder() {
        return super.getPluginDescriptorFinder();
    }

    public void loadPlugins() {
        super.loadPlugins();
    }

    protected PluginWrapper loadPluginFromPath(Path pluginPath) {
        String pluginId = this.idForPath(pluginPath);
        if (pluginId != null) {
            throw new PluginAlreadyLoadedException(pluginId, pluginPath);
        }
        PluginDescriptorFinder pluginDescriptorFinder = this.getPluginDescriptorFinder();
        log.debug("Use '{}' to find plugins descriptors", (Object)pluginDescriptorFinder);
        log.debug("Finding plugin descriptor for plugin '{}'", (Object)pluginPath);
        PluginDescriptor pluginDescriptor = pluginDescriptorFinder.find(pluginPath);
        this.validatePluginDescriptor(pluginDescriptor);
        pluginId = pluginDescriptor.getPluginId();
        if (this.plugins.containsKey(pluginId)) {
            PluginWrapper loadedPlugin = this.getPlugin(pluginId);
            log.warn("duplicate plugin found : {}, {} and {}", new Object[]{pluginId, loadedPlugin.getDescriptor().getVersion(), pluginDescriptor.getVersion()});
            if (this.versionManager.compareVersions(loadedPlugin.getDescriptor().getVersion(), pluginDescriptor.getVersion()) < 0) {
                this.unloadPlugin(pluginId);
            } else {
                return loadedPlugin;
            }
        }
        log.debug("Found descriptor {}", (Object)pluginDescriptor);
        String pluginClassName = pluginDescriptor.getPluginClass();
        log.debug("Class '{}' for plugin '{}'", (Object)pluginClassName, (Object)pluginPath);
        log.debug("Loading plugin '{}'", (Object)pluginPath);
        ClassLoader pluginClassLoader = null;
        try {
            pluginClassLoader = this.getPluginLoader().loadPlugin(pluginPath, pluginDescriptor);
        }
        catch (Exception e) {
            throw new PluginRuntimeException((Throwable)e);
        }
        log.debug("Loaded plugin '{}' with class loader '{}'", (Object)pluginPath, (Object)pluginClassLoader);
        log.debug("Creating wrapper for plugin '{}'", (Object)pluginPath);
        PluginWrapper pluginWrapper = new PluginWrapper((PluginManager)this, pluginDescriptor, pluginPath, pluginClassLoader);
        pluginWrapper.setPluginFactory(this.getPluginFactory());
        if (this.isPluginDisabled(pluginDescriptor.getPluginId())) {
            log.info("Plugin '{}' is disabled", (Object)pluginPath);
            pluginWrapper.setPluginState(PluginState.DISABLED);
        }
        if (!this.isPluginValid(pluginWrapper)) {
            log.warn("Plugin '{}' is invalid and it will be disabled", (Object)pluginPath);
            pluginWrapper.setPluginState(PluginState.DISABLED);
        }
        log.debug("Created wrapper '{}' for plugin '{}'", (Object)pluginWrapper, (Object)pluginPath);
        pluginId = pluginDescriptor.getPluginId();
        this.plugins.put(pluginId, pluginWrapper);
        this.getUnresolvedPlugins().add(pluginWrapper);
        this.getPluginClassLoaders().put(pluginId, pluginClassLoader);
        return pluginWrapper;
    }

    public PluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    public void setAutoStartPlugin(boolean autoStartPlugin) {
        this.autoStartPlugin = autoStartPlugin;
    }

    public boolean isAutoStartPlugin() {
        return this.autoStartPlugin;
    }

    public void setMainApplicationStarted(boolean mainApplicationStarted) {
        this.mainApplicationStarted = mainApplicationStarted;
    }

    public void setProfiles(String[] profiles) {
        this.profiles = profiles;
    }

    public String[] getProfiles() {
        return this.profiles;
    }

    public void presetProperties(Map<String, Object> presetProperties) {
        this.presetProperties.putAll(presetProperties);
    }

    public void presetProperties(String name, Object value) {
        this.presetProperties.put(name, value);
    }

    public Map<String, Object> getPresetProperties() {
        return this.presetProperties;
    }

    public ConfigurableApplicationContext getMainApplicationContext() {
        return this.mainApplicationContext;
    }

    public boolean isMainApplicationStarted() {
        return this.mainApplicationStarted;
    }

    @PostConstruct
    public void init() {
        this.loadPlugins();
    }

    public PluginStartingError getPluginStartingError(String pluginId) {
        return this.startingErrors.get(pluginId);
    }

    public Pf4bootEventBus getPf4bootEventBus() {
        return this.eventBus;
    }

    public void post(Object event) {
        this.eventBus.post(event);
    }

    private void doStartPlugins() {
        this.startingErrors.clear();
        long ts = System.currentTimeMillis();
        List<Pf4bootPluginSupport> pluginSupportList = this.pluginSupports.stream().sorted(Comparator.comparingInt(e -> e.getPriority())).collect(Collectors.toList());
        for (PluginWrapper pluginWrapper : this.resolvedPlugins) {
            PluginState pluginState = pluginWrapper.getPluginState();
            if (PluginState.DISABLED == pluginState || PluginState.STARTED == pluginState) continue;
            try {
                this.doStartPlugin(pluginSupportList, pluginWrapper);
                pluginWrapper.setPluginState(PluginState.STARTED);
                this.startedPlugins.add(pluginWrapper);
                this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                this.startingErrors.put(pluginWrapper.getPluginId(), PluginStartingError.of((String)pluginWrapper.getPluginId(), (String)e2.getMessage(), (String)e2.toString()));
            }
        }
        log.info("[PF4BOOT] {} plugins are started in {}ms. {} failed", new Object[]{this.getPlugins().size(), System.currentTimeMillis() - ts, this.startingErrors.size()});
    }

    private void doStartPlugin(List<Pf4bootPluginSupport> pluginSupportList, PluginWrapper pluginWrapper) {
        Plugin plugin = pluginWrapper.getPlugin();
        long startTs = System.currentTimeMillis();
        log.debug("Starting plugin {} ......", (Object)pluginWrapper.getPluginId());
        if (plugin instanceof Pf4bootPlugin) {
            Pf4bootPlugin pf4bootPlugin = (Pf4bootPlugin)plugin;
            Pf4bootApplication application = pf4bootPlugin.application;
            application.setBannerMode(Banner.Mode.OFF);
            ConfigurableApplicationContext applicationContext = application.run(new String[0]);
            pf4bootPlugin.setApplicationContext(applicationContext);
            ApplicationContextProvider.registerApplicationContext((ApplicationContext)applicationContext);
            this.post(new PreStartPluginEvent(pf4bootPlugin));
            for (Pf4bootPluginSupport pluginSupport : pluginSupportList) {
                pluginSupport.startPlugin(pf4bootPlugin);
            }
            applicationContext.publishEvent((ApplicationEvent)new Pf4bootPluginStartedEvent((ApplicationContext)applicationContext));
            if (this.isMainApplicationStarted()) {
                applicationContext.publishEvent((ApplicationEvent)new Pf4bootPluginRestartedEvent((ApplicationContext)applicationContext));
            }
            this.post(new StartingPluginEvent(pf4bootPlugin));
            plugin.start();
            this.post(new StartedPluginEvent(pf4bootPlugin));
            for (Pf4bootPluginSupport pluginSupport : pluginSupportList) {
                pluginSupport.startedPlugin(pf4bootPlugin);
            }
        } else {
            plugin.start();
        }
        log.debug("Plugin {} is started in {}ms", (Object)pluginWrapper.getPluginId(), (Object)(System.currentTimeMillis() - startTs));
    }

    public void registerBeanToMainContext(String beanName, Object bean) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        beanName = Strings.isNullOrEmpty((String)beanName) ? bean.getClass().getName() : beanName;
        ConfigurableApplicationContext context = this.getMainApplicationContext();
        this.getMainApplicationContext().getBeanFactory().registerSingleton(beanName, bean);
    }

    private void doStopPlugins() {
        this.startingErrors.clear();
        List<Pf4bootPluginSupport> pluginSupportList = this.pluginSupports.stream().sorted(Comparator.comparingInt(Pf4bootPluginSupport::getPriority).reversed()).collect(Collectors.toList());
        Collections.reverse(this.startedPlugins);
        Iterator itr = this.startedPlugins.iterator();
        while (itr.hasNext()) {
            PluginWrapper pluginWrapper = (PluginWrapper)itr.next();
            PluginState pluginState = pluginWrapper.getPluginState();
            if (PluginState.STARTED != pluginState) continue;
            try {
                log.info("Stop plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()));
                this.doStopPlugin(pluginSupportList, pluginWrapper);
                pluginWrapper.setPluginState(PluginState.STOPPED);
                itr.remove();
                this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
            }
            catch (PluginRuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.startingErrors.put(pluginWrapper.getPluginId(), PluginStartingError.of((String)pluginWrapper.getPluginId(), (String)e.getMessage(), (String)e.toString()));
            }
        }
    }

    private void doStopPlugin(List<Pf4bootPluginSupport> pluginSupportList, PluginWrapper pluginWrapper) {
        Plugin plugin = pluginWrapper.getPlugin();
        if (pluginWrapper.getPluginState() != PluginState.STARTED) {
            return;
        }
        log.debug("Stopping plugin {} ......", (Object)pluginWrapper.getPluginId());
        if (plugin instanceof Pf4bootPlugin) {
            Pf4bootPlugin pf4bootPlugin = (Pf4bootPlugin)plugin;
            this.post(new PreStopPluginEvent(pf4bootPlugin));
            for (Pf4bootPluginSupport pluginSupport : pluginSupportList) {
                pluginSupport.stopPlugin(pf4bootPlugin);
            }
            pf4bootPlugin.stop();
            this.post(new StoppingPluginEvent(pf4bootPlugin));
            this.releaseResource(pf4bootPlugin);
            ConfigurableApplicationContext applicationContext = pf4bootPlugin.getApplicationContext();
            applicationContext.publishEvent((ApplicationEvent)new Pf4bootPluginStoppedEvent((ApplicationContext)applicationContext));
            for (Pf4bootPluginSupport pluginSupport : pluginSupportList) {
                pluginSupport.stoppedPlugin(pf4bootPlugin);
            }
            this.post(new StoppedPluginEvent(pf4bootPlugin));
            ApplicationContextProvider.unregisterApplicationContext((ApplicationContext)applicationContext);
            applicationContext.close();
        } else {
            plugin.stop();
        }
        log.debug("Plugin {} is stopped", (Object)pluginWrapper.getPluginId());
    }

    public void releaseResource(Pf4bootPlugin pf4bootPlugin) {
    }

    public void unregisterBeanFromMainContext(String beanName) {
        Assert.notNull((Object)beanName, (String)"bean must not be null");
        ((AbstractAutowireCapableBeanFactory)this.getMainApplicationContext().getBeanFactory()).destroySingleton(beanName);
    }

    private PluginState doStartPlugin(String pluginId, boolean sendEvent) {
        PluginWrapper plugin = this.getPlugin(pluginId);
        try {
            PluginState pluginState = super.startPlugin(pluginId);
            if (sendEvent) {
                this.mainApplicationContext.publishEvent((ApplicationEvent)new Pf4bootPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
            }
            return pluginState;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.startingErrors.put(plugin.getPluginId(), PluginStartingError.of((String)plugin.getPluginId(), (String)e.getMessage(), (String)e.toString()));
            return plugin.getPluginState();
        }
    }

    private PluginState doStopPlugin(String pluginId, boolean sendEvent) {
        PluginWrapper plugin = this.getPlugin(pluginId);
        try {
            PluginState pluginState = super.stopPlugin(pluginId);
            if (sendEvent) {
                this.mainApplicationContext.publishEvent((ApplicationEvent)new Pf4bootPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
            }
            return pluginState;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.startingErrors.put(plugin.getPluginId(), PluginStartingError.of((String)plugin.getPluginId(), (String)e.getMessage(), (String)e.toString()));
            return plugin.getPluginState();
        }
    }

    public void startPlugins() {
        this.doStartPlugins();
        this.mainApplicationContext.publishEvent((ApplicationEvent)new Pf4bootPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
    }

    public PluginState startPlugin(String pluginId) {
        return this.doStartPlugin(pluginId, true);
    }

    public void stopPlugins() {
        this.doStopPlugins();
        this.mainApplicationContext.publishEvent((ApplicationEvent)new Pf4bootPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
    }

    public PluginState stopPlugin(String pluginId) {
        return this.doStopPlugin(pluginId, true);
    }

    public void restartPlugins() {
        this.doStopPlugins();
        this.startPlugins();
    }

    public PluginState restartPlugin(String pluginId) {
        PluginState pluginState = this.doStopPlugin(pluginId, false);
        if (pluginState != PluginState.STARTED) {
            this.doStartPlugin(pluginId, false);
        }
        this.doStartPlugin(pluginId, false);
        this.mainApplicationContext.publishEvent((ApplicationEvent)new Pf4bootPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
        return pluginState;
    }

    public void reloadPlugins(boolean restartStartedOnly) {
        this.doStopPlugins();
        ArrayList startedPluginIds = new ArrayList();
        this.getPlugins().forEach(plugin -> {
            if (plugin.getPluginState() == PluginState.STARTED) {
                startedPluginIds.add(plugin.getPluginId());
            }
            this.unloadPlugin(plugin.getPluginId());
        });
        this.loadPlugins();
        if (restartStartedOnly) {
            startedPluginIds.forEach(pluginId -> {
                if (this.getPlugin((String)pluginId) != null) {
                    this.doStartPlugin((String)pluginId, false);
                }
            });
            this.mainApplicationContext.publishEvent((ApplicationEvent)new Pf4bootPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
        } else {
            this.startPlugins();
        }
    }

    public PluginState reloadPlugins(String pluginId) {
        PluginWrapper plugin = this.getPlugin(pluginId);
        this.doStopPlugin(pluginId, false);
        this.unloadPlugin(pluginId);
        try {
            this.loadPlugin(plugin.getPluginPath());
        }
        catch (Exception ex) {
            return null;
        }
        return this.doStartPlugin(pluginId, true);
    }
}

