/*
 * Decompiled with CFR 0.152.
 */
package net.xdob.pf4boot;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.pf4j.BasePluginRepository;
import org.pf4j.util.AndFileFilter;
import org.pf4j.util.DirectoryFileFilter;
import org.pf4j.util.NameFileFilter;
import org.pf4j.util.NotFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkPluginRepository
extends BasePluginRepository {
    static final Logger log = LoggerFactory.getLogger(LinkPluginRepository.class);

    public LinkPluginRepository(Path ... pluginsRoots) {
        this(Arrays.asList(pluginsRoots));
    }

    public LinkPluginRepository(List<Path> pluginsRoots) {
        super(pluginsRoots);
        AndFileFilter pluginsFilter = new AndFileFilter(new FileFilter[]{new NameFileFilter("plugins.link")});
        pluginsFilter.addFileFilter((FileFilter)new NotFileFilter((FileFilter)new DirectoryFileFilter()));
        this.setFilter((FileFilter)pluginsFilter);
    }

    public List<Path> getPluginPaths() {
        List list = super.getPluginPaths();
        HashSet<Path> paths = new HashSet<Path>();
        if (list != null) {
            for (Path path : list) {
                List<File> links = this.readLinks(path.toFile());
                if (this.comparator != null) {
                    links.sort(this.comparator);
                }
                for (File file : links) {
                    Path pluginPath = file.toPath();
                    paths.add(pluginPath);
                }
            }
        }
        return paths.stream().collect(Collectors.toList());
    }

    private List<File> readLinks(File linksFile) {
        ArrayList<File> links = new ArrayList<File>();
        try {
            List<String> lines = Files.readAllLines(linksFile.toPath());
            for (String line : lines) {
                File file;
                if (line == null || line.startsWith("#") || !(file = new File(line)).exists()) continue;
                links.add(file);
            }
        }
        catch (IOException e) {
            log.warn(null, (Throwable)e);
        }
        return links;
    }

    public boolean deletePluginPath(Path pluginPath) {
        List list = super.getPluginPaths();
        if (list == null || list.size() != 1) {
            return false;
        }
        this.removeFromLinks(((Path)list.get(0)).toFile(), pluginPath);
        return true;
    }

    private void removeFromLinks(File linksFile, Path pluginPath) {
        try {
            List<String> lines = Files.readAllLines(linksFile.toPath());
            Iterator<String> iterator = lines.iterator();
            while (iterator.hasNext()) {
                File file;
                String line = iterator.next();
                if (line == null || line.startsWith("#") || !(file = new File(line)).toPath().equals(pluginPath)) continue;
                iterator.remove();
            }
        }
        catch (IOException e) {
            log.warn(null, (Throwable)e);
        }
    }
}

