/*
 * Decompiled with CFR 0.152.
 */
package net.xdob.pf4boot;

import java.util.Map;
import java.util.Set;
import net.xdob.pf4boot.Pf4bootPlugin;
import net.xdob.pf4boot.Pf4bootPluginManager;
import net.xdob.pf4boot.Pf4bootPluginSupport;
import net.xdob.pf4boot.annotation.EventListener;
import net.xdob.pf4boot.annotation.Export;
import net.xdob.pf4boot.internal.SpringExtensionFactory;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class DefaultPf4bootPluginSupport
implements Pf4bootPluginSupport {
    static final Logger log = LoggerFactory.getLogger(DefaultPf4bootPluginSupport.class);

    public int getPriority() {
        return 10;
    }

    public void startPlugin(Pf4bootPlugin pf4bootPlugin) {
        this.registerEventListeners(pf4bootPlugin);
        this.registerShareServices(pf4bootPlugin);
        this.registerExtensions(pf4bootPlugin);
    }

    private void registerEventListeners(Pf4bootPlugin pf4bootPlugin) {
        Pf4bootPluginManager pluginManager = pf4bootPlugin.getPluginManager();
        Map beans = pf4bootPlugin.getApplicationContext().getBeansWithAnnotation(EventListener.class);
        for (String beanName : beans.keySet()) {
            Object bean = beans.get(beanName);
            pluginManager.getPf4bootEventBus().register(bean);
        }
    }

    private void registerExtensions(Pf4bootPlugin pf4bootPlugin) {
        PluginWrapper wrapper = pf4bootPlugin.getWrapper();
        Pf4bootPluginManager pluginManager = pf4bootPlugin.getPluginManager();
        Set extensionClassNames = pluginManager.getExtensionClassNames(wrapper.getPluginId());
        for (String extensionClassName : extensionClassNames) {
            try {
                log.debug("Register extension <{}> to main ApplicationContext", (Object)extensionClassName);
                Class<?> extensionClass = wrapper.getPluginClassLoader().loadClass(extensionClassName);
                SpringExtensionFactory extensionFactory = (SpringExtensionFactory)wrapper.getPluginManager().getExtensionFactory();
                Object bean = extensionFactory.create(extensionClass);
                String beanName = extensionFactory.getExtensionBeanName(extensionClass);
                pluginManager.registerBeanToMainContext(beanName, bean);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }

    private void registerShareServices(Pf4bootPlugin pf4bootPlugin) {
        Pf4bootPluginManager pluginManager = pf4bootPlugin.getPluginManager();
        ConfigurableApplicationContext applicationContext = pf4bootPlugin.getApplicationContext();
        Map beans = applicationContext.getBeansWithAnnotation(Export.class);
        for (String beanName : beans.keySet()) {
            Object bean = beans.get(beanName);
            pluginManager.registerBeanToMainContext(beanName, bean);
        }
    }

    public void stoppedPlugin(Pf4bootPlugin pf4bootPlugin) {
        this.unregisterExtensions(pf4bootPlugin);
        this.unregisterShareServices(pf4bootPlugin);
        this.unregisterEventListeners(pf4bootPlugin);
    }

    private void unregisterExtensions(Pf4bootPlugin pf4bootPlugin) {
        Pf4bootPluginManager pluginManager = pf4bootPlugin.getPluginManager();
        PluginWrapper wrapper = pf4bootPlugin.getWrapper();
        Set extensionClassNames = pluginManager.getExtensionClassNames(wrapper.getPluginId());
        for (String extensionClassName : extensionClassNames) {
            try {
                log.debug("Register extension <{}> to main ApplicationContext", (Object)extensionClassName);
                Class<?> extensionClass = wrapper.getPluginClassLoader().loadClass(extensionClassName);
                SpringExtensionFactory extensionFactory = (SpringExtensionFactory)wrapper.getPluginManager().getExtensionFactory();
                String beanName = extensionFactory.getExtensionBeanName(extensionClass);
                pluginManager.unregisterBeanFromMainContext(beanName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }

    private void unregisterShareServices(Pf4bootPlugin pf4bootPlugin) {
        Pf4bootPluginManager pluginManager = pf4bootPlugin.getPluginManager();
        ConfigurableApplicationContext applicationContext = pf4bootPlugin.getApplicationContext();
        Map beans = applicationContext.getBeansWithAnnotation(Export.class);
        for (String beanName : beans.keySet()) {
            pluginManager.unregisterBeanFromMainContext(beanName);
        }
    }

    private void unregisterEventListeners(Pf4bootPlugin pf4bootPlugin) {
        Pf4bootPluginManager pluginManager = pf4bootPlugin.getPluginManager();
        ConfigurableApplicationContext applicationContext = pf4bootPlugin.getApplicationContext();
        Map beans = applicationContext.getBeansWithAnnotation(EventListener.class);
        for (String beanName : beans.keySet()) {
            Object bean = beans.get(beanName);
            pluginManager.getPf4bootEventBus().unregister(bean);
        }
    }
}

