/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.ServiceInfoImpl;

class ServiceTypeDecoder {
    private static final Pattern SUBTYPE_PATTERN = Pattern.compile("^((.*)\\._)?_?(.*)\\._sub\\._([^.]*)\\._([^.]*)\\.(.*)\\.?$");
    private static final Pattern PATTERN = Pattern.compile("^((.*)?\\._)?([^.]*)\\._([^.]*)\\.(.*)\\.?$");

    private ServiceTypeDecoder() {
    }

    static Map<ServiceInfo.Fields, String> decodeQualifiedNameMap(String type, String name, String subtype) {
        Map<ServiceInfo.Fields, String> qualifiedNameMap = ServiceTypeDecoder.decodeQualifiedNameMapForType(type);
        qualifiedNameMap.put(ServiceInfo.Fields.Instance, name);
        qualifiedNameMap.put(ServiceInfo.Fields.Subtype, subtype);
        return ServiceInfoImpl.checkQualifiedNameMap(qualifiedNameMap);
    }

    static Map<ServiceInfo.Fields, String> decodeQualifiedNameMapForType(String type) {
        String aType;
        String casePreservedType = type;
        String application = aType = type.toLowerCase();
        String protocol = "";
        String subtype = "";
        String name = "";
        String domain = "";
        if (aType.contains("in-addr.arpa") || aType.contains("ip6.arpa")) {
            int index = aType.contains("in-addr.arpa") ? aType.indexOf("in-addr.arpa") : aType.indexOf("ip6.arpa");
            name = ServiceInfoImpl.removeSeparators(casePreservedType.substring(0, index));
            domain = casePreservedType.substring(index);
            application = "";
        } else if (!aType.contains("_") && aType.contains(".")) {
            int index = aType.indexOf(46);
            name = ServiceInfoImpl.removeSeparators(casePreservedType.substring(0, index));
            domain = ServiceInfoImpl.removeSeparators(casePreservedType.substring(index));
            application = "";
        } else {
            Matcher subType = SUBTYPE_PATTERN.matcher(aType);
            if (subType.matches()) {
                name = ServiceTypeDecoder.originalCase(casePreservedType, subType, 2);
                subtype = ServiceTypeDecoder.originalCase(casePreservedType, subType, 3);
                application = ServiceTypeDecoder.originalCase(casePreservedType, subType, 4);
                protocol = ServiceTypeDecoder.originalCase(casePreservedType, subType, 5);
                domain = ServiceTypeDecoder.originalCase(casePreservedType, subType, 6);
            } else {
                Matcher normalMatcher = PATTERN.matcher(aType);
                if (normalMatcher.matches()) {
                    name = ServiceTypeDecoder.originalCase(casePreservedType, normalMatcher, 2);
                    application = ServiceTypeDecoder.originalCase(casePreservedType, normalMatcher, 3);
                    protocol = ServiceTypeDecoder.originalCase(casePreservedType, normalMatcher, 4);
                    domain = ServiceTypeDecoder.originalCase(casePreservedType, normalMatcher, 5);
                }
            }
        }
        return ServiceInfoImpl.createQualifiedMap(name, ServiceInfoImpl.removeSeparators(application), protocol, ServiceInfoImpl.removeSeparators(domain), subtype);
    }

    private static String originalCase(String casePreservedType, Matcher matcher, int group) {
        if (matcher.start(group) != -1) {
            return casePreservedType.substring(matcher.start(group), matcher.end(group));
        }
        return "";
    }
}

