/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jmdns.InetAddressAddException;
import javax.jmdns.JmDNS;
import javax.jmdns.JmmDNS;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.NetworkTopologyEvent;
import javax.jmdns.NetworkTopologyListener;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.NetworkTopologyEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmmDNSImpl
implements JmmDNS,
NetworkTopologyListener,
ServiceInfoImpl.Delegate {
    private static Logger logger = LoggerFactory.getLogger((String)JmmDNSImpl.class.getName());
    private final Set<NetworkTopologyListener> _networkListeners = Collections.synchronizedSet(new HashSet());
    private final ConcurrentMap<InetAddress, JmDNS> _knownMDNS = new ConcurrentHashMap<InetAddress, JmDNS>();
    private final ConcurrentMap<String, ServiceInfo> _services = new ConcurrentHashMap<String, ServiceInfo>(20);
    private final Set<String> _serviceTypes;
    private final ConcurrentMap<String, List<ServiceListener>> _serviceListeners;
    private final Set<ServiceTypeListener> _typeListeners;
    private final ExecutorService _listenerExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory("JmmDNS Listeners"));
    private final ExecutorService _jmDNSExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("JmmDNS"));
    private final Timer _timer = new Timer("Multihomed mDNS.Timer", true);
    private final AtomicBoolean _isClosing;
    private final AtomicBoolean _closed;

    public JmmDNSImpl() {
        this._serviceListeners = new ConcurrentHashMap<String, List<ServiceListener>>();
        this._typeListeners = Collections.synchronizedSet(new HashSet());
        this._serviceTypes = Collections.synchronizedSet(new HashSet());
        new NetworkChecker(this, NetworkTopologyDiscovery.Factory.getInstance()).start(this._timer);
        this._isClosing = new AtomicBoolean(false);
        this._closed = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this._isClosing.compareAndSet(false, true)) {
            logger.debug("Cancelling JmmDNS: {}", (Object)this);
            this._timer.cancel();
            this._listenerExecutor.shutdown();
            this._jmDNSExecutor.shutdown();
            ExecutorService executor = Executors.newCachedThreadPool(new NamedThreadFactory("JmmDNS.close"));
            try {
                for (final JmDNS mDNS : this.getDNS()) {
                    executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                mDNS.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            finally {
                executor.shutdown();
            }
            try {
                executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException exception) {
                logger.warn("Exception ", (Throwable)exception);
            }
            this._knownMDNS.clear();
            this._services.clear();
            this._serviceListeners.clear();
            this._typeListeners.clear();
            this._serviceTypes.clear();
            this._closed.set(true);
            JmmDNS.Factory.close();
        }
    }

    @Override
    public String[] getNames() {
        HashSet<String> result = new HashSet<String>();
        for (JmDNS mDNS : this.getDNS()) {
            result.add(mDNS.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getHostNames() {
        HashSet<String> result = new HashSet<String>();
        for (JmDNS mDNS : this.getDNS()) {
            result.add(mDNS.getHostName());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public InetAddress[] getInetAddresses() throws IOException {
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        for (JmDNS mDNS : this.getDNS()) {
            result.add(mDNS.getInetAddress());
        }
        return result.toArray(new InetAddress[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JmDNS[] getDNS() {
        ConcurrentMap<InetAddress, JmDNS> concurrentMap = this._knownMDNS;
        synchronized (concurrentMap) {
            return this._knownMDNS.values().toArray(new JmDNS[this._knownMDNS.size()]);
        }
    }

    @Override
    @Deprecated
    public InetAddress[] getInterfaces() throws IOException {
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        for (JmDNS mDNS : this.getDNS()) {
            result.add(mDNS.getInterface());
        }
        return result.toArray(new InetAddress[result.size()]);
    }

    @Override
    public ServiceInfo[] getServiceInfos(String type, String name) {
        return this.getServiceInfos(type, name, false, 6000L);
    }

    @Override
    public ServiceInfo[] getServiceInfos(String type, String name, long timeout) {
        return this.getServiceInfos(type, name, false, timeout);
    }

    @Override
    public ServiceInfo[] getServiceInfos(String type, String name, boolean persistent) {
        return this.getServiceInfos(type, name, persistent, 6000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo[] getServiceInfos(final String type, final String name, final boolean persistent, final long timeout) {
        JmDNS[] dnsArray = this.getDNS();
        HashSet<ServiceInfo> result = new HashSet<ServiceInfo>(dnsArray.length);
        if (dnsArray.length > 0) {
            ArrayList<2> tasks = new ArrayList<2>(dnsArray.length);
            for (final JmDNS jmDNS : dnsArray) {
                tasks.add(new Callable<ServiceInfo>(){

                    @Override
                    public ServiceInfo call() throws Exception {
                        return jmDNS.getServiceInfo(type, name, persistent, timeout);
                    }
                });
            }
            ExecutorService executor = Executors.newFixedThreadPool(tasks.size(), new NamedThreadFactory("JmmDNS.getServiceInfos"));
            try {
                List<Object> results = Collections.emptyList();
                try {
                    results = executor.invokeAll(tasks, timeout + 100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException exception) {
                    logger.debug("Interrupted ", (Throwable)exception);
                    Thread.currentThread().interrupt();
                }
                for (Future future : results) {
                    if (future.isCancelled()) continue;
                    try {
                        ServiceInfo info = (ServiceInfo)future.get();
                        if (info == null) continue;
                        result.add(info);
                    }
                    catch (InterruptedException exception) {
                        logger.debug("Interrupted ", (Throwable)exception);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException exception) {
                        logger.warn("Exception ", (Throwable)exception);
                    }
                }
            }
            finally {
                executor.shutdown();
            }
        }
        return result.toArray(new ServiceInfo[result.size()]);
    }

    @Override
    public void requestServiceInfo(String type, String name) {
        this.requestServiceInfo(type, name, false, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, boolean persistent) {
        this.requestServiceInfo(type, name, persistent, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, long timeout) {
        this.requestServiceInfo(type, name, false, timeout);
    }

    @Override
    public void requestServiceInfo(final String type, final String name, final boolean persistent, final long timeout) {
        for (final JmDNS mDNS : this.getDNS()) {
            this._jmDNSExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    mDNS.requestServiceInfo(type, name, persistent, timeout);
                }
            });
        }
    }

    @Override
    public void addServiceTypeListener(ServiceTypeListener listener) throws IOException {
        this._typeListeners.add(listener);
        for (JmDNS mDNS : this.getDNS()) {
            mDNS.addServiceTypeListener(listener);
        }
    }

    @Override
    public void removeServiceTypeListener(ServiceTypeListener listener) {
        this._typeListeners.remove(listener);
        for (JmDNS mDNS : this.getDNS()) {
            mDNS.removeServiceTypeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addServiceListener(String type, ServiceListener listener) {
        JmDNS[] jmDNSArray;
        String loType = type.toLowerCase();
        Object list = (JmDNS[])this._serviceListeners.get(loType);
        if (list == null) {
            this._serviceListeners.putIfAbsent(loType, new LinkedList());
            list = (List)this._serviceListeners.get(loType);
        }
        if (list != null) {
            jmDNSArray = list;
            // MONITORENTER : list
            if (!list.contains(listener)) {
                list.add(listener);
            }
            // MONITOREXIT : jmDNSArray
        }
        jmDNSArray = this.getDNS();
        int n = jmDNSArray.length;
        int n2 = 0;
        while (n2 < n) {
            JmDNS mDNS = jmDNSArray[n2];
            mDNS.addServiceListener(type, listener);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void removeServiceListener(String type, ServiceListener listener) {
        JmDNS[] jmDNSArray;
        String loType = type.toLowerCase();
        JmDNS[] list = (JmDNS[])this._serviceListeners.get(loType);
        if (list != null) {
            jmDNSArray = list;
            // MONITORENTER : list
            list.remove(listener);
            if (list.isEmpty()) {
                this._serviceListeners.remove(loType, list);
            }
            // MONITOREXIT : jmDNSArray
        }
        jmDNSArray = this.getDNS();
        int n = jmDNSArray.length;
        int n2 = 0;
        while (n2 < n) {
            JmDNS mDNS = jmDNSArray[n2];
            mDNS.removeServiceListener(type, listener);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void textValueUpdated(ServiceInfo target, byte[] value) {
        JmDNS[] dnsArray = this.getDNS();
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS mDNS : dnsArray) {
                ServiceInfo info = ((JmDNSImpl)mDNS).getServices().get(target.getQualifiedName());
                if (info != null) {
                    info.setText(value);
                    continue;
                }
                logger.warn("We have a mDNS that does not know about the service info being updated.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerService(ServiceInfo info) throws IOException {
        JmDNS[] dnsArray = this.getDNS();
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS mDNS : dnsArray) {
                mDNS.registerService(info.clone());
            }
            ((ServiceInfoImpl)info).setDelegate(this);
            this._services.put(info.getQualifiedName(), info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(ServiceInfo info) {
        JmDNS[] dnsArray = this.getDNS();
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            this._services.remove(info.getQualifiedName());
            for (JmDNS mDNS : dnsArray) {
                mDNS.unregisterService(info);
            }
            ((ServiceInfoImpl)info).setDelegate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAllServices() {
        JmDNS[] dnsArray = this.getDNS();
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            this._services.clear();
            for (JmDNS mDNS : dnsArray) {
                mDNS.unregisterAllServices();
            }
        }
    }

    @Override
    public void registerServiceType(String type) {
        this._serviceTypes.add(type);
        for (JmDNS mDNS : this.getDNS()) {
            mDNS.registerServiceType(type);
        }
    }

    @Override
    public ServiceInfo[] list(String type) {
        return this.list(type, 6000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo[] list(final String type, final long timeout) {
        JmDNS[] dnsArray = this.getDNS();
        HashSet result = new HashSet(dnsArray.length * 5);
        if (dnsArray.length > 0) {
            ArrayList<4> tasks = new ArrayList<4>(dnsArray.length);
            for (final JmDNS jmDNS : dnsArray) {
                tasks.add(new Callable<List<ServiceInfo>>(){

                    @Override
                    public List<ServiceInfo> call() throws Exception {
                        return Arrays.asList(jmDNS.list(type, timeout));
                    }
                });
            }
            ExecutorService executor = Executors.newFixedThreadPool(tasks.size(), new NamedThreadFactory("JmmDNS.list"));
            try {
                List<Object> results = Collections.emptyList();
                try {
                    results = executor.invokeAll(tasks, timeout + 100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException exception) {
                    logger.debug("Interrupted ", (Throwable)exception);
                    Thread.currentThread().interrupt();
                }
                for (Future future : results) {
                    if (future.isCancelled()) continue;
                    try {
                        result.addAll((Collection)future.get());
                    }
                    catch (InterruptedException exception) {
                        logger.debug("Interrupted ", (Throwable)exception);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException exception) {
                        logger.warn("Exception ", (Throwable)exception);
                    }
                }
            }
            finally {
                executor.shutdown();
            }
        }
        return result.toArray(new ServiceInfo[result.size()]);
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String type) {
        return this.listBySubtype(type, 6000L);
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String type, long timeout) {
        HashMap map = new HashMap(5);
        for (ServiceInfo info : this.list(type, timeout)) {
            String subtype = info.getSubtype();
            if (!map.containsKey(subtype)) {
                map.put(subtype, new ArrayList(10));
            }
            ((List)map.get(subtype)).add(info);
        }
        HashMap<String, ServiceInfo[]> result = new HashMap<String, ServiceInfo[]>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            String subtype = (String)entry.getKey();
            List infoForSubType = (List)entry.getValue();
            result.put(subtype, infoForSubType.toArray(new ServiceInfo[infoForSubType.size()]));
        }
        return result;
    }

    @Override
    public void addNetworkTopologyListener(NetworkTopologyListener listener) {
        this._networkListeners.add(listener);
    }

    @Override
    public void removeNetworkTopologyListener(NetworkTopologyListener listener) {
        this._networkListeners.remove(listener);
    }

    @Override
    public NetworkTopologyListener[] networkListeners() {
        return this._networkListeners.toArray(new NetworkTopologyListener[this._networkListeners.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inetAddressAdded(NetworkTopologyEvent event) {
        block10: {
            InetAddress address = event.getInetAddress();
            try {
                if (this._knownMDNS.containsKey(address)) break block10;
                ConcurrentMap<InetAddress, JmDNS> concurrentMap = this._knownMDNS;
                synchronized (concurrentMap) {
                    if (!this._knownMDNS.containsKey(address)) {
                        final JmDNS dns = this.createJmDnsInstance(address);
                        if (this._knownMDNS.putIfAbsent(address, dns) == null) {
                            final Set<String> types = this._serviceTypes;
                            final Collection infos = this._services.values();
                            final Set<ServiceTypeListener> typeListeners = this._typeListeners;
                            final ConcurrentMap<String, List<ServiceListener>> serviceListeners = this._serviceListeners;
                            this._jmDNSExecutor.submit(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    for (String string : types) {
                                        dns.registerServiceType(string);
                                    }
                                    for (ServiceInfo serviceInfo : infos) {
                                        try {
                                            dns.registerService(serviceInfo.clone());
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    for (ServiceTypeListener serviceTypeListener : typeListeners) {
                                        try {
                                            dns.addServiceTypeListener(serviceTypeListener);
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    for (Map.Entry entry : serviceListeners.entrySet()) {
                                        List listeners;
                                        String type = (String)entry.getKey();
                                        List list = listeners = (List)entry.getValue();
                                        synchronized (list) {
                                            for (ServiceListener listener : listeners) {
                                                dns.addServiceListener(type, listener);
                                            }
                                        }
                                    }
                                }
                            });
                            final NetworkTopologyEventImpl jmdnsEvent = new NetworkTopologyEventImpl(dns, address);
                            for (final NetworkTopologyListener listener : this.networkListeners()) {
                                this._listenerExecutor.submit(new Runnable(){

                                    @Override
                                    public void run() {
                                        listener.inetAddressAdded(jmdnsEvent);
                                    }
                                });
                            }
                        } else {
                            dns.close();
                        }
                    }
                }
            }
            catch (SocketException e) {
                throw new InetAddressAddException(address, (Throwable)e);
            }
            catch (Exception e) {
                logger.warn("Unexpected unhandled exception, address: " + address, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inetAddressRemoved(NetworkTopologyEvent event) {
        block7: {
            InetAddress address = event.getInetAddress();
            try {
                if (!this._knownMDNS.containsKey(address)) break block7;
                ConcurrentMap<InetAddress, JmDNS> concurrentMap = this._knownMDNS;
                synchronized (concurrentMap) {
                    if (this._knownMDNS.containsKey(address)) {
                        JmDNS mDNS = (JmDNS)this._knownMDNS.remove(address);
                        mDNS.close();
                        final NetworkTopologyEventImpl jmdnsEvent = new NetworkTopologyEventImpl(mDNS, address);
                        for (final NetworkTopologyListener listener : this.networkListeners()) {
                            this._listenerExecutor.submit(new Runnable(){

                                @Override
                                public void run() {
                                    listener.inetAddressRemoved(jmdnsEvent);
                                }
                            });
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Unexpected unhandled exception, address: " + address, (Throwable)e);
            }
        }
    }

    protected JmDNS createJmDnsInstance(InetAddress address) throws IOException {
        return JmDNS.create(address);
    }

    static class NetworkChecker
    extends TimerTask {
        private static Logger logger1 = LoggerFactory.getLogger((String)NetworkChecker.class.getName());
        private final NetworkTopologyListener _mmDNS;
        private final NetworkTopologyDiscovery _topology;
        private Set<InetAddress> _knownAddresses;

        public NetworkChecker(NetworkTopologyListener mmDNS, NetworkTopologyDiscovery topology) {
            this._mmDNS = mmDNS;
            this._topology = topology;
            this._knownAddresses = Collections.synchronizedSet(new HashSet());
        }

        public void start(Timer timer) {
            this.run();
            timer.schedule((TimerTask)this, 10000L, 10000L);
        }

        @Override
        public void run() {
            try {
                InetAddress[] curentAddresses = this._topology.getInetAddresses();
                HashSet<InetAddress> current = new HashSet<InetAddress>(curentAddresses.length);
                for (InetAddress address : curentAddresses) {
                    if (!this._knownAddresses.contains(address)) {
                        NetworkTopologyEventImpl event = new NetworkTopologyEventImpl(this._mmDNS, address);
                        try {
                            this._mmDNS.inetAddressAdded(event);
                            current.add(address);
                            logger1.info("added address: " + address);
                        }
                        catch (InetAddressAddException e) {
                            logger1.warn(e.getMessage());
                        }
                        continue;
                    }
                    current.add(address);
                }
                for (InetAddress address : this._knownAddresses) {
                    if (current.contains(address)) continue;
                    NetworkTopologyEventImpl event = new NetworkTopologyEventImpl(this._mmDNS, address);
                    this._mmDNS.inetAddressRemoved(event);
                    logger1.info("removed address: " + address);
                }
                this._knownAddresses = current;
            }
            catch (Exception e) {
                logger1.warn("Unexpected unhandled exception: " + e.getMessage());
            }
        }
    }
}

