/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueStringBase;

public final class ValueVarcharIgnoreCase
extends ValueStringBase {
    private static final ValueVarcharIgnoreCase EMPTY = new ValueVarcharIgnoreCase("");
    private int hash;

    private ValueVarcharIgnoreCase(String value) {
        super(value);
    }

    @Override
    public int getValueType() {
        return 4;
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode, CastDataProvider provider) {
        return mode.compareString(this.value, ((ValueStringBase)v).value, true);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueVarcharIgnoreCase && this.value.equalsIgnoreCase(((ValueVarcharIgnoreCase)other).value);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.value.toUpperCase().hashCode();
        }
        return this.hash;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0) {
            return StringUtils.quoteStringSQL(builder.append("CAST("), this.value).append(" AS VARCHAR_IGNORECASE(").append(this.value.length()).append("))");
        }
        return StringUtils.quoteStringSQL(builder, this.value);
    }

    public static ValueVarcharIgnoreCase get(String s) {
        int length = s.length();
        if (length == 0) {
            return EMPTY;
        }
        ValueVarcharIgnoreCase obj = new ValueVarcharIgnoreCase(StringUtils.cache(s));
        if (length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        ValueVarcharIgnoreCase cache = (ValueVarcharIgnoreCase)Value.cache(obj);
        if (cache.value.equals(s)) {
            return cache;
        }
        return obj;
    }
}

