/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueTimestampTimeZone
extends Value {
    public static final int DEFAULT_PRECISION = 32;
    public static final int MAXIMUM_PRECISION = 35;
    private final long dateValue;
    private final long timeNanos;
    private final int timeZoneOffsetSeconds;

    private ValueTimestampTimeZone(long dateValue, long timeNanos, int timeZoneOffsetSeconds) {
        if (dateValue < -511999999967L || dateValue > 512000000415L) {
            throw new IllegalArgumentException("dateValue out of range " + dateValue);
        }
        if (timeNanos < 0L || timeNanos >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + timeNanos);
        }
        if (timeZoneOffsetSeconds < -64800 || timeZoneOffsetSeconds > 64800) {
            throw new IllegalArgumentException("timeZoneOffsetSeconds out of range " + timeZoneOffsetSeconds);
        }
        this.dateValue = dateValue;
        this.timeNanos = timeNanos;
        this.timeZoneOffsetSeconds = timeZoneOffsetSeconds;
    }

    public static ValueTimestampTimeZone fromDateValueAndNanos(long dateValue, long timeNanos, int timeZoneOffsetSeconds) {
        return (ValueTimestampTimeZone)Value.cache(new ValueTimestampTimeZone(dateValue, timeNanos, timeZoneOffsetSeconds));
    }

    public static ValueTimestampTimeZone parse(String s, CastDataProvider provider) {
        try {
            return (ValueTimestampTimeZone)DateTimeUtils.parseTimestamp(s, provider, true);
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "TIMESTAMP WITH TIME ZONE", s);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    public int getTimeZoneOffsetSeconds() {
        return this.timeZoneOffsetSeconds;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIMESTAMP_TZ;
    }

    @Override
    public int getValueType() {
        return 21;
    }

    @Override
    public int getMemory() {
        return 40;
    }

    @Override
    public String getString() {
        return this.toString(new StringBuilder(35), false).toString();
    }

    public String getISOString() {
        return this.toString(new StringBuilder(35), true).toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return this.toString(builder.append("TIMESTAMP WITH TIME ZONE '"), false).append('\'');
    }

    private StringBuilder toString(StringBuilder builder, boolean iso) {
        DateTimeUtils.appendDate(builder, this.dateValue).append(iso ? (char)'T' : ' ');
        DateTimeUtils.appendTime(builder, this.timeNanos);
        return DateTimeUtils.appendTimeZone(builder, this.timeZoneOffsetSeconds);
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        ValueTimestampTimeZone t = (ValueTimestampTimeZone)o;
        long dateValueA = this.dateValue;
        long timeA = this.timeNanos - (long)this.timeZoneOffsetSeconds * 1000000000L;
        if (timeA < 0L) {
            timeA += 86400000000000L;
            dateValueA = DateTimeUtils.decrementDateValue(dateValueA);
        } else if (timeA >= 86400000000000L) {
            timeA -= 86400000000000L;
            dateValueA = DateTimeUtils.incrementDateValue(dateValueA);
        }
        long dateValueB = t.dateValue;
        long timeB = t.timeNanos - (long)t.timeZoneOffsetSeconds * 1000000000L;
        if (timeB < 0L) {
            timeB += 86400000000000L;
            dateValueB = DateTimeUtils.decrementDateValue(dateValueB);
        } else if (timeB >= 86400000000000L) {
            timeB -= 86400000000000L;
            dateValueB = DateTimeUtils.incrementDateValue(dateValueB);
        }
        int cmp = Long.compare(dateValueA, dateValueB);
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(timeA, timeB);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueTimestampTimeZone)) {
            return false;
        }
        ValueTimestampTimeZone x = (ValueTimestampTimeZone)other;
        return this.dateValue == x.dateValue && this.timeNanos == x.timeNanos && this.timeZoneOffsetSeconds == x.timeZoneOffsetSeconds;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32 ^ (long)this.timeZoneOffsetSeconds);
    }
}

