/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueTime
extends Value {
    public static final int DEFAULT_PRECISION = 8;
    public static final int MAXIMUM_PRECISION = 18;
    public static final int DEFAULT_SCALE = 0;
    public static final int MAXIMUM_SCALE = 9;
    private final long nanos;

    private ValueTime(long nanos) {
        this.nanos = nanos;
    }

    public static ValueTime fromNanos(long nanos) {
        if (nanos < 0L || nanos >= 86400000000000L) {
            throw DbException.get(22007, "TIME", DateTimeUtils.appendTime(new StringBuilder(), nanos).toString());
        }
        return (ValueTime)Value.cache(new ValueTime(nanos));
    }

    public static ValueTime parse(String s) {
        try {
            return ValueTime.fromNanos(DateTimeUtils.parseTimeNanos(s, 0, s.length()));
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "TIME", s);
        }
    }

    public long getNanos() {
        return this.nanos;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIME;
    }

    @Override
    public int getValueType() {
        return 18;
    }

    @Override
    public String getString() {
        return DateTimeUtils.appendTime(new StringBuilder(18), this.nanos).toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return DateTimeUtils.appendTime(builder.append("TIME '"), this.nanos).append('\'');
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        return Long.compare(this.nanos, ((ValueTime)o).nanos);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof ValueTime && this.nanos == ((ValueTime)other).nanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.nanos ^ this.nanos >>> 32);
    }

    @Override
    public Value add(Value v) {
        ValueTime t = (ValueTime)v;
        return ValueTime.fromNanos(this.nanos + t.getNanos());
    }

    @Override
    public Value subtract(Value v) {
        ValueTime t = (ValueTime)v;
        return ValueTime.fromNanos(this.nanos - t.getNanos());
    }

    @Override
    public Value multiply(Value v) {
        return ValueTime.fromNanos((long)((double)this.nanos * v.getDouble()));
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        return ValueTime.fromNanos((long)((double)this.nanos / v.getDouble()));
    }
}

