/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueSmallint
extends Value {
    static final int PRECISION = 16;
    public static final int DECIMAL_PRECISION = 5;
    static final int DISPLAY_SIZE = 6;
    private final short value;

    private ValueSmallint(short value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueSmallint other = (ValueSmallint)v;
        return ValueSmallint.checkRange(this.value + other.value);
    }

    private static ValueSmallint checkRange(int x) {
        if ((short)x != x) {
            throw DbException.get(22003, Integer.toString(x));
        }
        return ValueSmallint.get((short)x);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueSmallint.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueSmallint other = (ValueSmallint)v;
        return ValueSmallint.checkRange(this.value - other.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueSmallint other = (ValueSmallint)v;
        return ValueSmallint.checkRange(this.value * other.value);
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        ValueSmallint other = (ValueSmallint)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueSmallint.checkRange(this.value / other.value);
    }

    @Override
    public Value modulus(Value v) {
        ValueSmallint other = (ValueSmallint)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueSmallint.get((short)(this.value % other.value));
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0) {
            return builder.append("CAST(").append(this.value).append(" AS SMALLINT)");
        }
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_SMALLINT;
    }

    @Override
    public int getValueType() {
        return 10;
    }

    @Override
    public byte[] getBytes() {
        short value = this.value;
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        return Integer.compare(this.value, ((ValueSmallint)o).value);
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    public static ValueSmallint get(short i) {
        return (ValueSmallint)Value.cache(new ValueSmallint(i));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueSmallint && this.value == ((ValueSmallint)other).value;
    }
}

