/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.result.SimpleResult;
import org.h2.value.CompareMode;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;

public final class ValueRow
extends ValueCollectionBase {
    public static final ValueRow EMPTY = ValueRow.get(Value.EMPTY_VALUES);
    private TypeInfo type;

    private ValueRow(TypeInfo type, Value[] list) {
        super(list);
        int degree = list.length;
        if (degree > 16384) {
            throw DbException.get(54011, "16384");
        }
        if (type != null) {
            if (type.getValueType() != 41 || ((ExtTypeInfoRow)type.getExtTypeInfo()).getFields().size() != degree) {
                throw DbException.getInternalError();
            }
            this.type = type;
        }
    }

    public static ValueRow get(Value[] list) {
        return new ValueRow(null, list);
    }

    public static ValueRow get(ExtTypeInfoRow extTypeInfo, Value[] list) {
        return new ValueRow(new TypeInfo(41, -1L, -1, extTypeInfo), list);
    }

    public static ValueRow get(TypeInfo typeInfo, Value[] list) {
        return new ValueRow(typeInfo, list);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            this.type = type = TypeInfo.getTypeInfo(41, 0L, 0, new ExtTypeInfoRow(this.values));
        }
        return type;
    }

    @Override
    public int getValueType() {
        return 41;
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder("ROW (");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.values[i].getString());
        }
        return builder.append(')').toString();
    }

    public SimpleResult getResult() {
        SimpleResult result = new SimpleResult();
        int i = 0;
        int l = this.values.length;
        while (i < l) {
            Value v = this.values[i++];
            result.addColumn("C" + i, v.getType());
        }
        result.addRow(this.values);
        return result;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        ValueRow v = (ValueRow)o;
        if (this.values == v.values) {
            return 0;
        }
        int len = this.values.length;
        if (len != v.values.length) {
            throw DbException.get(21002);
        }
        for (int i = 0; i < len; ++i) {
            Value v1 = this.values[i];
            Value v2 = v.values[i];
            int comp = v1.compareTo(v2, provider, mode);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        builder.append("ROW (");
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.values[i].getSQL(builder, sqlFlags);
        }
        return builder.append(')');
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueRow)) {
            return false;
        }
        ValueRow v = (ValueRow)other;
        if (this.values == v.values) {
            return true;
        }
        int len = this.values.length;
        if (len != v.values.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.values[i].equals(v.values[i])) continue;
            return false;
        }
        return true;
    }
}

