/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueReal
extends Value {
    static final int PRECISION = 24;
    static final int DECIMAL_PRECISION = 7;
    static final int DISPLAY_SIZE = 15;
    public static final int ZERO_BITS = 0;
    public static final ValueReal ZERO = new ValueReal(0.0f);
    public static final ValueReal ONE = new ValueReal(1.0f);
    private static final ValueReal NAN = new ValueReal(Float.NaN);
    private final float value;

    private ValueReal(float value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        return ValueReal.get(this.value + ((ValueReal)v).value);
    }

    @Override
    public Value subtract(Value v) {
        return ValueReal.get(this.value - ((ValueReal)v).value);
    }

    @Override
    public Value negate() {
        return ValueReal.get(-this.value);
    }

    @Override
    public Value multiply(Value v) {
        return ValueReal.get(this.value * ((ValueReal)v).value);
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        ValueReal v2 = (ValueReal)v;
        if ((double)v2.value == 0.0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueReal.get(this.value / v2.value);
    }

    @Override
    public Value modulus(Value v) {
        ValueReal other = (ValueReal)v;
        if (other.value == 0.0f) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueReal.get(this.value % other.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0) {
            return this.getSQL(builder.append("CAST(")).append(" AS REAL)");
        }
        return this.getSQL(builder);
    }

    private StringBuilder getSQL(StringBuilder builder) {
        if (this.value == Float.POSITIVE_INFINITY) {
            return builder.append("'Infinity'");
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return builder.append("'-Infinity'");
        }
        if (Float.isNaN(this.value)) {
            return builder.append("'NaN'");
        }
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_REAL;
    }

    @Override
    public int getValueType() {
        return 14;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        return Float.compare(this.value, ((ValueReal)o).value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0f || Float.isNaN(this.value) ? 0 : (this.value < 0.0f ? -1 : 1);
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Float.isFinite(this.value)) {
            return new BigDecimal(Float.toString(this.value));
        }
        throw DbException.get(22018, Float.toString(this.value));
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return Float.toString(this.value);
    }

    @Override
    public int hashCode() {
        return Float.floatToRawIntBits(this.value);
    }

    public static ValueReal get(float d) {
        if (d == 1.0f) {
            return ONE;
        }
        if (d == 0.0f) {
            return ZERO;
        }
        if (Float.isNaN(d)) {
            return NAN;
        }
        return (ValueReal)Value.cache(new ValueReal(d));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueReal)) {
            return false;
        }
        return this.compareTypeSafe((ValueReal)other, null, null) == 0;
    }
}

