/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import org.h2.engine.CastDataProvider;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;

public class ValueEnumBase
extends Value {
    final String label;
    private final int ordinal;

    protected ValueEnumBase(String label, int ordinal) {
        this.label = label;
        this.ordinal = ordinal;
    }

    @Override
    public Value add(Value v) {
        ValueInteger iv = v.convertToInt(null);
        return this.convertToInt(null).add(iv);
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode, CastDataProvider provider) {
        return Integer.compare(this.getInt(), v.getInt());
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        ValueInteger iv = v.convertToInt(null);
        return this.convertToInt(null).divide(iv, quotientType);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueEnumBase && this.getInt() == ((ValueEnumBase)other).getInt();
    }

    public static ValueEnumBase get(String label, int ordinal) {
        return new ValueEnumBase(label, ordinal);
    }

    @Override
    public int getInt() {
        return this.ordinal;
    }

    @Override
    public long getLong() {
        return this.ordinal;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.ordinal);
    }

    @Override
    public float getFloat() {
        return this.ordinal;
    }

    @Override
    public double getDouble() {
        return this.ordinal;
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.ordinal);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return StringUtils.quoteStringSQL(builder, this.label);
    }

    @Override
    public String getString() {
        return this.label;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_ENUM_UNDEFINED;
    }

    @Override
    public int getValueType() {
        return 36;
    }

    @Override
    public int getMemory() {
        return 120;
    }

    @Override
    public int hashCode() {
        int results = 31;
        results += this.getString().hashCode();
        return results += this.getInt();
    }

    @Override
    public Value modulus(Value v) {
        ValueInteger iv = v.convertToInt(null);
        return this.convertToInt(null).modulus(iv);
    }

    @Override
    public Value multiply(Value v) {
        ValueInteger iv = v.convertToInt(null);
        return this.convertToInt(null).multiply(iv);
    }

    @Override
    public Value subtract(Value v) {
        ValueInteger iv = v.convertToInt(null);
        return this.convertToInt(null).subtract(iv);
    }
}

