/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Arrays;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.Bits;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

abstract class ValueBytesBase
extends Value {
    byte[] value;
    int hash;

    ValueBytesBase(byte[] value) {
        int length = value.length;
        if (length > 1000000000) {
            throw DbException.getValueTooLongException(ValueBytesBase.getTypeName(this.getValueType()), StringUtils.convertBytesToHex(value, 41), length);
        }
        this.value = value;
    }

    @Override
    public final byte[] getBytes() {
        return Utils.cloneByteArray(this.value);
    }

    @Override
    public final byte[] getBytesNoCopy() {
        return this.value;
    }

    @Override
    public final int compareTypeSafe(Value v, CompareMode mode, CastDataProvider provider) {
        return Bits.compareNotNullUnsigned(this.value, ((ValueBytesBase)v).value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return StringUtils.convertBytesToHex(builder.append("X'"), this.value).append('\'');
    }

    @Override
    public final int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.getClass().hashCode() ^ Utils.getByteArrayHash(this.value);
            if (h == 0) {
                h = 1234570417;
            }
            this.hash = h;
        }
        return h;
    }

    @Override
    public int getMemory() {
        return this.value.length + 24;
    }

    @Override
    public final boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && Arrays.equals(this.value, ((ValueBytesBase)other).value);
    }
}

