/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorageInterface;
import org.h2.util.Bits;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.lob.LobData;
import org.h2.value.lob.LobDataDatabase;
import org.h2.value.lob.LobDataFetchOnDemand;
import org.h2.value.lob.LobDataFile;
import org.h2.value.lob.LobDataInMemory;

public final class ValueBlob
extends ValueLob {
    public static ValueBlob createSmall(byte[] data) {
        return new ValueBlob(new LobDataInMemory(data), data.length);
    }

    public static ValueBlob createTempBlob(InputStream in, long length, DataHandler handler) {
        try {
            byte[] buff;
            int len;
            long remaining = Long.MAX_VALUE;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLob.getBufferSize(handler, remaining)) >= Integer.MAX_VALUE) {
                buff = IOUtils.readBytesAndClose(in, -1);
                len = buff.length;
            } else {
                buff = Utils.newBytes(len);
                len = IOUtils.readFully(in, buff, len);
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                return ValueBlob.createSmall(Utils.copyBytes(buff, len));
            }
            return ValueBlob.createTemporary(handler, buff, len, in, remaining);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private static ValueBlob createTemporary(DataHandler handler, byte[] buff, int len, InputStream in, long remaining) throws IOException {
        String fileName = ValueLob.createTempLobFileName(handler);
        FileStore tempFile = handler.openFile(fileName, "rw", false);
        tempFile.autoDelete();
        long tmpPrecision = 0L;
        try (FileStoreOutputStream out = new FileStoreOutputStream(tempFile, null);){
            do {
                tmpPrecision += (long)len;
                out.write(buff, 0, len);
                if ((remaining -= (long)len) <= 0L) {
                    break;
                }
                len = ValueLob.getBufferSize(handler, remaining);
            } while ((len = IOUtils.readFully(in, buff, len)) > 0);
        }
        return new ValueBlob(new LobDataFile(handler, fileName, tempFile), tmpPrecision);
    }

    public ValueBlob(LobData lobData, long octetLength) {
        super(lobData, octetLength, -1L);
    }

    @Override
    public int getValueType() {
        return 7;
    }

    @Override
    public String getString() {
        long p = this.charLength;
        if (p >= 0L) {
            if (p > 1000000000L) {
                throw this.getStringTooLong(p);
            }
            return this.readString((int)p);
        }
        if (this.octetLength > 3000000000L) {
            throw this.getStringTooLong(this.charLength());
        }
        String s = this.lobData instanceof LobDataInMemory ? new String(((LobDataInMemory)this.lobData).getSmall(), StandardCharsets.UTF_8) : this.readString(Integer.MAX_VALUE);
        this.charLength = p = (long)s.length();
        if (p > 1000000000L) {
            throw this.getStringTooLong(p);
        }
        return s;
    }

    @Override
    byte[] getBytesInternal() {
        if (this.octetLength > 1000000000L) {
            throw this.getBinaryTooLong(this.octetLength);
        }
        return this.readBytes((int)this.octetLength);
    }

    @Override
    public InputStream getInputStream() {
        return this.lobData.getInputStream(this.octetLength);
    }

    @Override
    public InputStream getInputStream(long oneBasedOffset, long length) {
        long p = this.octetLength;
        return ValueBlob.rangeInputStream(this.lobData.getInputStream(p), oneBasedOffset, length, p);
    }

    @Override
    public Reader getReader(long oneBasedOffset, long length) {
        return ValueBlob.rangeReader(this.getReader(), oneBasedOffset, length, -1L);
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode, CastDataProvider provider) {
        if (v == this) {
            return 0;
        }
        ValueBlob v2 = (ValueBlob)v;
        LobData lobData = this.lobData;
        LobData lobData2 = v2.lobData;
        if (lobData.getClass() == lobData2.getClass()) {
            if (lobData instanceof LobDataInMemory) {
                return Bits.compareNotNullUnsigned(((LobDataInMemory)lobData).getSmall(), ((LobDataInMemory)lobData2).getSmall());
            }
            if (lobData instanceof LobDataDatabase ? ((LobDataDatabase)lobData).getLobId() == ((LobDataDatabase)lobData2).getLobId() : lobData instanceof LobDataFetchOnDemand && ((LobDataFetchOnDemand)lobData).getLobId() == ((LobDataFetchOnDemand)lobData2).getLobId()) {
                return 0;
            }
        }
        return ValueBlob.compare(this, v2);
    }

    /*
     * Exception decompiling
     */
    private static int compare(ValueBlob v1, ValueBlob v2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 42[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if (!((sqlFlags & 2) == 0 || this.lobData instanceof LobDataInMemory && this.octetLength <= SysProperties.MAX_TRACE_DATA_LENGTH)) {
            builder.append("CAST(REPEAT(CHAR(0), ").append(this.octetLength).append(") AS BINARY VARYING");
            LobDataDatabase lobDb = (LobDataDatabase)this.lobData;
            builder.append(" /* table: ").append(lobDb.getTableId()).append(" id: ").append(lobDb.getLobId()).append(" */)");
        } else if ((sqlFlags & 6) == 0) {
            builder.append("CAST(X'");
            StringUtils.convertBytesToHex(builder, this.getBytesNoCopy()).append("' AS BINARY LARGE OBJECT(").append(this.octetLength).append("))");
        } else {
            builder.append("X'");
            StringUtils.convertBytesToHex(builder, this.getBytesNoCopy()).append('\'');
        }
        return builder;
    }

    ValueBlob convertPrecision(long precision) {
        ValueBlob lob;
        if (this.octetLength <= precision) {
            return this;
        }
        DataHandler handler = this.lobData.getDataHandler();
        if (handler != null) {
            lob = ValueBlob.createTempBlob(this.getInputStream(), precision, handler);
        } else {
            try {
                lob = ValueBlob.createSmall(IOUtils.readBytesAndClose(this.getInputStream(), MathUtils.convertLongToInt(precision)));
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        }
        return lob;
    }

    @Override
    public ValueLob copy(DataHandler database, int tableId) {
        if (this.lobData instanceof LobDataInMemory) {
            byte[] small = ((LobDataInMemory)this.lobData).getSmall();
            if (small.length > database.getMaxLengthInplaceLob()) {
                LobStorageInterface s = database.getLobStorage();
                ValueBlob v = s.createBlob(this.getInputStream(), this.octetLength);
                ValueLob v2 = v.copy(database, tableId);
                v.remove();
                return v2;
            }
            return this;
        }
        if (this.lobData instanceof LobDataDatabase) {
            return database.getLobStorage().copyLob(this, tableId);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long charLength() {
        long p = this.charLength;
        if (p < 0L) {
            if (this.lobData instanceof LobDataInMemory) {
                p = new String(((LobDataInMemory)this.lobData).getSmall(), StandardCharsets.UTF_8).length();
            } else {
                try (Reader r = this.getReader();){
                    p = 0L;
                    while (true) {
                        p += r.skip(Long.MAX_VALUE);
                        if (r.read() < 0) {
                            break;
                        }
                        ++p;
                    }
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, null);
                }
            }
            this.charLength = p;
        }
        return p;
    }

    @Override
    public long octetLength() {
        return this.octetLength;
    }
}

