/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.Data;
import org.h2.store.DataReader;
import org.h2.util.Bits;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.ExtTypeInfo;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.ExtTypeInfoNumeric;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBinary;
import org.h2.value.ValueBlob;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueChar;
import org.h2.value.ValueClob;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueEnumBase;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueRow;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;
import org.h2.value.lob.LobData;
import org.h2.value.lob.LobDataDatabase;
import org.h2.value.lob.LobDataFetchOnDemand;

public final class Transfer {
    private static final int BUFFER_SIZE = 65536;
    private static final int LOB_MAGIC = 4660;
    private static final int LOB_MAC_SALT_LENGTH = 16;
    private static final int NULL = 0;
    private static final int BOOLEAN = 1;
    private static final int TINYINT = 2;
    private static final int SMALLINT = 3;
    private static final int INTEGER = 4;
    private static final int BIGINT = 5;
    private static final int NUMERIC = 6;
    private static final int DOUBLE = 7;
    private static final int REAL = 8;
    private static final int TIME = 9;
    private static final int DATE = 10;
    private static final int TIMESTAMP = 11;
    private static final int VARBINARY = 12;
    private static final int VARCHAR = 13;
    private static final int VARCHAR_IGNORECASE = 14;
    private static final int BLOB = 15;
    private static final int CLOB = 16;
    private static final int ARRAY = 17;
    private static final int JAVA_OBJECT = 19;
    private static final int UUID = 20;
    private static final int CHAR = 21;
    private static final int GEOMETRY = 22;
    private static final int TIMESTAMP_TZ = 24;
    private static final int ENUM = 25;
    private static final int INTERVAL = 26;
    private static final int ROW = 27;
    private static final int JSON = 28;
    private static final int TIME_TZ = 29;
    private static final int BINARY = 30;
    private static final int DECFLOAT = 31;
    private static final int[] VALUE_TO_TI = new int[43];
    private static final int[] TI_TO_VALUE = new int[45];
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private Session session;
    private boolean ssl;
    private int version;
    private byte[] lobMacSalt;

    private static void addType(int typeInformationType, int valueType) {
        Transfer.VALUE_TO_TI[valueType + 1] = typeInformationType;
        Transfer.TI_TO_VALUE[typeInformationType + 1] = valueType;
    }

    public Transfer(Session session, Socket s) {
        this.session = session;
        this.socket = s;
    }

    public synchronized void init() throws IOException {
        if (this.socket != null) {
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 65536));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 65536));
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public Transfer writeBoolean(boolean x) throws IOException {
        this.out.writeByte((byte)(x ? 1 : 0));
        return this;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readByte() != 0;
    }

    public Transfer writeByte(byte x) throws IOException {
        this.out.writeByte(x);
        return this;
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    private Transfer writeShort(short x) throws IOException {
        this.out.writeShort(x);
        return this;
    }

    private short readShort() throws IOException {
        return this.in.readShort();
    }

    public Transfer writeInt(int x) throws IOException {
        this.out.writeInt(x);
        return this;
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public Transfer writeLong(long x) throws IOException {
        this.out.writeLong(x);
        return this;
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    private Transfer writeDouble(double i) throws IOException {
        this.out.writeDouble(i);
        return this;
    }

    private Transfer writeFloat(float i) throws IOException {
        this.out.writeFloat(i);
        return this;
    }

    private double readDouble() throws IOException {
        return this.in.readDouble();
    }

    private float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public Transfer writeString(String s) throws IOException {
        if (s == null) {
            this.out.writeInt(-1);
        } else {
            this.out.writeInt(s.length());
            this.out.writeChars(s);
        }
        return this;
    }

    public String readString() throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        StringBuilder buff = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            buff.append(this.in.readChar());
        }
        String s = buff.toString();
        s = StringUtils.cache(s);
        return s;
    }

    public Transfer writeBytes(byte[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            this.out.write(data);
        }
        return this;
    }

    public Transfer writeBytes(byte[] buff, int off, int len) throws IOException {
        this.out.write(buff, off, len);
        return this;
    }

    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        byte[] b = Utils.newBytes(len);
        this.in.readFully(b);
        return b;
    }

    public void readBytes(byte[] buff, int off, int len) throws IOException {
        this.in.readFully(buff, off, len);
    }

    public synchronized void close() {
        if (this.socket != null) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
                this.socket.close();
            }
            catch (IOException e) {
                DbException.traceThrowable(e);
            }
            finally {
                this.socket = null;
            }
        }
    }

    public Transfer writeTypeInfo(TypeInfo type) throws IOException {
        if (this.version >= 20) {
            this.writeTypeInfo20(type);
        } else {
            this.writeTypeInfo19(type);
        }
        return this;
    }

    private void writeTypeInfo20(TypeInfo type) throws IOException {
        int valueType = type.getValueType();
        this.writeInt(VALUE_TO_TI[valueType + 1]);
        switch (valueType) {
            case -1: 
            case 0: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 39: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 35: 
            case 38: {
                this.writeInt((int)type.getDeclaredPrecision());
                break;
            }
            case 3: 
            case 7: {
                this.writeLong(type.getDeclaredPrecision());
                break;
            }
            case 13: {
                this.writeInt((int)type.getDeclaredPrecision());
                this.writeInt(type.getDeclaredScale());
                this.writeBoolean(type.getExtTypeInfo() != null);
                break;
            }
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                this.writeBytePrecisionWithDefault(type.getDeclaredPrecision());
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.writeByteScaleWithDefault(type.getDeclaredScale());
                break;
            }
            case 27: 
            case 31: 
            case 33: 
            case 34: {
                this.writeBytePrecisionWithDefault(type.getDeclaredPrecision());
                this.writeByteScaleWithDefault(type.getDeclaredScale());
                break;
            }
            case 36: {
                this.writeTypeInfoEnum(type);
                break;
            }
            case 37: {
                this.writeTypeInfoGeometry(type);
                break;
            }
            case 40: {
                this.writeInt((int)type.getDeclaredPrecision());
                this.writeTypeInfo((TypeInfo)type.getExtTypeInfo());
                break;
            }
            case 41: {
                this.writeTypeInfoRow(type);
                break;
            }
            default: {
                throw DbException.getUnsupportedException("value type " + valueType);
            }
        }
    }

    private void writeBytePrecisionWithDefault(long precision) throws IOException {
        this.writeByte(precision >= 0L ? (byte)precision : (byte)-1);
    }

    private void writeByteScaleWithDefault(int scale) throws IOException {
        this.writeByte((byte)(scale >= 0 ? (int)scale : -1));
    }

    private void writeTypeInfoEnum(TypeInfo type) throws IOException {
        ExtTypeInfoEnum ext = (ExtTypeInfoEnum)type.getExtTypeInfo();
        if (ext != null) {
            int c = ext.getCount();
            this.writeInt(c);
            for (int i = 0; i < c; ++i) {
                this.writeString(ext.getEnumerator(i));
            }
        } else {
            this.writeInt(0);
        }
    }

    private void writeTypeInfoGeometry(TypeInfo type) throws IOException {
        ExtTypeInfoGeometry ext = (ExtTypeInfoGeometry)type.getExtTypeInfo();
        if (ext == null) {
            this.writeByte((byte)0);
        } else {
            int t = ext.getType();
            Integer srid = ext.getSrid();
            if (t == 0) {
                if (srid == null) {
                    this.writeByte((byte)0);
                } else {
                    this.writeByte((byte)2);
                    this.writeInt(srid);
                }
            } else if (srid == null) {
                this.writeByte((byte)1);
                this.writeShort((short)t);
            } else {
                this.writeByte((byte)3);
                this.writeShort((short)t);
                this.writeInt(srid);
            }
        }
    }

    private void writeTypeInfoRow(TypeInfo type) throws IOException {
        Set<Map.Entry<String, TypeInfo>> fields = ((ExtTypeInfoRow)type.getExtTypeInfo()).getFields();
        this.writeInt(fields.size());
        for (Map.Entry<String, TypeInfo> field : fields) {
            this.writeString(field.getKey()).writeTypeInfo(field.getValue());
        }
    }

    private void writeTypeInfo19(TypeInfo type) throws IOException {
        int valueType = type.getValueType();
        switch (valueType) {
            case 5: {
                valueType = 6;
                break;
            }
            case 16: {
                valueType = 13;
            }
        }
        this.writeInt(VALUE_TO_TI[valueType + 1]).writeLong(type.getPrecision()).writeInt(type.getScale());
    }

    public TypeInfo readTypeInfo() throws IOException {
        if (this.version >= 20) {
            return this.readTypeInfo20();
        }
        return this.readTypeInfo19();
    }

    private TypeInfo readTypeInfo20() throws IOException {
        int valueType = TI_TO_VALUE[this.readInt() + 1];
        long precision = -1L;
        int scale = -1;
        ExtTypeInfo ext = null;
        switch (valueType) {
            case -1: 
            case 0: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 39: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 35: 
            case 38: {
                precision = this.readInt();
                break;
            }
            case 3: 
            case 7: {
                precision = this.readLong();
                break;
            }
            case 13: {
                precision = this.readInt();
                scale = this.readInt();
                if (!this.readBoolean()) break;
                ext = ExtTypeInfoNumeric.DECIMAL;
                break;
            }
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                precision = this.readByte();
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                scale = this.readByte();
                break;
            }
            case 27: 
            case 31: 
            case 33: 
            case 34: {
                precision = this.readByte();
                scale = this.readByte();
                break;
            }
            case 36: {
                ext = this.readTypeInfoEnum();
                break;
            }
            case 37: {
                ext = this.readTypeInfoGeometry();
                break;
            }
            case 40: {
                precision = this.readInt();
                ext = this.readTypeInfo();
                break;
            }
            case 41: {
                ext = this.readTypeInfoRow();
                break;
            }
            default: {
                throw DbException.getUnsupportedException("value type " + valueType);
            }
        }
        return TypeInfo.getTypeInfo(valueType, precision, scale, ext);
    }

    private ExtTypeInfo readTypeInfoEnum() throws IOException {
        ExtTypeInfoEnum ext;
        int c = this.readInt();
        if (c > 0) {
            String[] enumerators = new String[c];
            for (int i = 0; i < c; ++i) {
                enumerators[i] = this.readString();
            }
            ext = new ExtTypeInfoEnum(enumerators);
        } else {
            ext = null;
        }
        return ext;
    }

    private ExtTypeInfo readTypeInfoGeometry() throws IOException {
        ExtTypeInfoGeometry ext;
        byte e = this.readByte();
        switch (e) {
            case 0: {
                ext = null;
                break;
            }
            case 1: {
                ext = new ExtTypeInfoGeometry(this.readShort(), null);
                break;
            }
            case 2: {
                ext = new ExtTypeInfoGeometry(0, this.readInt());
                break;
            }
            case 3: {
                ext = new ExtTypeInfoGeometry(this.readShort(), this.readInt());
                break;
            }
            default: {
                throw DbException.getUnsupportedException("GEOMETRY type encoding " + e);
            }
        }
        return ext;
    }

    private ExtTypeInfo readTypeInfoRow() throws IOException {
        LinkedHashMap<String, TypeInfo> fields = new LinkedHashMap<String, TypeInfo>();
        int l = this.readInt();
        for (int i = 0; i < l; ++i) {
            String name = this.readString();
            if (fields.putIfAbsent(name, this.readTypeInfo()) == null) continue;
            throw DbException.get(42121, name);
        }
        return new ExtTypeInfoRow(fields);
    }

    private TypeInfo readTypeInfo19() throws IOException {
        return TypeInfo.getTypeInfo(TI_TO_VALUE[this.readInt() + 1], this.readLong(), this.readInt(), null);
    }

    public void writeValue(Value v) throws IOException {
        int type = v.getValueType();
        switch (type) {
            case 0: {
                this.writeInt(0);
                break;
            }
            case 5: {
                if (this.version >= 20) {
                    this.writeInt(30);
                    this.writeBytes(v.getBytesNoCopy());
                    break;
                }
            }
            case 6: {
                this.writeInt(12);
                this.writeBytes(v.getBytesNoCopy());
                break;
            }
            case 35: {
                this.writeInt(19);
                this.writeBytes(v.getBytesNoCopy());
                break;
            }
            case 39: {
                this.writeInt(20);
                ValueUuid uuid = (ValueUuid)v;
                this.writeLong(uuid.getHigh());
                this.writeLong(uuid.getLow());
                break;
            }
            case 8: {
                this.writeInt(1);
                this.writeBoolean(v.getBoolean());
                break;
            }
            case 9: {
                this.writeInt(2);
                this.writeByte(v.getByte());
                break;
            }
            case 18: {
                this.writeInt(9);
                this.writeLong(((ValueTime)v).getNanos());
                break;
            }
            case 19: {
                ValueTimeTimeZone t = (ValueTimeTimeZone)v;
                if (this.version >= 19) {
                    this.writeInt(29);
                    this.writeLong(t.getNanos());
                    this.writeInt(t.getTimeZoneOffsetSeconds());
                    break;
                }
                this.writeInt(9);
                ValueTimestampTimeZone current = this.session.isRemote() ? DateTimeUtils.currentTimestamp(DateTimeUtils.getTimeZone()) : this.session.currentTimestamp();
                this.writeLong(DateTimeUtils.normalizeNanosOfDay(t.getNanos() + (long)(t.getTimeZoneOffsetSeconds() - current.getTimeZoneOffsetSeconds()) * 86400000000000L));
                break;
            }
            case 17: {
                this.writeInt(10);
                this.writeLong(((ValueDate)v).getDateValue());
                break;
            }
            case 20: {
                this.writeInt(11);
                ValueTimestamp ts = (ValueTimestamp)v;
                this.writeLong(ts.getDateValue());
                this.writeLong(ts.getTimeNanos());
                break;
            }
            case 21: {
                this.writeInt(24);
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)v;
                this.writeLong(ts.getDateValue());
                this.writeLong(ts.getTimeNanos());
                int timeZoneOffset = ts.getTimeZoneOffsetSeconds();
                this.writeInt(this.version >= 19 ? timeZoneOffset : timeZoneOffset / 60);
                break;
            }
            case 16: {
                if (this.version >= 20) {
                    this.writeInt(31);
                    this.writeString(v.getString());
                    break;
                }
            }
            case 13: {
                this.writeInt(6);
                this.writeString(v.getString());
                break;
            }
            case 15: {
                this.writeInt(7);
                this.writeDouble(v.getDouble());
                break;
            }
            case 14: {
                this.writeInt(8);
                this.writeFloat(v.getFloat());
                break;
            }
            case 11: {
                this.writeInt(4);
                this.writeInt(v.getInt());
                break;
            }
            case 12: {
                this.writeInt(5);
                this.writeLong(v.getLong());
                break;
            }
            case 10: {
                this.writeInt(3);
                if (this.version >= 20) {
                    this.writeShort(v.getShort());
                    break;
                }
                this.writeInt(v.getShort());
                break;
            }
            case 2: {
                this.writeInt(13);
                this.writeString(v.getString());
                break;
            }
            case 4: {
                this.writeInt(14);
                this.writeString(v.getString());
                break;
            }
            case 1: {
                this.writeInt(21);
                this.writeString(v.getString());
                break;
            }
            case 7: {
                this.writeInt(15);
                ValueBlob lob = (ValueBlob)v;
                LobData lobData = lob.getLobData();
                long length = lob.octetLength();
                if (lobData instanceof LobDataDatabase) {
                    LobDataDatabase lobDataDatabase = (LobDataDatabase)lobData;
                    this.writeLong(-1L);
                    this.writeInt(lobDataDatabase.getTableId());
                    this.writeLong(lobDataDatabase.getLobId());
                    this.writeBytes(this.calculateLobMac(lobDataDatabase.getLobId()));
                    this.writeLong(length);
                    break;
                }
                if (length < 0L) {
                    throw DbException.get(90067, "length=" + length);
                }
                this.writeLong(length);
                long written = IOUtils.copyAndCloseInput(lob.getInputStream(), this.out);
                if (written != length) {
                    throw DbException.get(90067, "length:" + length + " written:" + written);
                }
                this.writeInt(4660);
                break;
            }
            case 3: {
                this.writeInt(16);
                ValueClob lob = (ValueClob)v;
                LobData lobData = lob.getLobData();
                long charLength = lob.charLength();
                if (lobData instanceof LobDataDatabase) {
                    LobDataDatabase lobDataDatabase = (LobDataDatabase)lobData;
                    this.writeLong(-1L);
                    this.writeInt(lobDataDatabase.getTableId());
                    this.writeLong(lobDataDatabase.getLobId());
                    this.writeBytes(this.calculateLobMac(lobDataDatabase.getLobId()));
                    if (this.version >= 20) {
                        this.writeLong(lob.octetLength());
                    }
                    this.writeLong(charLength);
                    break;
                }
                if (charLength < 0L) {
                    throw DbException.get(90067, "length=" + charLength);
                }
                this.writeLong(charLength);
                Reader reader = lob.getReader();
                Data.copyString(reader, this.out);
                this.writeInt(4660);
                break;
            }
            case 40: {
                this.writeInt(17);
                ValueArray va = (ValueArray)v;
                Value[] list = va.getList();
                int len = list.length;
                this.writeInt(len);
                for (Value value : list) {
                    this.writeValue(value);
                }
                break;
            }
            case 41: {
                this.writeInt(this.version >= 18 ? 27 : 17);
                ValueRow va = (ValueRow)v;
                Value[] list = va.getList();
                int len = list.length;
                this.writeInt(len);
                for (Value value : list) {
                    this.writeValue(value);
                }
                break;
            }
            case 36: {
                this.writeInt(25);
                this.writeInt(v.getInt());
                if (this.version >= 20) break;
                this.writeString(v.getString());
                break;
            }
            case 37: {
                this.writeInt(22);
                this.writeBytes(v.getBytesNoCopy());
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (this.version >= 18) {
                    ValueInterval interval = (ValueInterval)v;
                    int ordinal = type - 22;
                    if (interval.isNegative()) {
                        ordinal ^= 0xFFFFFFFF;
                    }
                    this.writeInt(26);
                    this.writeByte((byte)ordinal);
                    this.writeLong(interval.getLeading());
                    break;
                }
                this.writeInt(13);
                this.writeString(v.getString());
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                if (this.version >= 18) {
                    ValueInterval interval = (ValueInterval)v;
                    int ordinal = type - 22;
                    if (interval.isNegative()) {
                        ordinal ^= 0xFFFFFFFF;
                    }
                    this.writeInt(26);
                    this.writeByte((byte)ordinal);
                    this.writeLong(interval.getLeading());
                    this.writeLong(interval.getRemaining());
                    break;
                }
                this.writeInt(13);
                this.writeString(v.getString());
                break;
            }
            case 38: {
                this.writeInt(28);
                this.writeBytes(v.getBytesNoCopy());
                break;
            }
            default: {
                throw DbException.get(90067, "type=" + type);
            }
        }
    }

    public Value readValue(TypeInfo columnType) throws IOException {
        int type = this.readInt();
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                return ValueVarbinary.getNoCopy(this.readBytes());
            }
            case 30: {
                return ValueBinary.getNoCopy(this.readBytes());
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 19: {
                return ValueJavaObject.getNoCopy(this.readBytes());
            }
            case 1: {
                return ValueBoolean.get(this.readBoolean());
            }
            case 2: {
                return ValueTinyint.get(this.readByte());
            }
            case 10: {
                return ValueDate.fromDateValue(this.readLong());
            }
            case 9: {
                return ValueTime.fromNanos(this.readLong());
            }
            case 29: {
                return ValueTimeTimeZone.fromNanos(this.readLong(), this.readInt());
            }
            case 11: {
                return ValueTimestamp.fromDateValueAndNanos(this.readLong(), this.readLong());
            }
            case 24: {
                long dateValue = this.readLong();
                long timeNanos = this.readLong();
                int timeZoneOffset = this.readInt();
                return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, this.version >= 19 ? timeZoneOffset : timeZoneOffset * 60);
            }
            case 6: {
                return ValueNumeric.get(new BigDecimal(this.readString()));
            }
            case 7: {
                return ValueDouble.get(this.readDouble());
            }
            case 8: {
                return ValueReal.get(this.readFloat());
            }
            case 25: {
                int ordinal = this.readInt();
                if (this.version >= 20) {
                    return ((ExtTypeInfoEnum)columnType.getExtTypeInfo()).getValue(ordinal, (CastDataProvider)this.session);
                }
                return ValueEnumBase.get(this.readString(), ordinal);
            }
            case 4: {
                return ValueInteger.get(this.readInt());
            }
            case 5: {
                return ValueBigint.get(this.readLong());
            }
            case 3: {
                if (this.version >= 20) {
                    return ValueSmallint.get(this.readShort());
                }
                return ValueSmallint.get((short)this.readInt());
            }
            case 13: {
                return ValueVarchar.get(this.readString());
            }
            case 14: {
                return ValueVarcharIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueChar.get(this.readString());
            }
            case 15: {
                long length = this.readLong();
                if (length == -1L) {
                    int tableId = this.readInt();
                    long id = this.readLong();
                    byte[] hmac = this.readBytes();
                    long precision = this.readLong();
                    return new ValueBlob(new LobDataFetchOnDemand(this.session.getDataHandler(), tableId, id, hmac), precision);
                }
                ValueBlob v = this.session.getDataHandler().getLobStorage().createBlob(this.in, length);
                int magic = this.readInt();
                if (magic != 4660) {
                    throw DbException.get(90067, "magic=" + magic);
                }
                return v;
            }
            case 16: {
                long charLength = this.readLong();
                if (charLength == -1L) {
                    int tableId = this.readInt();
                    long id = this.readLong();
                    byte[] hmac = this.readBytes();
                    long octetLength = this.version >= 20 ? this.readLong() : -1L;
                    charLength = this.readLong();
                    return new ValueClob(new LobDataFetchOnDemand(this.session.getDataHandler(), tableId, id, hmac), octetLength, charLength);
                }
                if (charLength < 0L) {
                    throw DbException.get(90067, "length=" + charLength);
                }
                ValueClob v = this.session.getDataHandler().getLobStorage().createClob(new DataReader(this.in), charLength);
                int magic = this.readInt();
                if (magic != 4660) {
                    throw DbException.get(90067, "magic=" + magic);
                }
                return v;
            }
            case 17: {
                int len = this.readInt();
                if (len < 0) {
                    len ^= 0xFFFFFFFF;
                    this.readString();
                }
                if (columnType != null) {
                    TypeInfo elementType = (TypeInfo)columnType.getExtTypeInfo();
                    return ValueArray.get(elementType, this.readArrayElements(len, elementType), this.session);
                }
                return ValueArray.get(this.readArrayElements(len, null), this.session);
            }
            case 27: {
                int len = this.readInt();
                Value[] list = new Value[len];
                if (columnType != null) {
                    ExtTypeInfoRow extTypeInfoRow = (ExtTypeInfoRow)columnType.getExtTypeInfo();
                    Iterator<Map.Entry<String, TypeInfo>> fields = extTypeInfoRow.getFields().iterator();
                    for (int i = 0; i < len; ++i) {
                        list[i] = this.readValue(fields.next().getValue());
                    }
                    return ValueRow.get(columnType, list);
                }
                for (int i = 0; i < len; ++i) {
                    list[i] = this.readValue(null);
                }
                return ValueRow.get(list);
            }
            case 22: {
                return ValueGeometry.get(this.readBytes());
            }
            case 26: {
                boolean negative;
                int ordinal = this.readByte();
                boolean bl = negative = ordinal < 0;
                if (negative) {
                    ordinal ^= 0xFFFFFFFF;
                }
                return ValueInterval.from(IntervalQualifier.valueOf(ordinal), negative, this.readLong(), ordinal < 5 ? 0L : this.readLong());
            }
            case 28: {
                return ValueJson.fromJson(this.readBytes());
            }
            case 31: {
                String s;
                switch (s = this.readString()) {
                    case "-Infinity": {
                        return ValueDecfloat.NEGATIVE_INFINITY;
                    }
                    case "Infinity": {
                        return ValueDecfloat.POSITIVE_INFINITY;
                    }
                    case "NaN": {
                        return ValueDecfloat.NAN;
                    }
                }
                return ValueDecfloat.get(new BigDecimal(s));
            }
        }
        throw DbException.get(90067, "type=" + type);
    }

    private Value[] readArrayElements(int len, TypeInfo elementType) throws IOException {
        Value[] list = new Value[len];
        for (int i = 0; i < len; ++i) {
            list[i] = this.readValue(elementType);
        }
        return list;
    }

    public long readRowCount() throws IOException {
        return this.version >= 20 ? this.readLong() : (long)this.readInt();
    }

    public Transfer writeRowCount(long rowCount) throws IOException {
        return this.version >= 20 ? this.writeLong(rowCount) : this.writeInt(rowCount < Integer.MAX_VALUE ? (int)rowCount : Integer.MAX_VALUE);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public Transfer openNewConnection() throws IOException {
        InetAddress address = this.socket.getInetAddress();
        int port = this.socket.getPort();
        Socket s2 = NetUtils.createSocket(address, port, this.ssl);
        Transfer trans = new Transfer(null, s2);
        trans.setSSL(this.ssl);
        return trans;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public synchronized boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public void verifyLobMac(byte[] hmac, long lobId) {
        byte[] result = this.calculateLobMac(lobId);
        if (!Utils.compareSecure(hmac, result)) {
            throw DbException.get(90067, "Invalid lob hmac; possibly the connection was re-opened internally");
        }
    }

    private byte[] calculateLobMac(long lobId) {
        if (this.lobMacSalt == null) {
            this.lobMacSalt = MathUtils.secureRandomBytes(16);
        }
        byte[] data = new byte[8];
        Bits.writeLong(data, 0, lobId);
        return SHA256.getHashWithSalt(data, this.lobMacSalt);
    }

    static {
        Transfer.addType(-1, -1);
        Transfer.addType(0, 0);
        Transfer.addType(1, 8);
        Transfer.addType(2, 9);
        Transfer.addType(3, 10);
        Transfer.addType(4, 11);
        Transfer.addType(5, 12);
        Transfer.addType(6, 13);
        Transfer.addType(7, 15);
        Transfer.addType(8, 14);
        Transfer.addType(9, 18);
        Transfer.addType(10, 17);
        Transfer.addType(11, 20);
        Transfer.addType(12, 6);
        Transfer.addType(13, 2);
        Transfer.addType(14, 4);
        Transfer.addType(15, 7);
        Transfer.addType(16, 3);
        Transfer.addType(17, 40);
        Transfer.addType(19, 35);
        Transfer.addType(20, 39);
        Transfer.addType(21, 1);
        Transfer.addType(22, 37);
        Transfer.addType(24, 21);
        Transfer.addType(25, 36);
        Transfer.addType(26, 22);
        Transfer.addType(27, 23);
        Transfer.addType(28, 24);
        Transfer.addType(29, 25);
        Transfer.addType(30, 26);
        Transfer.addType(31, 27);
        Transfer.addType(32, 28);
        Transfer.addType(33, 29);
        Transfer.addType(34, 30);
        Transfer.addType(35, 31);
        Transfer.addType(36, 32);
        Transfer.addType(37, 33);
        Transfer.addType(38, 34);
        Transfer.addType(39, 41);
        Transfer.addType(40, 38);
        Transfer.addType(41, 19);
        Transfer.addType(42, 5);
        Transfer.addType(43, 16);
    }
}

