/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Objects;
import org.h2.util.geometry.EWKTUtils;
import org.h2.value.ExtTypeInfo;

public final class ExtTypeInfoGeometry
extends ExtTypeInfo {
    private final int type;
    private final Integer srid;

    static StringBuilder toSQL(StringBuilder builder, int type, Integer srid) {
        if (type == 0 && srid == null) {
            return builder;
        }
        builder.append('(');
        if (type == 0) {
            builder.append("GEOMETRY");
        } else {
            EWKTUtils.formatGeometryTypeAndDimensionSystem(builder, type);
        }
        if (srid != null) {
            builder.append(", ").append(srid);
        }
        return builder.append(')');
    }

    public ExtTypeInfoGeometry(int type, Integer srid) {
        this.type = type;
        this.srid = srid;
    }

    public int hashCode() {
        return 31 * (this.srid == null ? 0 : this.srid.hashCode()) + this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ExtTypeInfoGeometry.class) {
            return false;
        }
        ExtTypeInfoGeometry other = (ExtTypeInfoGeometry)obj;
        return this.type == other.type && Objects.equals(this.srid, other.srid);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return ExtTypeInfoGeometry.toSQL(builder, this.type, this.srid);
    }

    public int getType() {
        return this.type;
    }

    public Integer getSrid() {
        return this.srid;
    }
}

