/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Locale;
import org.h2.message.DbException;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;

public class CompareModeIcu4J
extends CompareMode {
    private final Comparator<String> collator;
    private volatile CompareModeIcu4J caseInsensitive;

    protected CompareModeIcu4J(String name, int strength) {
        super(name, strength);
        this.collator = CompareModeIcu4J.getIcu4jCollator(name, strength);
    }

    @Override
    public int compareString(String a, String b, boolean ignoreCase) {
        if (ignoreCase && this.getStrength() > 1) {
            CompareModeIcu4J i = this.caseInsensitive;
            if (i == null) {
                this.caseInsensitive = i = new CompareModeIcu4J(this.getName(), 1);
            }
            return i.compareString(a, b, false);
        }
        return this.collator.compare(a, b);
    }

    @Override
    public boolean equalsChars(String a, int ai, String b, int bi, boolean ignoreCase) {
        return this.compareString(a.substring(ai, ai + 1), b.substring(bi, bi + 1), ignoreCase) == 0;
    }

    private static Comparator<String> getIcu4jCollator(String name, int strength) {
        try {
            String country;
            String language;
            Locale locale3;
            int idx;
            Comparator result = null;
            Class collatorClass = JdbcUtils.loadUserClass("com.ibm.icu.text.Collator");
            Method getInstanceMethod = collatorClass.getMethod("getInstance", Locale.class);
            int length = name.length();
            if (length == 2) {
                Locale locale2 = new Locale(StringUtils.toLowerEnglish(name), "");
                if (CompareModeIcu4J.compareLocaleNames(locale2, name)) {
                    result = (Comparator)getInstanceMethod.invoke(null, locale2);
                }
            } else if (length == 5 && (idx = name.indexOf(95)) >= 0 && CompareModeIcu4J.compareLocaleNames(locale3 = new Locale(language = StringUtils.toLowerEnglish(name.substring(0, idx)), country = name.substring(idx + 1)), name)) {
                result = (Comparator)getInstanceMethod.invoke(null, locale3);
            }
            if (result == null) {
                for (Locale locale3 : (Locale[])collatorClass.getMethod("getAvailableLocales", new Class[0]).invoke(null, new Object[0])) {
                    if (!CompareModeIcu4J.compareLocaleNames(locale3, name)) continue;
                    result = (Comparator)getInstanceMethod.invoke(null, locale3);
                    break;
                }
            }
            if (result == null) {
                throw DbException.getInvalidValueException("collator", name);
            }
            collatorClass.getMethod("setStrength", Integer.TYPE).invoke((Object)result, strength);
            return result;
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }
}

