/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import org.h2.util.StringUtils;
import org.h2.value.CharsetCollator;
import org.h2.value.CompareModeDefault;
import org.h2.value.CompareModeIcu4J;
import org.h2.value.Value;

public class CompareMode
implements Comparator<Value> {
    public static final String OFF = "OFF";
    public static final String DEFAULT = "DEFAULT_";
    public static final String ICU4J = "ICU4J_";
    public static final String CHARSET = "CHARSET_";
    private static Locale[] LOCALES;
    private static volatile CompareMode lastUsed;
    private static final boolean CAN_USE_ICU4J;
    private final String name;
    private final int strength;

    protected CompareMode(String name, int strength) {
        this.name = name;
        this.strength = strength;
    }

    public static CompareMode getInstance(String name, int strength) {
        CompareMode last = lastUsed;
        if (last != null && Objects.equals(last.name, name) && last.strength == strength) {
            return last;
        }
        if (name == null || name.equals(OFF)) {
            last = new CompareMode(name, strength);
        } else {
            boolean useICU4J;
            if (name.startsWith(ICU4J)) {
                useICU4J = true;
                name = name.substring(ICU4J.length());
            } else if (name.startsWith(DEFAULT)) {
                useICU4J = false;
                name = name.substring(DEFAULT.length());
            } else {
                useICU4J = name.startsWith(CHARSET) ? false : CAN_USE_ICU4J;
            }
            last = useICU4J ? new CompareModeIcu4J(name, strength) : new CompareModeDefault(name, strength);
        }
        lastUsed = last;
        return last;
    }

    public static Locale[] getCollationLocales(boolean onlyIfInitialized) {
        Locale[] locales = LOCALES;
        if (locales == null && !onlyIfInitialized) {
            locales = Collator.getAvailableLocales();
            LOCALES = locales;
        }
        return locales;
    }

    public boolean equalsChars(String a, int ai, String b, int bi, boolean ignoreCase) {
        char cb;
        char ca = a.charAt(ai);
        if (ca == (cb = b.charAt(bi))) {
            return true;
        }
        return ignoreCase && (Character.toUpperCase(ca) == Character.toUpperCase(cb) || Character.toLowerCase(ca) == Character.toLowerCase(cb));
    }

    public int compareString(String a, String b, boolean ignoreCase) {
        if (ignoreCase) {
            return a.compareToIgnoreCase(b);
        }
        return a.compareTo(b);
    }

    public static String getName(Locale l) {
        Locale english = Locale.ENGLISH;
        String name = l.getDisplayLanguage(english) + ' ' + l.getDisplayCountry(english) + ' ' + l.getVariant();
        name = StringUtils.toUpperEnglish(name.trim().replace(' ', '_'));
        return name;
    }

    static boolean compareLocaleNames(Locale locale, String name) {
        return name.equalsIgnoreCase(locale.toString()) || name.equalsIgnoreCase(locale.toLanguageTag()) || name.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String name) {
        Locale locale;
        Collator result = null;
        if (name.startsWith(ICU4J)) {
            name = name.substring(ICU4J.length());
        } else if (name.startsWith(DEFAULT)) {
            name = name.substring(DEFAULT.length());
        } else if (name.startsWith(CHARSET)) {
            return new CharsetCollator(Charset.forName(name.substring(CHARSET.length())));
        }
        int length = name.length();
        if (length == 2) {
            locale = new Locale(StringUtils.toLowerEnglish(name), "");
            if (CompareMode.compareLocaleNames(locale, name)) {
                result = Collator.getInstance(locale);
            }
        } else if (length == 5) {
            String country;
            String language;
            Locale locale2;
            int idx = name.indexOf(95);
            if (idx >= 0 && CompareMode.compareLocaleNames(locale2 = new Locale(language = StringUtils.toLowerEnglish(name.substring(0, idx)), country = name.substring(idx + 1)), name)) {
                result = Collator.getInstance(locale2);
            }
        } else if (name.indexOf(45) > 0 && !(locale = Locale.forLanguageTag(name)).getLanguage().isEmpty()) {
            return Collator.getInstance(locale);
        }
        if (result == null) {
            for (Locale locale2 : CompareMode.getCollationLocales(false)) {
                if (!CompareMode.compareLocaleNames(locale2, name)) continue;
                result = Collator.getInstance(locale2);
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.name == null ? OFF : this.name;
    }

    public int getStrength() {
        return this.strength;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompareMode)) {
            return false;
        }
        CompareMode o = (CompareMode)obj;
        if (!this.getName().equals(o.getName())) {
            return false;
        }
        return this.strength == o.strength;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.strength;
        return result;
    }

    @Override
    public int compare(Value o1, Value o2) {
        return o1.compareTo(o2, null, this);
    }

    static {
        boolean b = false;
        try {
            Class.forName("com.ibm.icu.text.Collator");
            b = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        CAN_USE_ICU4J = b;
    }
}

