/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.json;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.h2.util.json.JSONByteArrayTarget;
import org.h2.util.json.JSONStringSource;
import org.h2.util.json.JSONTarget;
import org.h2.util.json.JSONTextSource;

public final class JSONBytesSource
extends JSONTextSource {
    private final byte[] bytes;
    private final int length;
    private int index;

    public static <R> R parse(byte[] bytes, JSONTarget<R> target) {
        Charset charset;
        block18: {
            int length;
            block17: {
                length = bytes.length;
                charset = null;
                if (length < 4) break block17;
                byte b0 = bytes[0];
                byte b1 = bytes[1];
                byte b2 = bytes[2];
                byte b3 = bytes[3];
                switch (b0) {
                    case -2: {
                        if (b1 == -1) {
                            charset = StandardCharsets.UTF_16BE;
                            break;
                        }
                        break block18;
                    }
                    case -1: {
                        if (b1 == -2) {
                            if (b2 == 0 && b3 == 0) {
                                charset = Charset.forName("UTF-32LE");
                                break;
                            }
                            charset = StandardCharsets.UTF_16LE;
                            break;
                        }
                        break block18;
                    }
                    case 0: {
                        if (b1 != 0) {
                            charset = StandardCharsets.UTF_16BE;
                            break;
                        }
                        if (b2 == 0 && b3 != 0 || b2 == -2 && b3 == -1) {
                            charset = Charset.forName("UTF-32BE");
                            break;
                        }
                        break block18;
                    }
                    default: {
                        if (b1 == 0) {
                            if (b2 == 0 && b3 == 0) {
                                charset = Charset.forName("UTF-32LE");
                                break;
                            }
                            charset = StandardCharsets.UTF_16LE;
                            break;
                        }
                        break block18;
                    }
                }
                break block18;
            }
            if (length >= 2) {
                byte b0 = bytes[0];
                byte b1 = bytes[1];
                if (b0 != 0) {
                    if (b1 == 0) {
                        charset = StandardCharsets.UTF_16LE;
                    }
                } else if (b1 != 0) {
                    charset = StandardCharsets.UTF_16BE;
                }
            }
        }
        (charset == null ? new JSONBytesSource(bytes, target) : new JSONStringSource(new String(bytes, charset), target)).parse();
        return target.getResult();
    }

    public static byte[] normalize(byte[] bytes) {
        return JSONBytesSource.parse(bytes, new JSONByteArrayTarget());
    }

    JSONBytesSource(byte[] bytes, JSONTarget<?> target) {
        super(target);
        this.bytes = bytes;
        this.length = bytes.length;
        if (this.nextChar() != 65279) {
            this.index = 0;
        }
    }

    @Override
    int nextCharAfterWhitespace() {
        int index = this.index;
        block3: while (index < this.length) {
            byte ch = this.bytes[index++];
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            if (ch < 0) {
                throw new IllegalArgumentException();
            }
            this.index = index;
            return ch;
        }
        return -1;
    }

    @Override
    void readKeyword1(String keyword) {
        int l = keyword.length() - 1;
        if (this.index + l > this.length) {
            throw new IllegalArgumentException();
        }
        int i = this.index;
        for (int j = 1; j <= l; ++j) {
            if (this.bytes[i] != keyword.charAt(j)) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        this.index += l;
    }

    @Override
    void parseNumber(boolean positive) {
        int start;
        int index;
        block6: {
            byte ch;
            block7: {
                index = this.index;
                start = index - 1;
                if ((index = this.skipInt(index, positive)) >= this.length) break block6;
                ch = this.bytes[index];
                if (ch != 46) break block7;
                if ((index = this.skipInt(index + 1, false)) >= this.length) break block6;
                ch = this.bytes[index];
            }
            if (ch == 69 || ch == 101) {
                if (++index >= this.length) {
                    throw new IllegalArgumentException();
                }
                ch = this.bytes[index];
                if (ch == 43 || ch == 45) {
                    ++index;
                }
                index = this.skipInt(index, false);
            }
        }
        this.target.valueNumber(new BigDecimal(new String(this.bytes, start, index - start, StandardCharsets.ISO_8859_1)));
        this.index = index;
    }

    private int skipInt(int index, boolean hasInt) {
        byte ch;
        while (index < this.length && (ch = this.bytes[index]) >= 48 && ch <= 57) {
            hasInt = true;
            ++index;
        }
        if (!hasInt) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    @Override
    int nextChar() {
        int b1;
        if (this.index >= this.length) {
            throw new IllegalArgumentException();
        }
        if ((b1 = this.bytes[this.index++] & 0xFF) >= 128) {
            if (b1 >= 224) {
                if (b1 >= 240) {
                    int b4;
                    int b3;
                    int b2;
                    if (this.index + 2 >= this.length) {
                        throw new IllegalArgumentException();
                    }
                    if ((b1 = ((b1 & 0xF) << 18) + (((b2 = this.bytes[this.index++] & 0xFF) & 0x3F) << 12) + (((b3 = this.bytes[this.index++] & 0xFF) & 0x3F) << 6) + ((b4 = this.bytes[this.index++] & 0xFF) & 0x3F)) < 65536 || b1 > 0x10FFFF || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                } else {
                    int b3;
                    int b2;
                    if (this.index + 1 >= this.length) {
                        throw new IllegalArgumentException();
                    }
                    if ((b1 = ((b1 & 0xF) << 12) + (((b2 = this.bytes[this.index++] & 0xFF) & 0x3F) << 6) + ((b3 = this.bytes[this.index++] & 0xFF) & 0x3F)) < 2048 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                }
            } else {
                int b2;
                if (this.index >= this.length) {
                    throw new IllegalArgumentException();
                }
                if ((b1 = ((b1 & 0x1F) << 6) + ((b2 = this.bytes[this.index++] & 0xFF) & 0x3F)) < 128 || (b2 & 0xC0) != 128) {
                    throw new IllegalArgumentException();
                }
            }
        }
        return b1;
    }

    @Override
    char readHex() {
        int ch;
        if (this.index + 3 >= this.length) {
            throw new IllegalArgumentException();
        }
        try {
            ch = Integer.parseInt(new String(this.bytes, this.index, 4, StandardCharsets.ISO_8859_1), 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
        this.index += 4;
        return (char)ch;
    }

    public String toString() {
        return new String(this.bytes, 0, this.index, StandardCharsets.UTF_8) + "[*]" + new String(this.bytes, this.index, this.length, StandardCharsets.UTF_8);
    }
}

