/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.json;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.h2.util.ByteStack;
import org.h2.util.json.JSONStringTarget;
import org.h2.util.json.JSONTarget;

public final class JSONByteArrayTarget
extends JSONTarget<byte[]> {
    private static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] FALSE_BYTES = "false".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] TRUE_BYTES = "true".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] U00_BYTES = "\\u00".getBytes(StandardCharsets.ISO_8859_1);
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final ByteStack stack = new ByteStack();
    private boolean needSeparator;
    private boolean afterName;

    public static ByteArrayOutputStream encodeString(ByteArrayOutputStream baos, String s) {
        baos.write(34);
        int length = s.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    baos.write(92);
                    baos.write(98);
                    continue block9;
                }
                case '\t': {
                    baos.write(92);
                    baos.write(116);
                    continue block9;
                }
                case '\f': {
                    baos.write(92);
                    baos.write(102);
                    continue block9;
                }
                case '\n': {
                    baos.write(92);
                    baos.write(110);
                    continue block9;
                }
                case '\r': {
                    baos.write(92);
                    baos.write(114);
                    continue block9;
                }
                case '\"': {
                    baos.write(92);
                    baos.write(34);
                    continue block9;
                }
                case '\\': {
                    baos.write(92);
                    baos.write(92);
                    continue block9;
                }
                default: {
                    if (c >= ' ') {
                        char c2;
                        if (c < '\u0080') {
                            baos.write(c);
                            continue block9;
                        }
                        if (c < '\u0800') {
                            baos.write(0xC0 | c >> 6);
                            baos.write(0x80 | c & 0x3F);
                            continue block9;
                        }
                        if (!Character.isSurrogate(c)) {
                            baos.write(0xE0 | c >> 12);
                            baos.write(0x80 | c >> 6 & 0x3F);
                            baos.write(0x80 | c & 0x3F);
                            continue block9;
                        }
                        if (!Character.isHighSurrogate(c) || ++i >= length || !Character.isLowSurrogate(c2 = s.charAt(i))) {
                            throw new IllegalArgumentException();
                        }
                        int uc = Character.toCodePoint(c, c2);
                        baos.write(0xF0 | uc >> 18);
                        baos.write(0x80 | uc >> 12 & 0x3F);
                        baos.write(0x80 | uc >> 6 & 0x3F);
                        baos.write(0x80 | uc & 0x3F);
                        continue block9;
                    }
                    baos.write(U00_BYTES, 0, 4);
                    baos.write(JSONStringTarget.HEX[c >>> 4 & 0xF]);
                    baos.write(JSONStringTarget.HEX[c & 0xF]);
                }
            }
        }
        baos.write(34);
        return baos;
    }

    @Override
    public void startObject() {
        this.beforeValue();
        this.afterName = false;
        this.stack.push((byte)1);
        this.baos.write(123);
    }

    @Override
    public void endObject() {
        if (this.afterName || this.stack.poll(-1) != 1) {
            throw new IllegalStateException();
        }
        this.baos.write(125);
        this.afterValue();
    }

    @Override
    public void startArray() {
        this.beforeValue();
        this.afterName = false;
        this.stack.push((byte)2);
        this.baos.write(91);
    }

    @Override
    public void endArray() {
        if (this.stack.poll(-1) != 2) {
            throw new IllegalStateException();
        }
        this.baos.write(93);
        this.afterValue();
    }

    @Override
    public void member(String name) {
        if (this.afterName || this.stack.peek(-1) != 1) {
            throw new IllegalStateException();
        }
        this.afterName = true;
        this.beforeValue();
        JSONByteArrayTarget.encodeString(this.baos, name).write(58);
    }

    @Override
    public void valueNull() {
        this.beforeValue();
        this.baos.write(NULL_BYTES, 0, 4);
        this.afterValue();
    }

    @Override
    public void valueFalse() {
        this.beforeValue();
        this.baos.write(FALSE_BYTES, 0, 5);
        this.afterValue();
    }

    @Override
    public void valueTrue() {
        this.beforeValue();
        this.baos.write(TRUE_BYTES, 0, 4);
        this.afterValue();
    }

    @Override
    public void valueNumber(BigDecimal number) {
        this.beforeValue();
        String s = number.toString();
        int index = s.indexOf(69);
        byte[] b = s.getBytes(StandardCharsets.ISO_8859_1);
        if (index >= 0 && s.charAt(++index) == '+') {
            this.baos.write(b, 0, index);
            this.baos.write(b, index + 1, b.length - index - 1);
        } else {
            this.baos.write(b, 0, b.length);
        }
        this.afterValue();
    }

    @Override
    public void valueString(String string) {
        this.beforeValue();
        JSONByteArrayTarget.encodeString(this.baos, string);
        this.afterValue();
    }

    private void beforeValue() {
        if (!this.afterName && this.stack.peek(-1) == 1) {
            throw new IllegalStateException();
        }
        if (this.needSeparator) {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException();
            }
            this.needSeparator = false;
            this.baos.write(44);
        }
    }

    private void afterValue() {
        this.needSeparator = true;
        this.afterName = false;
    }

    @Override
    public boolean isPropertyExpected() {
        return !this.afterName && this.stack.peek(-1) == 1;
    }

    @Override
    public boolean isValueSeparatorExpected() {
        return this.needSeparator;
    }

    @Override
    public byte[] getResult() {
        if (!this.stack.isEmpty() || this.baos.size() == 0) {
            throw new IllegalStateException();
        }
        return this.baos.toByteArray();
    }
}

