/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.geometry;

import java.io.ByteArrayOutputStream;
import org.h2.message.DbException;
import org.h2.util.geometry.EWKBUtils;
import org.h2.util.geometry.GeometryUtils;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;

public final class JTSUtils {
    public static Geometry ewkb2geometry(byte[] ewkb) {
        return JTSUtils.ewkb2geometry(ewkb, EWKBUtils.getDimensionSystem(ewkb));
    }

    public static Geometry ewkb2geometry(byte[] ewkb, int dimensionSystem) {
        GeometryTarget target = new GeometryTarget(dimensionSystem);
        EWKBUtils.parseEWKB(ewkb, target);
        return target.getGeometry();
    }

    public static byte[] geometry2ewkb(Geometry geometry) {
        return JTSUtils.geometry2ewkb(geometry, JTSUtils.getDimensionSystem(geometry));
    }

    public static byte[] geometry2ewkb(Geometry geometry, int dimensionSystem) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        EWKBUtils.EWKBTarget target = new EWKBUtils.EWKBTarget(output, dimensionSystem);
        JTSUtils.parseGeometry(geometry, target);
        return output.toByteArray();
    }

    public static void parseGeometry(Geometry geometry, GeometryUtils.Target target) {
        JTSUtils.parseGeometry(geometry, target, 0);
    }

    private static void parseGeometry(Geometry geometry, GeometryUtils.Target target, int parentType) {
        if (parentType == 0) {
            target.init(geometry.getSRID());
        }
        if (geometry instanceof Point) {
            if (parentType != 0 && parentType != 4 && parentType != 7) {
                throw new IllegalArgumentException();
            }
            target.startPoint();
            Point p = (Point)geometry;
            if (p.isEmpty()) {
                target.addCoordinate(Double.NaN, Double.NaN, Double.NaN, Double.NaN, 0, 1);
            } else {
                JTSUtils.addCoordinate(p.getCoordinateSequence(), target, 0, 1);
            }
            target.endObject(1);
        } else if (geometry instanceof LineString) {
            if (parentType != 0 && parentType != 5 && parentType != 7) {
                throw new IllegalArgumentException();
            }
            LineString ls = (LineString)geometry;
            CoordinateSequence cs = ls.getCoordinateSequence();
            int numPoints = cs.size();
            if (numPoints == 1) {
                throw new IllegalArgumentException();
            }
            target.startLineString(numPoints);
            for (int i = 0; i < numPoints; ++i) {
                JTSUtils.addCoordinate(cs, target, i, numPoints);
            }
            target.endObject(2);
        } else if (geometry instanceof Polygon) {
            if (parentType != 0 && parentType != 6 && parentType != 7) {
                throw new IllegalArgumentException();
            }
            Polygon p = (Polygon)geometry;
            int numInner = p.getNumInteriorRing();
            CoordinateSequence cs = p.getExteriorRing().getCoordinateSequence();
            int size = cs.size();
            if (size >= 1 && size <= 3) {
                throw new IllegalArgumentException();
            }
            if (size == 0 && numInner > 0) {
                throw new IllegalArgumentException();
            }
            target.startPolygon(numInner, size);
            if (size > 0) {
                JTSUtils.addRing(cs, target, size);
                for (int i = 0; i < numInner; ++i) {
                    cs = p.getInteriorRingN(i).getCoordinateSequence();
                    size = cs.size();
                    if (size >= 1 && size <= 3) {
                        throw new IllegalArgumentException();
                    }
                    target.startPolygonInner(size);
                    JTSUtils.addRing(cs, target, size);
                }
                target.endNonEmptyPolygon();
            }
            target.endObject(3);
        } else if (geometry instanceof GeometryCollection) {
            if (parentType != 0 && parentType != 7) {
                throw new IllegalArgumentException();
            }
            GeometryCollection gc = (GeometryCollection)geometry;
            int type = gc instanceof MultiPoint ? 4 : (gc instanceof MultiLineString ? 5 : (gc instanceof MultiPolygon ? 6 : 7));
            int numItems = gc.getNumGeometries();
            target.startCollection(type, numItems);
            for (int i = 0; i < numItems; ++i) {
                GeometryUtils.Target innerTarget = target.startCollectionItem(i, numItems);
                JTSUtils.parseGeometry(gc.getGeometryN(i), innerTarget, type);
                target.endCollectionItem(innerTarget, type, i, numItems);
            }
            target.endObject(type);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static void addRing(CoordinateSequence sequence, GeometryUtils.Target target, int size) {
        if (size >= 4) {
            double startX = GeometryUtils.toCanonicalDouble(sequence.getX(0));
            double startY = GeometryUtils.toCanonicalDouble(sequence.getY(0));
            JTSUtils.addCoordinate(sequence, target, 0, size, startX, startY);
            for (int i = 1; i < size - 1; ++i) {
                JTSUtils.addCoordinate(sequence, target, i, size);
            }
            double endX = GeometryUtils.toCanonicalDouble(sequence.getX(size - 1));
            double endY = GeometryUtils.toCanonicalDouble(sequence.getY(size - 1));
            if (startX != endX || startY != endY) {
                throw new IllegalArgumentException();
            }
            JTSUtils.addCoordinate(sequence, target, size - 1, size, endX, endY);
        }
    }

    private static void addCoordinate(CoordinateSequence sequence, GeometryUtils.Target target, int index, int total) {
        JTSUtils.addCoordinate(sequence, target, index, total, GeometryUtils.toCanonicalDouble(sequence.getX(index)), GeometryUtils.toCanonicalDouble(sequence.getY(index)));
    }

    private static void addCoordinate(CoordinateSequence sequence, GeometryUtils.Target target, int index, int total, double x, double y) {
        double z = GeometryUtils.toCanonicalDouble(sequence.getZ(index));
        double m = GeometryUtils.toCanonicalDouble(sequence.getM(index));
        target.addCoordinate(x, y, z, m, index, total);
    }

    public static int getDimensionSystem(Geometry geometry) {
        int d = JTSUtils.getDimensionSystem1(geometry);
        return d >= 0 ? d : 0;
    }

    private static int getDimensionSystem1(Geometry geometry) {
        int d;
        if (geometry instanceof Point) {
            d = JTSUtils.getDimensionSystemFromSequence(((Point)geometry).getCoordinateSequence());
        } else if (geometry instanceof LineString) {
            d = JTSUtils.getDimensionSystemFromSequence(((LineString)geometry).getCoordinateSequence());
        } else if (geometry instanceof Polygon) {
            d = JTSUtils.getDimensionSystemFromSequence(((Polygon)geometry).getExteriorRing().getCoordinateSequence());
        } else if (geometry instanceof GeometryCollection) {
            d = -1;
            GeometryCollection gc = (GeometryCollection)geometry;
            int l = gc.getNumGeometries();
            for (int i = 0; i < l && (d = JTSUtils.getDimensionSystem1(gc.getGeometryN(i))) < 0; ++i) {
            }
        } else {
            throw new IllegalArgumentException();
        }
        return d;
    }

    private static int getDimensionSystemFromSequence(CoordinateSequence sequence) {
        int size = sequence.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                int d = JTSUtils.getDimensionSystemFromCoordinate(sequence, i);
                if (d < 0) continue;
                return d;
            }
        }
        return (sequence.hasZ() ? 1 : 0) | (sequence.hasM() ? 2 : 0);
    }

    private static int getDimensionSystemFromCoordinate(CoordinateSequence sequence, int index) {
        if (Double.isNaN(sequence.getX(index))) {
            return -1;
        }
        return (!Double.isNaN(sequence.getZ(index)) ? 1 : 0) | (!Double.isNaN(sequence.getM(index)) ? 2 : 0);
    }

    private JTSUtils() {
    }

    public static final class GeometryTarget
    extends GeometryUtils.Target {
        private final int dimensionSystem;
        private GeometryFactory factory;
        private int type;
        private CoordinateSequence coordinates;
        private CoordinateSequence[] innerCoordinates;
        private int innerOffset;
        private Geometry[] subgeometries;

        public GeometryTarget(int dimensionSystem) {
            this.dimensionSystem = dimensionSystem;
        }

        private GeometryTarget(int dimensionSystem, GeometryFactory factory) {
            this.dimensionSystem = dimensionSystem;
            this.factory = factory;
        }

        @Override
        protected void init(int srid) {
            this.factory = new GeometryFactory(new PrecisionModel(), srid, (CoordinateSequenceFactory)((this.dimensionSystem & 2) != 0 ? PackedCoordinateSequenceFactory.DOUBLE_FACTORY : CoordinateArraySequenceFactory.instance()));
        }

        @Override
        protected void startPoint() {
            this.type = 1;
            this.initCoordinates(1);
            this.innerOffset = -1;
        }

        @Override
        protected void startLineString(int numPoints) {
            this.type = 2;
            this.initCoordinates(numPoints);
            this.innerOffset = -1;
        }

        @Override
        protected void startPolygon(int numInner, int numPoints) {
            this.type = 3;
            this.initCoordinates(numPoints);
            this.innerCoordinates = new CoordinateSequence[numInner];
            this.innerOffset = -1;
        }

        @Override
        protected void startPolygonInner(int numInner) {
            this.innerCoordinates[++this.innerOffset] = this.createCoordinates(numInner);
        }

        @Override
        protected void startCollection(int type, int numItems) {
            this.type = type;
            switch (type) {
                case 4: {
                    this.subgeometries = new Point[numItems];
                    break;
                }
                case 5: {
                    this.subgeometries = new LineString[numItems];
                    break;
                }
                case 6: {
                    this.subgeometries = new Polygon[numItems];
                    break;
                }
                case 7: {
                    this.subgeometries = new Geometry[numItems];
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        protected GeometryUtils.Target startCollectionItem(int index, int total) {
            return new GeometryTarget(this.dimensionSystem, this.factory);
        }

        @Override
        protected void endCollectionItem(GeometryUtils.Target target, int type, int index, int total) {
            this.subgeometries[index] = ((GeometryTarget)target).getGeometry();
        }

        private void initCoordinates(int numPoints) {
            this.coordinates = this.createCoordinates(numPoints);
        }

        private CoordinateSequence createCoordinates(int numPoints) {
            int m;
            int d;
            switch (this.dimensionSystem) {
                case 0: {
                    d = 2;
                    m = 0;
                    break;
                }
                case 1: {
                    d = 3;
                    m = 0;
                    break;
                }
                case 2: {
                    d = 3;
                    m = 1;
                    break;
                }
                case 3: {
                    d = 4;
                    m = 1;
                    break;
                }
                default: {
                    throw DbException.getInternalError();
                }
            }
            return this.factory.getCoordinateSequenceFactory().create(numPoints, d, m);
        }

        @Override
        protected void addCoordinate(double x, double y, double z, double m, int index, int total) {
            if (this.type == 1 && Double.isNaN(x) && Double.isNaN(y) && Double.isNaN(z) && Double.isNaN(m)) {
                this.coordinates = this.createCoordinates(0);
                return;
            }
            CoordinateSequence coordinates = this.innerOffset < 0 ? this.coordinates : this.innerCoordinates[this.innerOffset];
            coordinates.setOrdinate(index, 0, GeometryUtils.checkFinite(x));
            coordinates.setOrdinate(index, 1, GeometryUtils.checkFinite(y));
            switch (this.dimensionSystem) {
                case 3: {
                    coordinates.setOrdinate(index, 3, GeometryUtils.checkFinite(m));
                }
                case 1: {
                    coordinates.setOrdinate(index, 2, GeometryUtils.checkFinite(z));
                    break;
                }
                case 2: {
                    coordinates.setOrdinate(index, 2, GeometryUtils.checkFinite(m));
                }
            }
        }

        Geometry getGeometry() {
            switch (this.type) {
                case 1: {
                    return new Point(this.coordinates, this.factory);
                }
                case 2: {
                    return new LineString(this.coordinates, this.factory);
                }
                case 3: {
                    LinearRing shell = new LinearRing(this.coordinates, this.factory);
                    int innerCount = this.innerCoordinates.length;
                    LinearRing[] holes = new LinearRing[innerCount];
                    for (int i = 0; i < innerCount; ++i) {
                        holes[i] = new LinearRing(this.innerCoordinates[i], this.factory);
                    }
                    return new Polygon(shell, holes, this.factory);
                }
                case 4: {
                    return new MultiPoint((Point[])this.subgeometries, this.factory);
                }
                case 5: {
                    return new MultiLineString((LineString[])this.subgeometries, this.factory);
                }
                case 6: {
                    return new MultiPolygon((Polygon[])this.subgeometries, this.factory);
                }
                case 7: {
                    return new GeometryCollection(this.subgeometries, this.factory);
                }
            }
            throw new IllegalStateException();
        }
    }
}

