/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.h2.engine.CastDataProvider;
import org.h2.util.DateTimeUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueNull;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public final class LegacyDateTimeUtils {
    public static final java.sql.Date PROLEPTIC_GREGORIAN_CHANGE = new java.sql.Date(Long.MIN_VALUE);
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private LegacyDateTimeUtils() {
    }

    public static ValueDate fromDate(CastDataProvider provider, TimeZone timeZone, java.sql.Date date) {
        long ms = date.getTime();
        return ValueDate.fromDateValue(LegacyDateTimeUtils.dateValueFromLocalMillis(ms + (long)(timeZone == null ? LegacyDateTimeUtils.getTimeZoneOffsetMillis(provider, ms) : timeZone.getOffset(ms))));
    }

    public static ValueTime fromTime(CastDataProvider provider, TimeZone timeZone, Time time) {
        long ms = time.getTime();
        return ValueTime.fromNanos(LegacyDateTimeUtils.nanosFromLocalMillis(ms + (long)(timeZone == null ? LegacyDateTimeUtils.getTimeZoneOffsetMillis(provider, ms) : timeZone.getOffset(ms))));
    }

    public static ValueTimestamp fromTimestamp(CastDataProvider provider, TimeZone timeZone, Timestamp timestamp) {
        long ms = timestamp.getTime();
        return LegacyDateTimeUtils.timestampFromLocalMillis(ms + (long)(timeZone == null ? LegacyDateTimeUtils.getTimeZoneOffsetMillis(provider, ms) : timeZone.getOffset(ms)), timestamp.getNanos() % 1000000);
    }

    public static ValueTimestamp fromTimestamp(CastDataProvider provider, long ms, int nanos) {
        return LegacyDateTimeUtils.timestampFromLocalMillis(ms + (long)LegacyDateTimeUtils.getTimeZoneOffsetMillis(provider, ms), nanos);
    }

    private static ValueTimestamp timestampFromLocalMillis(long ms, int nanos) {
        long dateValue = LegacyDateTimeUtils.dateValueFromLocalMillis(ms);
        long timeNanos = (long)nanos + LegacyDateTimeUtils.nanosFromLocalMillis(ms);
        return ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
    }

    public static long dateValueFromLocalMillis(long ms) {
        long absoluteDay = ms / 86400000L;
        if (ms < 0L && absoluteDay * 86400000L != ms) {
            --absoluteDay;
        }
        return DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay);
    }

    public static long nanosFromLocalMillis(long ms) {
        if ((ms %= 86400000L) < 0L) {
            ms += 86400000L;
        }
        return ms * 1000000L;
    }

    public static java.sql.Date toDate(CastDataProvider provider, TimeZone timeZone, Value value) {
        return value != ValueNull.INSTANCE ? new java.sql.Date(LegacyDateTimeUtils.getMillis(provider, timeZone, value.convertToDate(provider).getDateValue(), 0L)) : null;
    }

    public static Time toTime(CastDataProvider provider, TimeZone timeZone, Value value) {
        switch (value.getValueType()) {
            case 0: {
                return null;
            }
            default: {
                value = value.convertTo(TypeInfo.TYPE_TIME, provider);
            }
            case 18: 
        }
        return new Time(LegacyDateTimeUtils.getMillis(provider, timeZone, 1008673L, ((ValueTime)value).getNanos()));
    }

    public static Timestamp toTimestamp(CastDataProvider provider, TimeZone timeZone, Value value) {
        switch (value.getValueType()) {
            case 0: {
                return null;
            }
            default: {
                value = value.convertTo(TypeInfo.TYPE_TIMESTAMP, provider);
            }
            case 20: {
                ValueTimestamp v = (ValueTimestamp)value;
                long timeNanos = v.getTimeNanos();
                Timestamp ts = new Timestamp(LegacyDateTimeUtils.getMillis(provider, timeZone, v.getDateValue(), timeNanos));
                ts.setNanos((int)(timeNanos % 1000000000L));
                return ts;
            }
            case 21: 
        }
        ValueTimestampTimeZone v = (ValueTimestampTimeZone)value;
        long timeNanos = v.getTimeNanos();
        Timestamp ts = new Timestamp(DateTimeUtils.absoluteDayFromDateValue(v.getDateValue()) * 86400000L + timeNanos / 1000000L - (long)(v.getTimeZoneOffsetSeconds() * 1000));
        ts.setNanos((int)(timeNanos % 1000000000L));
        return ts;
    }

    public static long getMillis(CastDataProvider provider, TimeZone tz, long dateValue, long timeNanos) {
        return (tz == null ? (provider != null ? provider.currentTimeZone() : DateTimeUtils.getTimeZone()) : TimeZoneProvider.ofId(tz.getID())).getEpochSecondsFromLocal(dateValue, timeNanos) * 1000L + timeNanos / 1000000L % 1000L;
    }

    public static int getTimeZoneOffsetMillis(CastDataProvider provider, long ms) {
        long seconds = ms / 1000L;
        if (ms < 0L && seconds * 1000L != ms) {
            --seconds;
        }
        return (provider != null ? provider.currentTimeZone() : DateTimeUtils.getTimeZone()).getTimeZoneOffsetUTC(seconds) * 1000;
    }

    public static Value legacyObjectToValue(CastDataProvider session, Object x) {
        if (x instanceof java.sql.Date) {
            return LegacyDateTimeUtils.fromDate(session, null, (java.sql.Date)x);
        }
        if (x instanceof Time) {
            return LegacyDateTimeUtils.fromTime(session, null, (Time)x);
        }
        if (x instanceof Timestamp) {
            return LegacyDateTimeUtils.fromTimestamp(session, null, (Timestamp)x);
        }
        if (x instanceof Date) {
            return LegacyDateTimeUtils.fromTimestamp(session, ((Date)x).getTime(), 0);
        }
        if (x instanceof Calendar) {
            Calendar gc = (Calendar)x;
            long ms = gc.getTimeInMillis();
            return LegacyDateTimeUtils.timestampFromLocalMillis(ms + (long)gc.getTimeZone().getOffset(ms), 0);
        }
        return null;
    }

    public static <T> T valueToLegacyType(Class<T> type, Value value, CastDataProvider provider) {
        if (type == java.sql.Date.class) {
            return (T)LegacyDateTimeUtils.toDate(provider, null, value);
        }
        if (type == Time.class) {
            return (T)LegacyDateTimeUtils.toTime(provider, null, value);
        }
        if (type == Timestamp.class) {
            return (T)LegacyDateTimeUtils.toTimestamp(provider, null, value);
        }
        if (type == Date.class) {
            return (T)new Date(LegacyDateTimeUtils.toTimestamp(provider, null, value).getTime());
        }
        if (type == Calendar.class) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setGregorianChange(PROLEPTIC_GREGORIAN_CHANGE);
            calendar.setTime(LegacyDateTimeUtils.toTimestamp(provider, calendar.getTimeZone(), value));
            return (T)calendar;
        }
        return null;
    }

    public static TypeInfo legacyClassToType(Class<?> clazz) {
        if (java.sql.Date.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_DATE;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_TIME;
        }
        if (Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_TIMESTAMP;
        }
        return null;
    }
}

