/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueInterval;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class JSR310Utils {
    private static final long MIN_DATE_VALUE = -511999999455L;
    private static final long MAX_DATE_VALUE = 511999999903L;
    private static final long MIN_INSTANT_SECOND = -31557014167219200L;
    private static final long MAX_INSTANT_SECOND = 31556889864403199L;

    private JSR310Utils() {
    }

    public static LocalDate valueToLocalDate(Value value, CastDataProvider provider) {
        long dateValue = value.convertToDate(provider).getDateValue();
        if (dateValue > 511999999903L) {
            return LocalDate.MAX;
        }
        if (dateValue < -511999999455L) {
            return LocalDate.MIN;
        }
        return LocalDate.of(DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue));
    }

    public static LocalTime valueToLocalTime(Value value, CastDataProvider provider) {
        return LocalTime.ofNanoOfDay(((ValueTime)value.convertTo(TypeInfo.TYPE_TIME, provider)).getNanos());
    }

    public static LocalDateTime valueToLocalDateTime(Value value, CastDataProvider provider) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(TypeInfo.TYPE_TIMESTAMP, provider);
        return JSR310Utils.localDateTimeFromDateNanos(valueTimestamp.getDateValue(), valueTimestamp.getTimeNanos());
    }

    public static Instant valueToInstant(Value value, CastDataProvider provider) {
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value.convertTo(TypeInfo.TYPE_TIMESTAMP_TZ, provider);
        long timeNanos = valueTimestampTimeZone.getTimeNanos();
        long epochSecond = DateTimeUtils.absoluteDayFromDateValue(valueTimestampTimeZone.getDateValue()) * 86400L + timeNanos / 1000000000L - (long)valueTimestampTimeZone.getTimeZoneOffsetSeconds();
        if (epochSecond > 31556889864403199L) {
            return Instant.MAX;
        }
        if (epochSecond < -31557014167219200L) {
            return Instant.MIN;
        }
        return Instant.ofEpochSecond(epochSecond, timeNanos % 1000000000L);
    }

    public static OffsetDateTime valueToOffsetDateTime(Value value, CastDataProvider provider) {
        ValueTimestampTimeZone v = (ValueTimestampTimeZone)value.convertTo(TypeInfo.TYPE_TIMESTAMP_TZ, provider);
        return OffsetDateTime.of(JSR310Utils.localDateTimeFromDateNanos(v.getDateValue(), v.getTimeNanos()), ZoneOffset.ofTotalSeconds(v.getTimeZoneOffsetSeconds()));
    }

    public static ZonedDateTime valueToZonedDateTime(Value value, CastDataProvider provider) {
        ValueTimestampTimeZone v = (ValueTimestampTimeZone)value.convertTo(TypeInfo.TYPE_TIMESTAMP_TZ, provider);
        return ZonedDateTime.of(JSR310Utils.localDateTimeFromDateNanos(v.getDateValue(), v.getTimeNanos()), ZoneOffset.ofTotalSeconds(v.getTimeZoneOffsetSeconds()));
    }

    public static OffsetTime valueToOffsetTime(Value value, CastDataProvider provider) {
        ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value.convertTo(TypeInfo.TYPE_TIME_TZ, provider);
        return OffsetTime.of(LocalTime.ofNanoOfDay(valueTimeTimeZone.getNanos()), ZoneOffset.ofTotalSeconds(valueTimeTimeZone.getTimeZoneOffsetSeconds()));
    }

    public static Period valueToPeriod(Value value) {
        if (!(value instanceof ValueInterval)) {
            value = value.convertTo(TypeInfo.TYPE_INTERVAL_YEAR_TO_MONTH);
        }
        if (!DataType.isYearMonthIntervalType(value.getValueType())) {
            throw DbException.get(22018, (Throwable)null, value.getString());
        }
        ValueInterval v = (ValueInterval)value;
        IntervalQualifier qualifier = v.getQualifier();
        boolean negative = v.isNegative();
        long leading = v.getLeading();
        long remaining = v.getRemaining();
        int y = Value.convertToInt(IntervalUtils.yearsFromInterval(qualifier, negative, leading, remaining), null);
        int m = Value.convertToInt(IntervalUtils.monthsFromInterval(qualifier, negative, leading, remaining), null);
        return Period.of(y, m, 0);
    }

    public static Duration valueToDuration(Value value) {
        if (!(value instanceof ValueInterval)) {
            value = value.convertTo(TypeInfo.TYPE_INTERVAL_DAY_TO_SECOND);
        }
        if (DataType.isYearMonthIntervalType(value.getValueType())) {
            throw DbException.get(22018, (Throwable)null, value.getString());
        }
        BigInteger[] dr = IntervalUtils.intervalToAbsolute((ValueInterval)value).divideAndRemainder(BigInteger.valueOf(1000000000L));
        return Duration.ofSeconds(dr[0].longValue(), dr[1].longValue());
    }

    public static ValueDate localDateToValue(LocalDate localDate) {
        return ValueDate.fromDateValue(DateTimeUtils.dateValue(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()));
    }

    public static ValueTime localTimeToValue(LocalTime localTime) {
        return ValueTime.fromNanos(localTime.toNanoOfDay());
    }

    public static ValueTimestamp localDateTimeToValue(LocalDateTime localDateTime) {
        LocalDate localDate = localDateTime.toLocalDate();
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValue(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()), localDateTime.toLocalTime().toNanoOfDay());
    }

    public static ValueTimestampTimeZone instantToValue(Instant instant) {
        long epochSecond = instant.getEpochSecond();
        int nano = instant.getNano();
        long absoluteDay = epochSecond / 86400L;
        if (epochSecond < 0L && absoluteDay * 86400L != epochSecond) {
            --absoluteDay;
        }
        long timeNanos = (epochSecond - absoluteDay * 86400L) * 1000000000L + (long)nano;
        return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), timeNanos, 0);
    }

    public static ValueTimestampTimeZone offsetDateTimeToValue(OffsetDateTime offsetDateTime) {
        LocalDateTime localDateTime = offsetDateTime.toLocalDateTime();
        LocalDate localDate = localDateTime.toLocalDate();
        return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValue(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()), localDateTime.toLocalTime().toNanoOfDay(), offsetDateTime.getOffset().getTotalSeconds());
    }

    public static ValueTimestampTimeZone zonedDateTimeToValue(ZonedDateTime zonedDateTime) {
        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
        LocalDate localDate = localDateTime.toLocalDate();
        return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValue(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()), localDateTime.toLocalTime().toNanoOfDay(), zonedDateTime.getOffset().getTotalSeconds());
    }

    public static ValueTimeTimeZone offsetTimeToValue(OffsetTime offsetTime) {
        return ValueTimeTimeZone.fromNanos(offsetTime.toLocalTime().toNanoOfDay(), offsetTime.getOffset().getTotalSeconds());
    }

    private static LocalDateTime localDateTimeFromDateNanos(long dateValue, long timeNanos) {
        if (dateValue > 511999999903L) {
            return LocalDateTime.MAX;
        }
        if (dateValue < -511999999455L) {
            return LocalDateTime.MIN;
        }
        return LocalDateTime.of(LocalDate.of(DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue)), LocalTime.ofNanoOfDay(timeNanos));
    }

    public static ValueInterval periodToValue(Period period) {
        IntervalQualifier qualifier;
        int days = period.getDays();
        if (days != 0) {
            throw DbException.getInvalidValueException("Period.days", days);
        }
        int years = period.getYears();
        int months = period.getMonths();
        boolean negative = false;
        long leading = 0L;
        long remaining = 0L;
        if (years == 0) {
            if ((long)months == 0L) {
                qualifier = IntervalQualifier.YEAR_TO_MONTH;
            } else {
                qualifier = IntervalQualifier.MONTH;
                leading = months;
                if (leading < 0L) {
                    leading = -leading;
                    negative = true;
                }
            }
        } else if ((long)months == 0L) {
            qualifier = IntervalQualifier.YEAR;
            leading = years;
            if (leading < 0L) {
                leading = -leading;
                negative = true;
            }
        } else {
            qualifier = IntervalQualifier.YEAR_TO_MONTH;
            leading = years * 12 + months;
            if (leading < 0L) {
                leading = -leading;
                negative = true;
            }
            remaining = leading % 12L;
            leading /= 12L;
        }
        return ValueInterval.from(qualifier, negative, leading, remaining);
    }

    public static ValueInterval durationToValue(Duration duration) {
        long seconds = duration.getSeconds();
        int nano = duration.getNano();
        boolean negative = seconds < 0L;
        seconds = Math.abs(seconds);
        if (negative && nano != 0) {
            nano = 1000000000 - nano;
            --seconds;
        }
        return ValueInterval.from(IntervalQualifier.SECOND, negative, seconds, nano);
    }
}

